package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateQueryPriceTradeCreateReq implements Serializable {
    private static final long serialVersionUID = -7111157836866913460L;
    /**
     * 锁汇流水号
     */
    private String lockNo;

    /**
     * 询价流水号
     */
    private String queryNo;

    /**
     * 店铺ID
     */
    private String subAcctNo;

    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 买入金额
     */
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    private String sellCur;

    /**
     * 卖出金额
     */
    private BigDecimal sellAmt;
    /**
     * 手续费金额
     */
    private BigDecimal feeAmt;
    /**
     * 手续费币种
     */
    private String feeCur;

    /**
     * 支付总金额
     */
    private BigDecimal payAmt;

    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 询价汇率
     */
    private BigDecimal queryRate;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 备注
     */
    private String remark;
}