package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateBankTradeOutReq implements Serializable {
    private static final long serialVersionUID = 1360251195634827496L;

    /**
     * 锁汇流水号-合作方
     */
    @NotBlank(message = "锁汇流水号不能为空")
    private String lockNo;

    /**
     * 锁汇交易编号 寻汇-锁汇返回流水号，识别锁汇交易
     */
    @NotBlank(message = "锁汇交易编号不能为空")
    private String txnNo;

    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 受益人编号
     */
    @NotBlank(message = "受益人编号不能为空")
    private String beneficiaryId;

    /**
     * 受益人名称
     */
    @NotBlank(message = "受益人名称不能为空")
    private String beneficiaryName;

    /**
     * 受益人账户号码
     */
    @NotBlank(message = "受益人账户号码不能为空")
    private String beneficiaryAcctNo;

    /**
     * 出账币种
     */
    @NotBlank(message = "出账币种不能为空")
    private String payCur;

    /**
     * 出账金额
     */
    @NotNull(message = "出账金额不能为空")
    private BigDecimal payAmt;

    /**
     * 处理状态
     */
    private ProcessStatusEnum processStatusEnum;
}