package com.js.common.model.req;

import com.js.common.enums.RegisterType;
import lombok.Data;

import java.io.Serializable;

/**
 * 贷款准入
 * zhouyongsheng
 */
@Data
public class JsLoanRiskInfoReq  implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 准入申请编号
     */
    private String riskNo;

    /**
     * KYC注册ID
     */
    private String kycNaturalId;

    /** KYC类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）*/
    private RegisterType registerType;

    /**
     * 借款人类型
     * 借款人为企业（1.法人2.持股比例超过51%（含）以上的个人股东）
     *
     */
    private String borrowerType;

    /**
     * 借款人姓名
     */
    private String borrowerName;

    /**
     * 借款人手机号
     */
    private String borrowerPhone;

    /**
     * 借款人身份证号
     */
    private String borrowerIdcard;

    /**
     * 借款人邮箱
     */
    private String borrowerEmail;

    /**
     * 借款人婚姻状态
     * 1.已婚 2.未婚 3.离异 4.再婚
     */
    private String marriageStatus;

    /**
     * 借款人同事联系方式
     */
    private String borrowerColleague;

    /**
     * 借款人现家庭住址
     */
    private String borrowerAddress;

    /**
     * 人行征信注册账号
     */
    private String creditReportingNo;

    /**
     * 人行征信登录密码
     */
    private String creditReportingPassword;

    /**
     * 人行征信身份验证码
     */
    private String creditReportingAuthcode;

    /**
     * 人行征信报告OSS地址
     */
    private String creditReportingOss;

    /**
     * 担保人类型 （1.法人2.持股比例超过51%（含）以上的个人股东）
     */
    private String guaranteeType;

    /**
     * 担保企业名称
     */
    private String guaranteeCorp;

    /**
     * 担保企业统一信用代码
     */
    private String guaranteeCorpOrgcode;

    /**
     * 担保企业实际经营地址
     */
    private String guaranteeCorpAddress;

    /**
     * 担保企业证明材料
     */
    private String guaranteeCorpQualification;

    /**
     * 担保企业法人身份证正面
     */
    private String guaranteeLegalnameFront;

    /**
     * 担保企业法人身份证反面
     */
    private String guaranteeLegalnameBack;

    /**
     * 担保企业法人姓名
     */
    private String guaranteeCorpLegalname;

    /**
     * 担保企业法人证件号码
     */
    private String guaranteeCorpIdcard;

    /**
     * 担保企业法人手机号
     */
    private String guaranteeCorpPhone;

    /**
     * 担保企业法人邮箱
     */
    private String guaranteeCorpEmail;

    /**
     * 担保企业法人身份证有效期
     */
    private String guaranteeIdcardValid;

    /**
     * 担保企业法人家庭住址
     */
    private String guaranteeLegalHomeAddress;

    /**
     * 担保企业法人办公地址
     */
    private String guaranteeLegalOfficeAddress;

    /**
     * 企业对公账号
     */
    private String corpAcct;

    /**
     * 对公开户行
     */
    private String corpAcctBank;

    /**
     * 对公开户行支行
     */
    private String corpAcctBranchBank;


}