package com.js.common.model.req;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsLoanApplyInfoReq implements Serializable {
    private static final long serialVersionUID = 122173851639481470L;
    /**
     * 贷款申请编号
     */
    private String loanNo;

    /**
     * KYC注册ID
     */
    private String kycNaturalId;

    /**
     * 申请人名称
     */
    private String name;

    /**
     * 申请人手机号
     */
    private String phone;

    /**
     * 意向贷款金额
     */
    private BigDecimal applyAmt;

    /**
     * 申请贷款时间
     */
    private Date applyDate;


    /**
     * 借款天数
     */
    private Integer loanDays;


    /**
     * 最早还款时间
     */
    private Date firstRepayTime;

    /**
     * 最晚还款时间
     */
    private Date lastRepayTime;

    /**
     * 还款方式
     */
    private String repayType;


    /**
     * 收款账户名称
     */
    private String acctName;

    /**
     * 收款账户号
     */
    private String acctNo;
}