package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 个人汇付开户
 */
@Data
@ApiModel(value="个人开户（ChinaPNRPersonalOpenAccountReq）",description="个人开户对象")
public class ChinaPNRPersonalOpenAccountReq implements Serializable {

    private static final long serialVersionUID = -1513703756018851418L;
    /**
     * 用户ID
     */
    @NotBlank(message = "用户ID不能为空")
    @ApiModelProperty(value = "用户ID")
    private String kycNaturalId;
    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String  requestId;
    /**
     * 用户注册时间20190614155601
     */
    @ApiModelProperty(value = "用户注册时间")
    private String  platformRegTime;
    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String  name;
    /**
     * 00－身份证（目前仅支持00）
     * 01－护照
     * 02－军官证
     * 03－士兵证
     * 04－回乡证
     * 06－警官证
     * 08－台胞证
     * 13－其他
     */
    @ApiModelProperty(value = "证件类型")
    private String  certType;
    /**
     * 号码
     */
    @ApiModelProperty(value = "号码")
    private String  certId;
    /**
     * 证件失效日期
     */
    @ApiModelProperty(value = "证件失效日期")
    private String  certExpDateEnd;
    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String  mobileNumber;
    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String  address;
    /**
     * 邮件
     */
    @ApiModelProperty(value = "邮件")
    private String  email;
    /**
     * 银行编码
     */
    @ApiModelProperty(value = "银行编码")
    private String  bankCode;
    /**
     * 账户号
     */
    @ApiModelProperty(value = "账户号")
    private String bankAcct;
    /**
     * 账户名称
     */
    @ApiModelProperty(value = "账户名称")
    private String  acctName;
    /**
     * 证件影印件正面地址
     */
    @ApiModelProperty(value = "证件影印件正面地址")
    private String  certPhotoCopyF;
    /**
     * 证件影印件反面地址
     */
    @ApiModelProperty(value = "证件影印件反面地址")
    private String  certPhotoCopyB;

    /**
     * 开户号
     */
    private String jsOpenAccountNo;

}
