package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 流水表交易类型
 * @Author: liuh
 * @Create: 2019-06-04
 **/
@Getter
public enum TradeSubTypeEnum {
    SUB_TRADE_IN(0, "子账户入账"),
    REPAYMENT(1, "还款"),
    WITHDRAW(2, "提现"),
    WITHDRAW_FEE(3, "提现手续费"),
    LATE_FEE(4, "逾期费"),
    ;
    /** 编码 */
    private Integer enumCode;
    /** 说明 */
    private String enumName;

    TradeSubTypeEnum(Integer enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }
}
