package com.js.common.enums;

/**
 * @Author liuh
 * @Description 不同账户可申请账户数
 * @Date 2019/6/5
 **/
public enum SiteEnum {
    NORTH_AMERICA_SITE(1,"USD","北美站","$","美元"),
    CANASA_SITE(2,"CAD","加拿大站","C$","加元"),
    ENGLAND_SITE(3,"GBP","英国站","￡","英镑"),
    EUROPE_SITE_FRENCH(4,"EUR","欧洲站-法国","€","欧元"),
    EUROPE_SITE_GERMANY(5,"EUR","欧洲站-德国","€","欧元"),
    EUROPE_SITE_ITALY(6,"EUR","欧洲站-意大利","€","欧元"),
    EUROPE_SITE_SPAIN(7,"EUR","欧洲站-西班牙","€","欧元"),
    JSPAN_SITE(8,"JPY","日本站","¥","日元"),
    ;
    private Integer code;
    private String currency;
    private String siteName;
    /**
     * 币种符号
     */
    private String currencySymbol;
    /**
     * 币种单位
     */
    private String hyDesc;

    SiteEnum(Integer code,String currency,String siteName,String currencySymbol,String hyDesc) {
        this.code = code;
        this.currency = currency;
        this.siteName = siteName;
        this.currencySymbol = currencySymbol;
        this.hyDesc = hyDesc;
    }

    public static SiteEnum getByCurrency(String currency){
        for(SiteEnum siteEnum : SiteEnum.values()){
            if(currency.equals(siteEnum.getCurrency())){
                return siteEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getCurrency() {
        return currency;
    }

    public String getSiteName() {
        return siteName;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public String getHyDesc() {
        return hyDesc;
    }
}
