package com.js.common.enums;

/**
 * @Author yjzhao
 * @Description 返回码常量
 * @Date 2019/5/15 20:15
 * @Param
 * @return
 **/
public enum ResultEnum {

    /** 常见返回码 Start: 0*/
    SUCCESS(0, "success"),
    ERROR(-999, "error"),
    LOGIN_SUCCESS(1,"登录成功"),
    LOGIN_ERROR(-1, "登陆失败"),
    REGISTE_SUCCESS(2, "注册成功"),
    REGISTE_ERROR(-2, "注册失败"),
    USER_NOT_EXIST(-3, "不存在该用户"),
    USER_DISABLE(-7, "用户已禁用"),
    MESSAGE_NOT_EXIST(-8,"信息不存在"),
    USER_TOKEN_FAILURE(-9, "登陆已失效.请重新登录."),
    FILE_DELETE_SUCCESS(10, "文件删除成功."),
    FILE_DELETE_ERROR(-10, "文件删除失败."),
    FILE_UPLOAD_SUCCESS(11, "文件上传成功."),
    FILE_UPLOAD_ERROR(-11, "文件上传失败."),
    MESSAGE_EXIST(-12,"信息已存在"),
    VALIDATE_CODE_SUCC(13,"验证码验证成功"),
    VALIDATE_CODE_ERROT(-13,"验证码验证失败"),
    USER_DISABLE_ERROR(-14,"用户已禁用"),
    EMAIL_EXISTS_ERROR(-15,"邮箱被占用"),
    MOBILE_EXISTS_ERROR(-16,"手机号被占用"),
    FILE_DOWNLOAD_SUCCESS(17, "文件下载成功."),
    FILE_DOWNLOAD_ERROR(-17, "文件下载失败."),
    SEND_VALIDATE_CODE_SUCCESS(18, "验证码发送成功"),
    SEND_VALIDATE_CODE_ERROR(-18, "验证码发送失败"),
    LOGOUT_SUCCESS(19, "退出成功"),
    LOGOUT_ERROR(-19, "退出失败"),
    PWD_REGEX_ERROR_TWO(20, "两次密码不一致"),
    PWD_REGEX_ERROR(-20, "密码格式错误"),
    EMAIL_REGEX_ERROR(-21, "邮箱格式错误"),
    PHONE_REGEX_ERROR(-22, "手机格式错误"),
    CHANGE_PWD_SUCCESS(23, "更改密码成功"),
    CHANGE_PWD_ERROR(-23, "更改密码失败"),
    VALIDATE_CODE_EXISTS_ERROR(-24, "验证码不能为空"),
    NO_MUST_PARAM_ERROR(-25, "参数不正确"),
    SEND_EMAIL_SUCCESS(26, "发送邮件成功"),
    END_EMAIL_ERROR(-26, "发送邮件失败"),
    EFFECTIVE_TIME_ERROR(-27, "身份证有效截止日期不能小于起始日期"),
    SEND_ALREADY(-28,"信息通知已执行过,请确认"),
    QUERY_PRICE_FAILURE(-29,"询价失败"),
    /** 常见返回码 End: 999*/

    /** 数据操作通用相关 Start: 10001 */
    QUERY_SUCCESS(10001,"查询成功"),
    QUERY_ERROR(-10001,"查询失败"),
    DELETE_SUCCESS(10002,"删除成功"),
    DELETE_ERROR(-10002,"删除失败"),
    UPDATE_SUCCESS(10003,"更新成功"),
    UPDATE_ERROR(-10003,"更新失败"),
    SAVE_SUCCESS(10004,"保存成功"),
    SAVE_ERROR(-10004,"保存失败"),
    ILLEGAL_CHARACTER(-10005, "非法字符，包含敏感字符"),
    /** 数据操作通用相关 End: 20000 */

    /** 系统相关 Start: 100001*/
    SYSTEM_ERROR(-100001,"系统繁忙，请稍后再试"),
    UNKNOW_ERROR(-100002,"未知错误"),

    /** 系统相关 End: 999999 */

    /** js支付 相关错误 Start：1001*/
    GET_PWD_KEY_SUCCESS(1001, "密码加密key获取成功"),
    GET_PWD_KEY_ERROR(-1001, "密码加密key获取失败"),
    CERTI_FAILURE(-1002, "实名认证失败,暂不可以申请虚拟账户"),
    CERTI_WATRING(-1003, "实名认证未完成,暂不可以申请虚拟账户"),
    AUDIT_STORE_NOT_COMPLETE(-1004, "存在审核未完成店铺,请等待完成后再次申请"),
    CHECK_AUTH_TOKEN_SUCCESS(1005, "店铺授权信息校验通过"),
    CHECK_AUTH_TOKEN_FAILURE(-1005, "店铺授权信息校验失败"),
    BANK_CHECK_SUCCESS(1006, "银行卡要素验证成功"),
    BANK_CHECK_FAILURE(-1006, "银行卡要素验证失败"),
    ALREADY_TO_MAX_APPLY_COUNT(-1007, "暂无店铺申请虚拟账户已经达到最大限制，请授权未授权的店铺"),
    /** js支付 相关错误 End：2000*/
    /** js借贷 相关错误 Start：2001*/
    /** js借贷 相关错误 End：3000*/

    /***汇付支付相关**/
    CHINA_PNR_SUCCESS(4000, "汇付支付成功"),
    CHINA_PNR_ERROR(4001, "汇付支付失败"),

    /***汇付支付相关**/
    CHINA_PNR_OPEND_ACCOUNT_SUCCESS(4000, "开户申请成功"),
    CHINA_PNR_OPEND_ACCOUNT_ERROR(4001, "开户失败"),
    ;

    private Integer code;

    private String msg;

    ResultEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
