package com.js.common.enums;

import cn.hutool.core.util.EnumUtil;
import lombok.Getter;

import java.util.Map;

/**
 * @ClassName: FileType
 * @Description: 文件类型
 * @Author: yjzhao
 * @Create: 2019-05-18  09:28
 **/
@Getter
public enum FileType {
    /** 文档 */
    DOCUMENT(0, "文档"),
    /** 图片 */
    IMAGE(1, "图片"),
    /** 视频 */
    VIDEO(2, "视频"),
    /** 其他 */
    OTHER(3, "其他"),
    ;
    /** 编码 */
    private Integer enumCode;
    /** 说明 */
    private String enumName;
    private FileType(Integer enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }

    /**
     * @Author yjzhao
     * @Description 根据index 获取枚举
     * @Date 2019/5/18 9:40
     * @Param [index]
     * @return com.js.common.enums.FileType
     **/
    public static FileType getFileTypeByIndex(int index) {
        for (FileType c : FileType.values()) {
            if (c.ordinal()==index) {
                return c;
            }
        }
        return null;
    }
}
