package com.js.common.enums;

import lombok.Getter;

/**
 * @ClassName: FileResourceType
 * @Description: 文件来源类型
 * @Author: yjzhao
 * @Create: 2019-05-18  09:44
 **/
@Getter
public enum FileResourceType {
    /** 通用 */
    COMMON(0, "通用"),

    /** 实名证件 */
    REAL_NAME_CERTIFICATE(1, "实名证件"),

    /** 合同模板*/
    CONTRACT_TEMPLATE(2, "合同模板"),

    /** 合同文件 */
    CONTRACT_FILE(3, "合同文件"),

    /** 生成交易报表 */
    TRADE_REPORT(4,"生成交易报表"),
    ;

    /** 编码 */
    private Integer enumCode;
    /** 说明 */
    private String enumName;
    private FileResourceType(Integer enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }

    /**
     * @Author yjzhao
     * @Description 根据index 获取枚举
     * @Date 2019/5/18 9:40
     * @Param [index]
     * @return com.js.common.enums.FileType
     **/
    public static FileResourceType getFileResourceTypeByIndex(int index) {
        for (FileResourceType c : FileResourceType.values()) {
            if (c.ordinal()==index) {
                return c;
            }
        }
        return null;
    }
}
