package com.js.common.enums;

/**
 * @Author liuh
 * @Description 实名认证状态常量值
 * @Date 2019/5/25
 **/
public enum CertiStatusEnum {

    SUBMIT_FAILURE(4, "调用寻汇返回失败","等待运营人员处理"),
    NO_SUBMIT(0, "未提交认证信息","等待提交实名信息"),
    FAILURE(2, "认证失败","等待运营沟通"),
    SUCCESS(1, "已认证","实名认证通过"),
    SUBMIT_WATING(3, "认证审核中","等待审核结果"),
    ;

    private Integer code;
    private String doDesc;
    private String toDesc;

    CertiStatusEnum(Integer code, String doDesc,String toDesc) {
        this.code = code;
        this.doDesc = doDesc;
        this.toDesc = toDesc;
    }

    public static CertiStatusEnum get(Integer code){
        if(null == code){
            return null;
        }
        for(CertiStatusEnum certiStatusEnum : CertiStatusEnum.values()){
            if(code == certiStatusEnum.getCode()){
                return certiStatusEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDoDesc() {
        return doDesc;
    }

    public String getToDesc() {
        return toDesc;
    }
}
