package com.js.common.enums;

/**
 * 亚马逊各地区端口
 *
 * 数据取自：http://docs.developer.amazonservices.com/en_US/dev_guide/DG_Endpoints.html
 */
public enum AmazonEndpointEnum {
    BRAZIL("Brazil", "BR", "https://mws.amazonservices.com", "A2Q3Y263D00KWC"),
    CANADA("Canada", "CA", "https://mws.amazonservices.ca", "A2EUQ1WTGCTBG2"),
    MEXICO("Mexico", "MX", "https://mws.amazonservices.com.mx", "A1AM78C64UM0Y8"),
    US("US", "US", "https://mws.amazonservices.com", "ATVPDKIKX0DER"),
    UNITED_ARAB_EMIRATES ("UnitedArabEmirates", "AE", "https://mws.amazonservices.ae", "A2VIGQ35RCS4UG"),
    GERMANY("Germany", "DE", "https://mws-eu.amazonservices.com", "A1PA6795UKMFR9"),
    SPAIN("Spain", "ES", "https://mws-eu.amazonservices.com", "A1RKKUPIHCS9HS"),
    FRANCE("France", "FR", "https://mws-eu.amazonservices.com", "A13V1IB3VIYZZH"),
    UK("UK", "GB", "https://mws-eu.amazonservices.com", "A1F83G8C2ARO7P"),
    INDIA("India", "IN", "https://mws.amazonservices.in", "A21TJRUUN4KGV"),
    ITALY("Italy", "IT", "https://mws-eu.amazonservices.com", "APJ6JRA9NG5V4"),
    TURKEY("Turkey", "TR", "https://mws-eu.amazonservices.com", "A33AVAJ2PDY3EV"),
    AUSTRALIA("Australia", "AU", "https://mws.amazonservices.com.au", "A39IBJ37TRP1C6"),
    JAPAN("Japan", "JP", "https://mws.amazonservices.jp", "A1VC38T7YXB528"),
    CHINA("China", "CN", "https://mws.amazonservices.com.cn", "AAHKV2X7AFYLW");

    String marketplace;
    String countryCode;
    String endpoint;
    String marketPlaceId;

    AmazonEndpointEnum(String marketplace, String countryCode, String endpoint, String marketPlaceId) {
        this.marketplace = marketplace;
        this.countryCode = countryCode;
        this.endpoint = endpoint;
        this.marketPlaceId = marketPlaceId;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public String getMarketPlaceId() {
        return marketPlaceId;
    }
}
