package com.js.common.constant;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by liuh on 2019/6/5.
 */
public class CommonConstant {

    /** 定义寻汇通知时创建者ID */
    public static final String SUNRATE_CREATE_ID = "SUNRATE";

    /** 定义寻汇通知时创建者名称 */
    public static final String SUNRATE_CREATE_NAME ="SUNRATE:";

    /** 定义发送短信templateType */
    public static final String SEND_SMS_TEMPLATE_TYPE = "SMS";
    /** 定义发送短信templateInnerId */
    public static final String SEND_SMS_TEMPLATE_INNER_ID = "verCode";

    /**
     * 调用寻汇锁汇接口交易金额最小值
     */
    public static final BigDecimal SURATE_TRADE_MIN_AMT = new BigDecimal(10);

    /**
     * 汇差差值-数据库如果不配置用户汇差则取此默认值
     */
    public static final BigDecimal JS_TRADE_RATE_VALUE = new BigDecimal(0.02);
    /**
     * 手续费差值-数据库如果不配置用户手续费则取此默认值
     */
    public static final BigDecimal JS_TRADE_SERVICE_CHARGE_VALUE = new BigDecimal(0.0007);

    /**
     * 人民币币种
     */
    public static final String TRADE_CURRENCY_CNY = "CNY";

    /**
     * 离岸人民币币种
     */
    public static final String TRADE_CURRENCY_CNH = "CNH";

    /**
     * 个人标识
     */
    public static final String TYPE_PERSONAL = "SELF";

    /**
     * 企业标识
     */
    public static final String TYPE_COMPANY = "COMPANY";

    /**
     * 交易模式-买入模式
     */
    public static final String TXN_MODE_BUY = "0";

    /**
     * 交易模式-卖出模式
     */
    public static final String TXN_MODE_SELL = "1";


    /**
     * 每页限制数据条数
     */
    public static final Integer PAGE_SIXE = 5;

    /**
     * 暂无店铺或者暂无产品类型最大可申请虚拟店铺数量
     */
    public static final Integer NO_STORE_MAX_APPLY_COUNT = 3;

    /**
     * 请求寻汇交易状态
     */
    public static final String SEND_SUNRATE_TXN_STATUS = "99";

    /**
     * 身份证为长期的日期时间
     */
    public static final String effectiveDate = "9999-12-31";

    public static Date longFormatDate(){
        try{
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(effectiveDate);
        }catch (Exception ex){
            System.out.println("日期異常");
        }
        return null;
    }
}
