DROP TABLE IF EXISTS kyc_natural;
CREATE TABLE `kyc_natural` (
  `id` varchar(32) NOT NULL,
  `register_type` varchar(32) DEFAULT 'NONE_TYPE' COMMENT '注册类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）',
  `certification_name` varchar(20) DEFAULT '' COMMENT '实名名称（类型为个人填写客户姓名，类型为企业填写企业名称）',
  `id_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '证件号',
  `phone_no` varchar(20) DEFAULT '' COMMENT '注册手机号',
  `email` varchar(50) DEFAULT '' COMMENT '注册邮箱',
  `email_active_flag` tinyint(1) unsigned DEFAULT '0' COMMENT '邮箱是否激活(0:未激活, 1:已激活)',
  `certification_status` varchar(32) DEFAULT 'NO_SUBMIT' COMMENT '实名认证状态 默认-未提交实名认证状态',
  `js_remark` varchar(300) DEFAULT '' COMMENT '备注',
  `record_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否通过经营者备案[1是，0否]',
  `sex` varchar(10) DEFAULT '' COMMENT '性别(MALE-男，FEMALE-女)',
  `invite_code` varchar(45) DEFAULT '' COMMENT '邀请人',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '注册日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户信息表';

DROP TABLE IF EXISTS kyc_password;
CREATE TABLE `kyc_password` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `password_login` varchar(100) DEFAULT '' COMMENT '登录密码报文',
  `password_pay` varchar(100) DEFAULT '' COMMENT '支付密码报文',
  `js_remark` varchar(200) DEFAULT '' COMMENT '备注',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='秘钥安全验证表';

DROP TABLE IF EXISTS kyc_security;
CREATE TABLE `kyc_security` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `kyc_dictionary_id` varchar(32) DEFAULT '' COMMENT '字典表主键ID',
  `security_key` varchar(100) DEFAULT '' COMMENT '问题',
  `security_value` varchar(100) DEFAULT '' COMMENT '问题答案',
  `js_remark` varchar(200) DEFAULT '' COMMENT '备注',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='密保安全验证表';

DROP TABLE IF EXISTS kyc_certi_mainland_personal;
CREATE TABLE `kyc_certi_mainland_personal` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `id_type` varchar(20) DEFAULT '' COMMENT '证件类型（1-第二代身份证）',
  `id_type_name` varchar(20) DEFAULT '' COMMENT '证件类型名称（1-第二代身份证）',
  `cus_name` varchar(50) DEFAULT '' COMMENT '客户真实姓名',
  `id_no` varchar(32) DEFAULT '' COMMENT '身份证号',
  `live_address` varchar(100) DEFAULT '' COMMENT '个人住址',
  `effective_start_time` date DEFAULT '0001-01-01' COMMENT '身份证有效起始日期',
  `effective_end_time` date DEFAULT '0001-01-01' COMMENT '身份证有效截止日期',
  `long_flag` tinyint(1) unsigned not null COMMENT '是否长期有效(0:非长期，1：长期)',
  `store_business_type_id` varchar(32) DEFAULT '' COMMENT '店铺主要经营类别表ID',
  `store_business_type_name` varchar(100) DEFAULT '' COMMENT '店铺主要经营类别名称',
  `status` varchar(32) DEFAULT 'NO_SUBMIT' COMMENT '状态',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建人ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新人ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='大陆-个人信息表';

DROP TABLE IF EXISTS kyc_certi_mainland_company;
CREATE TABLE `kyc_certi_mainland_company` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `company_name` varchar(50) DEFAULT '' COMMENT '企业名称',
  `company_eng_name` varchar(100) DEFAULT '' COMMENT '企业英文名称',
  `unified_social_credit_code` varchar(50) DEFAULT '' COMMENT '统一社会信用代码',
  `company_nature_id` varchar(32) DEFAULT '' COMMENT '企业性质ID',
  `company_nature_name` varchar(100) DEFAULT '' COMMENT '企业性质名称',
  `company_address` varchar(100) DEFAULT '' COMMENT '企业经营地址',
  `biz_license_exp_date_start` date DEFAULT '0001-01-01' COMMENT '营业执照生效日期',
  `biz_license_exp_date_end` date DEFAULT '0001-01-01' COMMENT '营业执照失效日期',
  `store_business_type_id` varchar(32) DEFAULT '' COMMENT '店铺主要经营类别表ID',
  `store_business_type_name` varchar(100) DEFAULT '' COMMENT '店铺主要经营类别名称',
  `legal_representative_id_type` varchar(100) DEFAULT '' COMMENT '法定代表人证件类型ID',
  `legal_representative_id_type_name` varchar(100) DEFAULT '' COMMENT '法定代表人证件类型名称',
  `legal_representative_name` varchar(100) DEFAULT '' COMMENT '法定代表人姓名',
  `legal_representative_id_no` varchar(100) DEFAULT '' COMMENT '法定代表人证件号',
  `legal_representative_address` varchar(100) DEFAULT '' COMMENT '法定代表人住址',
  `effective_start_time` date DEFAULT '0001-01-01' COMMENT '身份证有效起始日期',
  `effective_end_time` date DEFAULT '0001-01-01' COMMENT '身份证有效截止日期',
  `long_flag` tinyint(1) unsigned not null COMMENT '是否长期有效(0:非长期，1：长期)',
  `status` varchar(32) DEFAULT 'NO_SUBMIT' COMMENT '状态',
  `create_id` varchar(32) DEFAULT '',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='大陆-企业信息表';

DROP TABLE IF EXISTS kyc_certi_hk_personal;
CREATE TABLE `kyc_certi_hk_personal` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `id_type` varchar(20) DEFAULT '' COMMENT '证件类型',
  `id_type_name` varchar(20) DEFAULT '' COMMENT '证件类型名称',
  `cus_name` varchar(50) DEFAULT '' COMMENT '真实姓名',
  `cus_eng_name` varchar(50) DEFAULT '' COMMENT '英文名称',
  `certificate_no` varchar(32) DEFAULT '' COMMENT '证件号码',
  `address` varchar(100) DEFAULT '' COMMENT '地址',
  `store_business_type_id` varchar(32) DEFAULT '' COMMENT '店铺主要经营类别表ID',
  `store_business_type_name` varchar(100) DEFAULT '' COMMENT '店铺主要经营类别名称',
  `status` varchar(32) DEFAULT 'NO_SUBMIT' COMMENT '状态',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='香港-个人信息表';

DROP TABLE IF EXISTS kyc_certi_hk_company;
CREATE TABLE `kyc_certi_hk_company` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `company_name` varchar(50) DEFAULT '' COMMENT '企业名称',
  `company_eng_name` varchar(50) DEFAULT '' COMMENT '企业英文名称',
  `company_registered_certificate_no` varchar(18) DEFAULT '' COMMENT '公司注册证书编号',
  `company_nature_id` varchar(32) DEFAULT '' COMMENT '企业性质ID',
  `company_nature` varchar(50) DEFAULT '' COMMENT '企业性质',
  `company_address` varchar(100) DEFAULT '' COMMENT '企业经营地址',
  `store_business_type_id` varchar(32) DEFAULT '' COMMENT '店铺主要经营类别表ID',
  `store_business_type_name` varchar(100) DEFAULT '' COMMENT '店铺主要经营类别名称',
  `director_id_type` varchar(50) DEFAULT '' COMMENT '董事证件类型ID',
  `director_id_type_name` varchar(50) DEFAULT '' COMMENT '董事证件类型名称',
  `director_name` varchar(100) DEFAULT '' COMMENT '董事姓名',
  `director_id_no` varchar(100) DEFAULT '' COMMENT '董事证件号',
  `director_address` varchar(100) DEFAULT '' COMMENT '董事住址',
  `effective_start_time` date DEFAULT '0001-01-01' COMMENT '身份证有效起始日期',
  `effective_end_time` date DEFAULT '0001-01-01' COMMENT '身份证有效截止日期',
  `long_flag` tinyint(1) unsigned COMMENT '是否长期有效(0:非长期，1：长期)',
  `status` varchar(32) DEFAULT 'NO_SUBMIT' COMMENT '状态',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='香港-企业信息表';

DROP TABLE IF EXISTS kyc_certi_link_file;
CREATE TABLE `kyc_certi_link_file` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `pri_id` varchar(32) DEFAULT '' COMMENT '主表主键ID（大陆个人，大陆企业，香港个人，香港企业表主键）',
  `comm_file_id` varchar(50) DEFAULT '' COMMENT 'js文件资源表主键ID',
  `file_save_path` varchar(256) DEFAULT '' COMMENT '存放位置',
  `file_show_path` varchar(256) DEFAULT '' COMMENT '显示位置',
  `file_save_name` varchar(200) DEFAULT '' COMMENT '存放名称',
  `file_show_name` varchar(200) DEFAULT '' COMMENT '显示名称',
  `file_thumbnail_path` varchar(250) NOT NULL DEFAULT '' COMMENT '文件缩略图存放地址',
  `file_ext` varchar(32) DEFAULT '' COMMENT '文件扩展名',
  `file_group` varchar(32) DEFAULT '' COMMENT '文件归类组名',
  `file_type` varchar(32) DEFAULT '' COMMENT '文件具体类型',
  `upload_sftp_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否上传到提供方sftp服务器上（0未上传，1已上传）',
  `upload_dirc` varchar(100) DEFAULT '' COMMENT '上传路径',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='实名表-文件表-中间表';

DROP TABLE IF EXISTS js_kyc_charge;
CREATE TABLE `js_kyc_charge` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '主键ID',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表-用户表-主键ID',
  `store_the_site` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺所在站点',
  `charge_type` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '收费类型(RATE-汇差,SERVICE_CHARGE-手续费)',
  `belong to_type` varchar(4) CHARACTER SET utf8 DEFAULT 'SELF' COMMENT '归属类型（SELF-个人可用，ALL-所有账户可用）',
  `charge_scale` decimal(6,4) NOT NULL DEFAULT '0.00' COMMENT '比例-以精确到小数位计算eg:0.0007',
  `reserved` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '预留字段',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='客户收费比例表';

DROP TABLE IF EXISTS kyc_company_controller;
CREATE TABLE `kyc_company_controller` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `kyc_company_id` varchar(32) DEFAULT '' COMMENT 'kyc企业表主键ID',
  `company_type` int(3) unsigned not NULL COMMENT '企业类型(2:大陆企业，4：香港企业)',
  `controller_name` varchar(100) DEFAULT '' COMMENT '实控人姓名',
  `controller_eng_name` varchar(100) DEFAULT '' COMMENT '实控人英文名姓名',
  `controller_id_type` tinyint(1) unsigned DEFAULT 0 COMMENT '证件类型(0:身份证,1:护照)',
  `controller_id_type_name` varchar(100) DEFAULT '' COMMENT '证件类型名称',
  `controller_id_no` varchar(100) DEFAULT '' COMMENT '实控人证件号',
  `controller_address` varchar(100) DEFAULT '' COMMENT '实控人住址',
  `effective_start_time` datetime DEFAULT 0 COMMENT '身份证有效起始日期',
  `effective_end_time` datetime DEFAULT 0 COMMENT '身份证有效截止日期',
  `long_flag` tinyint(1) unsigned not null COMMENT '是否长期有效(0:非长期，1：长期)',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业-控制人信息表';

DROP TABLE IF EXISTS kyc_certi_audit;
CREATE TABLE `kyc_certi_audit` (
`id`  varchar(32) NOT NULL ,
`kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
`certification_id` varchar(32) DEFAULT '' COMMENT '大陆个人，香港个人，大陆企业，香港企业，认证表主键ID' ,
`certification_type` int(3) unsigned DEFAULT 0 COMMENT '类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）',
`audit_type` int(3) unsigned DEFAULT 0 COMMENT '审核类型（0-初审，1-复审）' ,
`audit_result` tinyint(1) unsigned DEFAULT '3' COMMENT '审核状态（3-初审通过，4-初审驳回，5-初审拒绝，6-复审通过，7-复审驳回，8-复审拒绝）',
`audit_des`  varchar(200) DEFAULT '' COMMENT '审核结果说明' ,
`audit_id`  varchar(32) DEFAULT '' COMMENT '审核人员ID' ,
`audit_dts`  datetime DEFAULT '0001-01-01 00:00:00' COMMENT '审核时间',
`create_id`  varchar(32) DEFAULT '' COMMENT '创建用户ID' ,
`create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
`create_dts`  datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间' ,
`update_id` varchar(32) DEFAULT '',
`update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
`update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
`del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
PRIMARY KEY (`id`)
)ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核记录表';

DROP TABLE IF EXISTS `kyc_store`;
CREATE TABLE `kyc_store` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '用户表主键ID',
  `store_name` varchar(50) DEFAULT '' COMMENT '店铺名称',
  `store_hold_person_id` varchar(50) DEFAULT '' COMMENT '店铺持有人ID',
  `store_hold_person_name` varchar(50) DEFAULT '' COMMENT '店铺持有人名称',
  `store_plateform_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺所在平台ID',
  `store_plateform_name` varchar(50)CHARACTER SET utf8  DEFAULT '' COMMENT '店铺所在平台名称',
  `store_the_site_code` varchar(32) CHARACTER SET utf8  DEFAULT '' COMMENT '店铺所在站点CODE编码',
  `store_the_site_name` varchar(50) CHARACTER SET utf8  DEFAULT '' COMMENT '店铺所在站点名称',
  `store_situation` tinyint(1) DEFAULT '1' COMMENT '店铺情况(1-已有产品售卖,0-暂无产品售卖／暂无店铺)',
  `store_url` varchar(200) DEFAULT '' COMMENT '店铺网址',
  `month_amt` decimal(12,4) DEFAULT '0.0000' COMMENT '预估月收款总额-单位（万美元）',
  `sell_id` varchar(100) DEFAULT '' COMMENT '卖家编号',
  `mws_auth_token` varchar(255) DEFAULT '' COMMENT 'MWS授权令牌',
  `ama_service_url` varchar(200) DEFAULT '' COMMENT '拉取亚马逊数据进的接口地址',
  `ama_market_place_id` varchar(32) DEFAULT '' COMMENT '亚马逊市场 id，该地址是固定的。一个区域一个。调接口时有的会需要。',
  `auth_flag` tinyint(1) DEFAULT '0' COMMENT '是否已经授权。该授权是指已经确认接到了我们指定银行卡的回款。一般来讲。在客户绑定后最最晚15天才能确认结果。',
  `status` tinyint(1) DEFAULT '0' COMMENT '店铺状态[0:未绑定, 1:已绑定]',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='kyc的店铺表';

DROP TABLE IF EXISTS kyc_dictionary;
CREATE TABLE `kyc_dictionary` (
  `id` varchar(32) NOT NULL,
  `name` varchar(50) DEFAULT '' COMMENT '名称',
  `type` varchar(50) DEFAULT '' COMMENT '类型',
  `code` varchar(50) DEFAULT '' COMMENT '编码',
  `sort` int(3) unsigned DEFAULT 0 COMMENT '排序',
  `available_flag` tinyint(3) unsigned DEFAULT 1 COMMENT '是否可用（1：可用，0：不可用）',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='字典表';

DROP TABLE IF EXISTS kyc_holder_personal;
CREATE TABLE `kyc_holder_personal` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `holder_type` int(3) unsigned DEFAULT '0' COMMENT '持有人类型(1-大陆个人，3-香港个人)',
  `id_type` varchar(20) DEFAULT '' COMMENT '证件类型',
  `cus_name` varchar(50) DEFAULT '' COMMENT '客户真实姓名',
  `cus_eng_name` varchar(50) DEFAULT '' COMMENT '客户英文名称',
  `cus_address` varchar(100) DEFAULT '' COMMENT '客户地址',
  `id_no` varchar(32) DEFAULT '' COMMENT '身份证号',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建人ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '提交日期',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新人ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='持有人信息表(大陆个人，香港个人)';

DROP TABLE IF EXISTS kyc_holder_company;
CREATE TABLE `kyc_holder_company` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `holder_type` int(3) unsigned DEFAULT '0' COMMENT '持有人类型(2-大陆企业，4-香港企业)',
  `company_name` varchar(50) DEFAULT '' COMMENT '企业名称',
  `company_eng_name` varchar(50) DEFAULT '' COMMENT '企业英文名称',
  `company_address` varchar(100) DEFAULT '' COMMENT '企业地址',
  `create_id` varchar(32) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '提交日期',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='持有人信息表(大陆企业，香港企业)';

DROP TABLE IF EXISTS kyc_sunrate_register;
CREATE TABLE `kyc_sunrate_register` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `kyc_natural_id` varchar(45) DEFAULT '' COMMENT '注册表主键ID',
  `kyc_certi_id` varchar(45) DEFAULT '' COMMENT '实名表主键ID',
  `kyc_certi_type` int(3) unsigned DEFAULT 0 COMMENT '实名类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）',
  `register_id` varchar(30) DEFAULT '' COMMENT '寻汇返回注册编号key',
  `register_name` varchar(60) DEFAULT '' COMMENT '注册人姓名',
  `register_email` varchar(60) DEFAULT '' COMMENT '注册邮箱',
  `register_mobile` varchar(30) DEFAULT '' COMMENT '注册手机号',
  `register_type` int(3) unsigned DEFAULT 0 COMMENT '注册类型（1-个人，2-公司）',
  `register_status` int(3) unsigned DEFAULT '0' COMMENT '注册状态(0:未提交认证信息, 1:审核通过，2:审核未通过（驳回，拒绝),3:认证审核中，4：调用寻汇返回失败)',
  `remark` varchar(255) DEFAULT '' COMMENT '备注-审核结果说明',
  `name` varchar(128) DEFAULT '' COMMENT '名称（个人：姓名，企业：公司名称）',
  `org_code` varchar(18) DEFAULT '' COMMENT '组织机构代码（识别客户，本接口文档其他地方出现不再说明，个人：请求方客户 ID 或身份号码，企业：组织结构代码）',
  `identity_type` int(3) unsigned DEFAULT 0 COMMENT '身份类型（1-法定代表人，2-授权代表人）',
  `open_address` varchar(128) DEFAULT '' COMMENT '经营地址',
  `dir_path` varchar(128) DEFAULT '' COMMENT '目录路径(资质文件，组织机构号/文件类型，/INPUT/91510100MA6C72JG4D/KYC/ )',
  `file_id_list` varchar(255) DEFAULT '' COMMENT '文件列表（Array）',
  `create_id` varchar(45) DEFAULT '' COMMENT '创建用户ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(45) DEFAULT '' COMMENT '更新人ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) DEFAULT '' COMMENT '备注',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='寻汇用户表';

DROP TABLE IF EXISTS `kyc_sunrate_store`;
CREATE TABLE `kyc_sunrate_store` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '注册表主键ID',
  `kyc_store_id` varchar(32) DEFAULT '' COMMENT 'js店铺表主键ID',
  `org_code` varchar(18) DEFAULT '' COMMENT '组织机构代码-识别客户',
  `cur_id` varchar(20) DEFAULT '' COMMENT '店铺所在站点（美国站 USD，日本站 JPY，欧洲站 EUR，英国站 GBP）',
  `store_the_site` varchar(32) CHARACTER SET utf8  DEFAULT '' COMMENT '店铺所在站点编码',
  `store_name` varchar(100) DEFAULT '' COMMENT '店铺名称',
  `store_url` varchar(200) DEFAULT '' COMMENT '店铺网址',
  `store_plateform` varchar(50) DEFAULT '' COMMENT '店铺平台（01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari ）',
  `seller_id` varchar(16) DEFAULT '' COMMENT '卖家ID',
  `access_key` varchar(20) DEFAULT '' COMMENT 'AWS 访问 Key(AKIAJJSMHVJAFRKNERIA)',
  `secret_key` varchar(40) DEFAULT '' COMMENT '私有秘钥（3ZvKcmoEQLDfE9AUX8MRsPGfOzc6m5CGlBnEqhPg）',
  `sell_goods` varchar(100) DEFAULT '' COMMENT '销售商品',
  `run_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '运营时间',
  `month_amt` decimal(12,4) DEFAULT 0 COMMENT '预估月收款总额-单位（万美元）',
  `sub_acct_no` varchar(4) DEFAULT '' COMMENT '店铺ID',
  `create_id` varchar(45) DEFAULT '',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '添加时间',
  `audit_status` int(3) unsigned DEFAULT 0 COMMENT '审核结果（1-审核通过，2-审核未通过）',
  `audit_remark` varchar(128) DEFAULT '' COMMENT '审核备注',
  `audit_dts` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '完成审核时间',
  `update_id` varchar(45) DEFAULT '' COMMENT '更新人ID',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='寻汇店铺信息表';

DROP TABLE IF EXISTS kyc_sunrate_beneficiary;
CREATE TABLE `kyc_sunrate_beneficiary` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(45) DEFAULT '' COMMENT '注册信息表主键ID',
  `beneficiary_id` varchar(10) DEFAULT '' COMMENT '受益人编号-锁汇成交时使用Key，受益人唯一编号',
  `beneficiary_status` varchar(10) DEFAULT '' COMMENT '受益人状态-0：审核中,1：审核通过,2：审核未通过 ',
  `beneficiary_type` varchar(32) DEFAULT '' COMMENT '受益人类型-  PLATEFORM_SELF-平台自己',
  `audit_remark` varchar(200) DEFAULT '' COMMENT '结果通知说明',
  `org_code` varchar(20) DEFAULT '' COMMENT '组织机构代码',
  `country_code` varchar(20) DEFAULT '' COMMENT '国家代码，受益人国家-如：HK、CN、JP，ISO 3166-1 alpha-2',
  `bank_name` varchar(128) DEFAULT '' COMMENT '银行名称',
  `route_type` varchar(10) DEFAULT '' COMMENT '路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift ',
  `aba` varchar(10) DEFAULT '' COMMENT 'ABA',
  `iban` varchar(34) DEFAULT '' COMMENT 'IBAN',
  `swift_code` varchar(20) DEFAULT '' COMMENT 'SWIFTCODE',
  `beneficiary_name` varchar(128) DEFAULT '' COMMENT '受益人名称',
  `beneficiary_acct_no` varchar(60) DEFAULT '' COMMENT '受益人银行账号，iban 包含账号，此处也需要',
  `cur` varchar(10) DEFAULT '' COMMENT '币种',
  `beneficiary_addr` varchar(255) DEFAULT '' COMMENT '受益人地址',
  `remark` varchar(255) DEFAULT '' COMMENT '备注',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建人ID',
  `create_name` varchar(100) DEFAULT '' COMMENT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(100) DEFAULT '' COMMENT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='受益人相关信息表';

DROP TABLE IF EXISTS js_pay_exchange_income;
CREATE TABLE `js_pay_exchange_income` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `acct_name` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '账户名称',
  `acct_type` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方类型',
  `acct_no` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方账户号',
  `exchange_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '汇差收入总金额',
  `lastday_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '昨日账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='平台汇差收入账户表';

DROP TABLE IF EXISTS js_pay_exchange_open_acct;
CREATE TABLE `js_pay_exchange_open_acct` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '主键ID',
  `req_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '请求编号',
  `exchange_channel` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '结汇渠道',
  `req_msg` text CHARACTER SET utf8 COMMENT '请求报文',
  `resp_msg` text CHARACTER SET utf8 COMMENT '响应报文',
  `status` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '状态：1为成功，0为失败,-1未知',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='外汇渠道开户请求响应表';

DROP TABLE IF EXISTS js_pay_exchange_router;
CREATE TABLE `js_pay_exchange_router` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '主键ID',
  `router_no` varchar(4) CHARACTER SET utf8 DEFAULT '' COMMENT '路由编号',
  `exchange_channel` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '结汇渠道',
  `payment_channel` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '三方支付渠道',
  `selected_flag` tinyint(1) DEFAULT '0' COMMENT '是否选中，0未选中，1选中',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='外汇结汇路由表';

DROP TABLE IF EXISTS js_pay_loan_fee_income;
CREATE TABLE `js_pay_loan_fee_income` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `acct_name` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '账户名称',
  `acct_type` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方类型',
  `acct_no` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方账户号',
  `loan_fee_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '贷款服务费收入总金额',
  `lastday_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '昨日账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='平台贷款服务费收入账户表';

DROP TABLE IF EXISTS js_pay_loan_lender;
CREATE TABLE `js_pay_loan_lender` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '主键ID',
  `acct_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '支付平台(1:汇付,2:富友,3:宝付)',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织机构代码',
  `bank_id` varchar(4) CHARACTER SET utf8 DEFAULT '' COMMENT '银行卡id',
  `bank_country_code` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '放款银行所在地区（如：HK、CN、JP。）',
  `bank_name` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '放款银行名称',
  `bank_addr` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '放款银行地址',
  `cus_name` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '放款账户名称',
  `bank_card_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '放款账号',
  `available_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `last_amt` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `aba` varchar(9) CHARACTER SET utf8 DEFAULT '' COMMENT 'aba',
  `iban` varchar(34) CHARACTER SET utf8 DEFAULT '' COMMENT 'iban',
  `swift_code` varchar(11) CHARACTER SET utf8 DEFAULT '' COMMENT 'swiftcode',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='资方第三方账户放款表';

DROP TABLE IF EXISTS js_pay_sunrate_bank;
CREATE TABLE `js_pay_sunrate_bank` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '主键ID',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `kyc_sunrate_store_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '寻汇店铺表主键ID',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织机构代码',
  `sub_acct_no` varchar(4) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺ID',
  `bank_country_code` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行所在地区（地区国家代码，如：HK、CN、JP。ISO 3166-1 alpha-2）',
  `bank_name` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行名称',
  `bank_addr` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行地址',
  `cus_name` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行账户名称',
  `bank_card_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行账号',
  `current_balance` decimal(15,2) DEFAULT '0.00' COMMENT '当前余额',
  `available_balance` decimal(15,2) DEFAULT '0.00' COMMENT '可用余额',
  `lastday_balance` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `freezed_balance` decimal(15,2) DEFAULT '0.00' COMMENT '冻结余额',
  `cur_id` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `route_type` varchar(1) CHARACTER SET utf8 DEFAULT '' COMMENT '路由方式',
  `aba` varchar(9) CHARACTER SET utf8 DEFAULT '' COMMENT 'aba',
  `iban` varchar(34) CHARACTER SET utf8 DEFAULT '' COMMENT 'iban',
  `swift_code` varchar(11) CHARACTER SET utf8 DEFAULT '' COMMENT 'swiftcode',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='寻汇收款虚拟子账户表';

DROP TABLE IF EXISTS js_pay_sunrate_bank_trade_in;
CREATE TABLE `js_pay_sunrate_bank_trade_in` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL,
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `kyc_sunrate_store_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '寻汇店铺主键ID',
  `kyc_sunrate_bank_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇收款虚拟子账户ID',
  `transin_notice_id` varchar(10) CHARACTER SET utf8 DEFAULT '' COMMENT '入账通知编号',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织结构代码',
  `sub_acct_no` char(4) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺ID(电商收款账户)',
  `transin_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '入账币种',
  `transin_amt` decimal(15,2) DEFAULT '0.00' COMMENT '入账金额',
  `available_amt` decimal(15,2) DEFAULT '0.00' COMMENT '可用金额',
  `available_balance` decimal(15,2) DEFAULT '0.00' COMMENT '账户可用余额',
  `sys_txn_date` varchar(10) CHARACTER SET utf8 DEFAULT '' COMMENT '入账日期',
  `bank_card_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '银行卡号',
  `process_status` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)',
  `remark` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '备注',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='客户寻汇收款账户入账通知';

DROP TABLE IF EXISTS js_pay_sunrate_trade_lock_price;
CREATE TABLE `js_pay_sunrate_trade_lock_price` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL,
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `kyc_sunrate_store_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇用户表主键ID',
  `kyc_sunrate_bank_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇收款虚拟子账户ID',
  `sunrate_bank_available_amt` decimal(15,2) DEFAULT '0.00' COMMENT '提交锁汇后虚拟账户可用余额',
  `batch_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '批量产生锁汇交易时的批次号',
  `lock_no` varchar(26) CHARACTER SET utf8 DEFAULT '' COMMENT '锁汇流水号',
  `query_no` varchar(26) CHARACTER SET utf8 DEFAULT '' COMMENT '询价流水号',
  `txn_no` varchar(26) CHARACTER SET utf8 DEFAULT '' COMMENT '锁汇交易编号-Key-寻汇交易唯一编号',
  `request_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '请求锁汇交易方式（TRADE_QUERY_PRICE-询价锁汇，TRADE_MARKET_ORDER-市价锁汇）',
  `trade_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '交易方式（REPAYMENT-还款，WITHDRAW-提现）',
  `trade_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易子类型',
  `sub_acct_no` char(4) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺ID',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织结构代码',
  `buy_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '买入币种',
  `buy_amt` decimal(15,2) DEFAULT '0.00' COMMENT '买入金额',
  `sell_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '卖出币种',
  `sell_amt` decimal(15,2) DEFAULT '0.00' COMMENT '卖出金额',
  `fee_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '手续费币种',
  `query_rate` decimal(9,4) DEFAULT '0.0000' COMMENT '询价汇率',
  `value_date` varchar(10) CHARACTER SET utf8 DEFAULT '' COMMENT '交割日期',
  `beneficiary_id` varchar(10) CHARACTER SET utf8 DEFAULT '' COMMENT '受益人编号',
  `fee_amt` decimal(15,2) DEFAULT '0.00' COMMENT '手续费金额',
  `pay_amt` decimal(15,2) DEFAULT '0.00' COMMENT '支付总金额',
  `txn_mode` char(1) CHARACTER SET utf8 DEFAULT '' COMMENT '交易模式',
  `txn_amt` decimal(15,2) DEFAULT '0.00' COMMENT '交易金额',
  `available_balance` decimal(15,2) DEFAULT '0.00' COMMENT '账户可用余额',
  `fin_rate` decimal(9,4) DEFAULT '0.0000' COMMENT '市价锁汇时成交汇率',
  `kyc_bank_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '银行卡信息主键ID',
  `bank_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '银行账号',
  `use_rate` decimal(9,4) DEFAULT '0.0000' COMMENT '当前客户使用汇率',
  `take_rate` decimal(6,4) DEFAULT '0.0000' COMMENT '单外币收取汇差值',
  `rate_amt` decimal(9,2) DEFAULT '0.00' COMMENT '收取汇差金额',
  `service_charge` decimal(9,4) DEFAULT '0.0000' COMMENT '当前客户使用手续费',
  `charge_amt` decimal(9,4) DEFAULT '0.0000' COMMENT '应收外币手续费金额',
  `charge_amt_buy` decimal(9,4) DEFAULT '0.0000' COMMENT '买入币种手续费金额',
  `txn_status` char(2) CHARACTER SET utf8 DEFAULT '' COMMENT '交易状态02：交易确认 ，03：入账已确认 ，09：出账完成 ,99,处理失败',
  `txn_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '请求寻汇锁汇交易返回的交易时间',
  `process_status` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT 'TRADE_UNPROCESSED' COMMENT '处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)',
  `remark` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '备注',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='寻汇锁汇交易请求';

DROP TABLE IF EXISTS js_pay_sunrate_trade_query_price;
CREATE TABLE `js_pay_sunrate_trade_query_price` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL,
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `kyc_sunrate_store_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇用户表主键ID',
  `kyc_sunrate_bank_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇收款虚拟子账户ID',
  `query_no` varchar(26) CHARACTER SET utf8 DEFAULT '' COMMENT '询价流水号',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织机构代码',
  `buy_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '买入币种',
  `buy_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '买入金额',
  `sell_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '卖出币种',
  `sell_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '卖出金额',
  `txn_mode` char(1) CHARACTER SET utf8 DEFAULT '' COMMENT '交易模式',
  `txn_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '交易金额',
  `fee_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '手续费金额',
  `fee_cur` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '手续费币种',
  `pay_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '支付总金额',
  `query_rate` decimal(9,4) NOT NULL DEFAULT '0.0000' COMMENT '询价汇率',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='寻汇外汇询价表';

DROP TABLE IF EXISTS js_pay_sys_acct;
CREATE TABLE `js_pay_sys_acct` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `plateform_type` varchar(32) NOT NULL DEFAULT 'NONE_TYPE' COMMENT '平台类型（HFGJ(汇付国际))',
  `acct_type` varchar(32) NOT NULL DEFAULT 'NONE_TYPE' COMMENT '账户类型（HFGJ_YFJS(汇付国际-源奉济生大账户类型))',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `user_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '用户ID',
  `acct_name` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '账户名称',
  `acct_no` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '账户号',
  `id_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '证件号',
  `receiving_bank_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '收款银行名称',
  `receiving_bank_addr` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '收款银行地址',
  `receiving_acct_addr` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '收款人地址',
  `swift_code` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT 'swiftcode',
  `receiving_acct_country` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '收款人常驻国家',
  `receiving_acct_desc` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '收款账户信息',
  `cur` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '币种',
  `available_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `last_amt` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='平台第三方账户';

DROP TABLE IF EXISTS js_pay_trade;
CREATE TABLE `js_pay_trade` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `kyc_sunrate_store_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇店铺表主键ID',
  `substitute_detail_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '汇付代发明细流水号',
  `lock_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '锁汇流水号',
  `txn_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '锁汇交易编号',
  `in_acct` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '入账账户号',
  `in_acct_name` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '入账账户名称',
  `out_acct` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '出账账户号',
  `out_acct_name` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '出账账户名称',
  `trade_no` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '外部交易单号',
  `kyc_sunrate_bank_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '寻汇收款虚拟子账户ID',
  `trade_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '交易类型[0:账户入账,1:账户出账]',
  `trade_sub_type` varchar(32) COMMENT '交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费]',
  `cur_id` char(3) CHARACTER SET utf8 NOT NULL DEFAULT 'SUD' COMMENT '操作币种',
  `trade_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '交易金额',
  `out_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '出账金额',
  `in_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '入账金额',
  `user_acct_curr_amt` decimal(15,2) DEFAULT '0.00' COMMENT '账户剩余金额',
  `user_acct_borrow_amt` decimal(15,2) DEFAULT '0.00' COMMENT '交易后账户总借款',
  `in_acct_available_amt` decimal(15,2) DEFAULT '0.00' COMMENT '入账账户可用余额',
  `out_acct_available_amt` decimal(15,2) DEFAULT '0.00' COMMENT '出账账户可用余额',
  `trade_dts` datetime DEFAULT NULL COMMENT '交易时间',
  `process_status` varchar(32) CHARACTER SET utf8 DEFAULT 'TRADE_UNPROCESSED' COMMENT '处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='所有账户交易流水表';

DROP TABLE IF EXISTS js_pay_user_acct;
CREATE TABLE `js_pay_user_acct` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `plateform_type` varchar(32) DEFAULT '0' COMMENT '平台类型（HFGJ(汇付国际))',
  `acct_type` varchar(32) DEFAULT '' COMMENT '账户类型（COMPANY_PUBLIC–对公，COMPANY_SELF–对私）',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `acct_name` char(3) CHARACTER SET utf8 DEFAULT '' COMMENT '账户名称',
  `acct_no` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '账户号',
  `available_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `last_amt` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='客户第三方账户表';

DROP TABLE IF EXISTS js_pay_user_loan_receipt;
CREATE TABLE `js_pay_user_loan_receipt` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `user_id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '用户id',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织机构代码',
  `bank_country_code` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行所在地区',
  `bank_name` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行名称',
  `bank_addr` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行地址',
  `cus_name` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行账户名称',
  `bank_card_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '收款银行账号',
  `available_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `last_amt` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `route_type` varchar(1) CHARACTER SET utf8 DEFAULT '' COMMENT '路由方式',
  `swift_code` varchar(11) CHARACTER SET utf8 DEFAULT '' COMMENT 'swiftcode',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `platform_type` int(3) unsigned NOT NULL DEFAULT '0' COMMENT '合作平台(0:寻汇,1:easypay)',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='卖家贷款提现银行账户表';

DROP TABLE IF EXISTS js_pay_user_withdraw_depoist;
CREATE TABLE `js_pay_user_withdraw_depoist` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `user_id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT '用户id',
  `org_code` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '组织机构代码',
  `sub_acct_no` varchar(4) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺ID',
  `bank_country_code` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '提现银行所在地区',
  `bank_name` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '提现银行名称',
  `bank_addr` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '提现银行地址',
  `cus_name` varchar(128) CHARACTER SET utf8 DEFAULT '' COMMENT '提现银行账户名称',
  `bank_card_no` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '提现银行账号',
  `available_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `last_amt` decimal(15,2) DEFAULT '0.00' COMMENT '昨日余额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `route_type` varchar(1) CHARACTER SET utf8 DEFAULT '' COMMENT '路由方式',
  `swift_code` varchar(11) CHARACTER SET utf8 DEFAULT '' COMMENT 'swiftcode',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `platform_type` int(3) unsigned NOT NULL DEFAULT '0' COMMENT '合作平台(0:寻汇,1:easypay)',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='卖家提现银行账户表';

DROP TABLE IF EXISTS js_pay_withdraw_income;
CREATE TABLE `js_pay_withdraw_income` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `acct_name` varchar(18) CHARACTER SET utf8 DEFAULT '' COMMENT '账户名称',
  `acct_type` varchar(2) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方类型',
  `acct_no` varchar(60) CHARACTER SET utf8 DEFAULT '' COMMENT '平台第三方账户号',
  `all_withdraw_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '提现手续费收入总金额',
  `lastday_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '昨日账户余额',
  `frozen_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '冻结金额',
  `cur_id` varchar(3) CHARACTER SET utf8 DEFAULT '' COMMENT '币种(如：USD)',
  `store_hold_member` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '账户持有人id',
  `use_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为当前使用[0:不是, 1:是]',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='平台提现手续费账户表';


DROP TABLE IF EXISTS `js_sync_amazon_financial_event_group`;
CREATE TABLE `js_sync_amazon_financial_event_group` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) NOT NULL COMMENT '用户 id',
  `store_id` varchar(32) NOT NULL COMMENT '绑定的店铺 id',
  `financial_event_group_id` varchar(64) DEFAULT '' COMMENT '账单 id',
  `processing_status` varchar(32) DEFAULT '' COMMENT '结算是否已经完成',
  `fund_transfer_status` varchar(32) DEFAULT '' COMMENT '资金状态',
  `original_total_code` varchar(32) DEFAULT '' COMMENT '源交易总金额货币类型',
  `original_total` decimal(15,2) DEFAULT '0.00' COMMENT '源交易总金额',
  `converted_total_code` varchar(32) DEFAULT '' COMMENT '交易总金额货币类型',
  `converted_total` decimal(15,2) DEFAULT '0.00' COMMENT '交易总金额',
  `fund_transfer_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '交易日期，只在完成时有值',
  `trace_id` varchar(64) DEFAULT '' COMMENT '卖家查找交易跟踪 id',
  `account_tail` varchar(64) DEFAULT '' COMMENT '账号尾号',
  `beginning_balance_code` varchar(32) DEFAULT '' COMMENT '结算开始时余额类型',
  `beginning_balance` decimal(15,2) DEFAULT '0.00' COMMENT '结算开始时余额',
  `financial_event_group_start` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '交易开始时间',
  `financial_event_group_end` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '交易结束时间',
  `sync_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '同步时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊付款表';

DROP TABLE IF EXISTS `js_sync_amazon_inventory`;
CREATE TABLE `js_sync_amazon_inventory` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) DEFAULT '' COMMENT '用户 id',
  `store_id` varchar(32) DEFAULT '' COMMENT '店铺 id',
  `quantity` decimal(15,2) DEFAULT '0.00' COMMENT '库存数量',
  `price` decimal(15,2) DEFAULT '0.00' COMMENT '商品价格',
  `sellersku` varchar(100) DEFAULT '' COMMENT '卖家商品 sku',
  `asin` varchar(64) DEFAULT '' COMMENT '亚马逊标准唯一认证识别号',
  `statistics_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '统计时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊库存报告简化版';

DROP TABLE IF EXISTS `js_sync_amazon_order`;
CREATE TABLE `js_sync_amazon_order` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `kyc_natural_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户 id',
  `store_id` varchar(32) NOT NULL DEFAULT '' COMMENT '平台店铺 id',
  `amazon_order_id` varchar(64) DEFAULT '' COMMENT '亚马逊所定义的订单编码',
  `seller_order_id` varchar(64) DEFAULT '' COMMENT '卖家所定义的订单编码',
  `purchase_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '创建订单的日期',
  `last_update_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '订单的最后更新日期',
  `order_status` varchar(32) DEFAULT '' COMMENT '当前的订单状态',
  `number_of_items_shipped` decimal(15,2) DEFAULT '0.00' COMMENT '已配送的商品数量',
  `currency_code` varchar(32) DEFAULT '' COMMENT '货币类型',
  `order_total` decimal(15,2) DEFAULT '0.00' COMMENT '订单总金额',
  `number_of_items_unshipped` decimal(15,2) DEFAULT '0.00' COMMENT '未配送的商品数量',
  `marketplace_id` varchar(64) DEFAULT '' COMMENT '订单生成所在商城的匿名编码',
  `buyer_email` varchar(64) DEFAULT '' COMMENT '买家的匿名电子邮件地址',
  `buyer_name` varchar(64) DEFAULT '' COMMENT '买家姓名',
  `shipping_address_id` varchar(32) DEFAULT '',
  `order_type` varchar(32) DEFAULT '' COMMENT '订单类型',
  `replaced_order_id` varchar(32) DEFAULT '' COMMENT '替换订单 id',
  `is_replacement_order` tinyint(1) DEFAULT '0' COMMENT '是否是替换订单',
  `promise_response_due_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '已配送的商品数量',
  `is_estimated_ship_date_set` tinyint(1) DEFAULT '0' COMMENT '已配送的商品数量',
  `sync_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '同步时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊订单表';

DROP TABLE IF EXISTS `js_sync_amazon_order_address`;
CREATE TABLE `js_sync_amazon_order_address` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户 id',
  `name` varchar(64) DEFAULT '' COMMENT '名称',
  `address_line1` varchar(200) DEFAULT '' COMMENT '地址1',
  `address_line2` varchar(200) DEFAULT '' COMMENT '地址2',
  `address_line3` varchar(200) DEFAULT '' COMMENT '地址3',
  `city` varchar(64) DEFAULT '' COMMENT '城市',
  `county` varchar(64) DEFAULT '' COMMENT '郡、县',
  `district` varchar(64) DEFAULT '' COMMENT '行政区',
  `state_or_region` varchar(64) DEFAULT '' COMMENT '州或地区',
  `municipality` varchar(64) DEFAULT '' COMMENT '自治区或市',
  `postal_code` varchar(64) DEFAULT '' COMMENT '邮政编码',
  `country_code` varchar(64) DEFAULT '' COMMENT '国家代码',
  `phone` varchar(64) DEFAULT '' COMMENT '买家电话，亚马逊配送的订单无此值。',
  `address_type` varchar(64) DEFAULT '' COMMENT '地址类型',
  `del_flag` tinyint(1) unsigned DEFAULT '0',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊订单送货地址表';

DROP TABLE IF EXISTS `js_sync_amazon_order_item`;
CREATE TABLE `js_sync_amazon_order_item` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) NOT NULL COMMENT '用户 id',
  `order_id` varchar(32) NOT NULL COMMENT '订单 id',
  `store_id` varchar(32) NOT NULL COMMENT '店铺 id',
  `asin` varchar(64) DEFAULT '' COMMENT '亚马逊标准唯一认证识别号',
  `sellersku` varchar(64) DEFAULT '' COMMENT '卖家商品 sku',
  `order_item_id` varchar(64) DEFAULT '' COMMENT '商品明细 id',
  `title` varchar(200) DEFAULT '' COMMENT '商品名称',
  `quantity_ordered` decimal(15,2) DEFAULT '0.00' COMMENT '订单商品数量',
  `quantity_shipped` decimal(15,2) DEFAULT '0.00' COMMENT '订单商品已经发货的数量',
  `item_price_code` varchar(32) DEFAULT '' COMMENT '商品价格币种',
  `item_price` decimal(15,2) DEFAULT '0.00' COMMENT '商品总价格。等于商品价格乘以商品数量，不包含运费与包装费',
  `shipping_price_code` varchar(32) DEFAULT '' COMMENT '运费币种',
  `shipping_price` decimal(15,2) DEFAULT '0.00' COMMENT '运费',
  `gift_wrap_price_code` varchar(32) DEFAULT '' COMMENT '包装费币种',
  `gift_wrap_price` decimal(15,2) DEFAULT '0.00' COMMENT '包装费',
  `item_tax_code` varchar(32) DEFAULT '' COMMENT '商品税费币种',
  `item_tax` decimal(15,2) DEFAULT '0.00' COMMENT '商品税费',
  `shipping_tax_code` varchar(32) DEFAULT '' COMMENT '运费税币种',
  `shipping_tax` decimal(15,2) DEFAULT '0.00' COMMENT '运费税',
  `gift_wrap_tax_code` varchar(32) DEFAULT '' COMMENT '运费税币种',
  `gift_wrap_tax` decimal(15,2) DEFAULT '0.00' COMMENT '运费税',
  `shipping_discount_code` varchar(32) DEFAULT '' COMMENT '运费折扣币种',
  `shipping_discount` decimal(15,2) DEFAULT '0.00' COMMENT '运费折扣',
  `shipping_discount_tax_code` varchar(32) DEFAULT '' COMMENT '运费折扣税币种',
  `shipping_discount_tax` decimal(15,2) DEFAULT '0.00' COMMENT '运费折扣税',
  `promotion_discount_code` varchar(32) DEFAULT '' COMMENT '促销折扣币种',
  `promotion_discount` decimal(15,2) DEFAULT '0.00' COMMENT '促销折扣',
  `promotion_discount_tax_code` varchar(32) DEFAULT '' COMMENT '促销折扣税币种',
  `promotion_discount_tax` decimal(15,2) DEFAULT '0.00' COMMENT '促销折扣税',
  `cod_fee_code` varchar(32) DEFAULT '' COMMENT 'cod费用币种',
  `cod_fee` decimal(15,2) DEFAULT '0.00' COMMENT 'cod费用',
  `cod_fee_discount_code` varchar(32) DEFAULT '' COMMENT 'cod费用折扣币种',
  `cod_fee_discount` decimal(15,2) DEFAULT '0.00' COMMENT 'cod费用折扣',
  `is_gift` tinyint(1) DEFAULT '0' COMMENT '是否是礼品',
  `gift_message_text` varchar(2000) DEFAULT '' COMMENT '礼品包装说明文字',
  `gift_wrap_level` varchar(32) DEFAULT '' COMMENT '礼品包装等级',
  `condition_note` varchar(200) DEFAULT '' COMMENT '卖家描述的商状态',
  `condition_id` varchar(32) DEFAULT '' COMMENT '商品状态',
  `condition_subtype_id` varchar(200) DEFAULT '' COMMENT '商品子状态',
  `price_designation` varchar(32) DEFAULT '' COMMENT '指定价格，对商业订单才有效',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊订单商品明细';

DROP TABLE IF EXISTS `js_sync_amazon_settlement_report`;
CREATE TABLE `js_sync_amazon_settlement_report` (
  `id` varchar(32) NOT NULL DEFAULT '' COMMENT '主键 id',
  `kyc_natural_id` varchar(32) DEFAULT '' COMMENT '用户主键 id',
  `store_id` varchar(32) DEFAULT '' COMMENT '店铺 id',
  `report_id` varchar(64) DEFAULT '' COMMENT '报告 id 主要用于重新同步时使用。',
  `settlement_id` varchar(64) DEFAULT '' COMMENT '结算报告 id',
  `settlement_start_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '结算开始日期',
  `settlement_end_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '结算结束日期',
  `deposit_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '交易日期',
  `total_amount` decimal(15,2) DEFAULT '0.00' COMMENT '总金额',
  `currency` varchar(64) DEFAULT '' COMMENT '币种',
  `transaction_type` varchar(64) DEFAULT '' COMMENT '交易类型',
  `order_id` varchar(64) DEFAULT '' COMMENT '订单 id',
  `merchant_order_id` varchar(64) DEFAULT '' COMMENT '卖家订单 id',
  `adjustment_id` varchar(64) DEFAULT '' COMMENT '调整 id',
  `shipment_id` varchar(64) DEFAULT '' COMMENT '运费 id',
  `marketplace_name` varchar(64) DEFAULT '' COMMENT '市场名',
  `shipment_fee_type` varchar(64) DEFAULT '' COMMENT '运费类型',
  `shipment_fee_amount` decimal(15,2) DEFAULT '0.00' COMMENT '运费',
  `order_fee_type` varchar(64) DEFAULT '' COMMENT '订单费用类型',
  `order_fee_amount` decimal(15,2) DEFAULT '0.00' COMMENT '订单费用',
  `fulfillment_id` varchar(64) DEFAULT '',
  `posted_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '到货时间',
  `order_item_code` varchar(64) DEFAULT '' COMMENT '商品代码,对应商品明细中的 id',
  `merchant_order_item_id` varchar(64) DEFAULT '',
  `merchant_adjustment_item_id` varchar(64) DEFAULT '' COMMENT '卖家商品调整 id',
  `sku` varchar(64) DEFAULT '' COMMENT '商品 sku',
  `quantity_purchased` decimal(15,2) DEFAULT '0.00' COMMENT '商品数量',
  `price_type` varchar(64) DEFAULT '' COMMENT '价格类型',
  `price_amount` decimal(15,2) DEFAULT '0.00' COMMENT '价格',
  `item_related_fee_type` varchar(64) DEFAULT '' COMMENT '商品相关费用类型',
  `item_related_fee_amount` decimal(15,2) DEFAULT '0.00' COMMENT '商品相关费用',
  `misc_fee_amount` decimal(15,2) DEFAULT '0.00',
  `other_fee_amount` decimal(15,2) DEFAULT '0.00' COMMENT '其它费用',
  `other_fee_reason_description` varchar(64) DEFAULT '' COMMENT '其它费用描述',
  `direct_payment_type` varchar(64) DEFAULT '' COMMENT '直接付款类型',
  `direct_payment_amount` decimal(15,2) DEFAULT '0.00' COMMENT '直接付款',
  `other_amount` decimal(15,2) DEFAULT '0.00' COMMENT '其它款目',
  `statistics_time` datetime DEFAULT '0001-01-01 00:00:00',
  `create_id` varchar(64) DEFAULT '' COMMENT '创建用户 id',
  `create_dts` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '创建时间',
  `create_name` varchar(64) DEFAULT '' COMMENT '创建用户名',
  `update_id` varchar(64) DEFAULT '' COMMENT '更新用户 id',
  `update_dts` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '更新时间',
  `update_name` varchar(64) DEFAULT '' COMMENT '更新用户名',
  `del_flag` tinyint(1) DEFAULT '0',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊结算报告';

DROP TABLE IF EXISTS `js_sync_amazon_shipment_event`;
CREATE TABLE `js_sync_amazon_shipment_event` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `kyc_natural_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户 id',
  `store_id` varchar(32) NOT NULL DEFAULT '' COMMENT '平台店铺 id',
  `financial_event_group_id` varchar(64) NOT NULL DEFAULT '' COMMENT '账单 id',
  `event_type` int(11) DEFAULT '0' COMMENT '事件类型',
  `amazon_order_id` varchar(64) DEFAULT '' COMMENT '亚马逊所定义的订单编码',
  `seller_order_id` varchar(64) DEFAULT '' COMMENT '卖家所定义的订单编码',
  `marketplace_name` varchar(64) DEFAULT '' COMMENT '市场名称',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊付款事件表';

DROP TABLE IF EXISTS `js_sync_amazon_shipment_event_charge`;
CREATE TABLE `js_sync_amazon_shipment_event_charge` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) DEFAULT '' COMMENT '用户 id',
  `store_id` varchar(32) DEFAULT '' COMMENT '绑定的店铺 id',
  `sellersku` varchar(64) DEFAULT '' COMMENT '卖家 sku',
  `order_id` varchar(64) DEFAULT '' COMMENT '商品订单 id',
  `order_item_id` varchar(64) DEFAULT '' COMMENT '商品明细 id',
  `charge_type` varchar(64) DEFAULT '' COMMENT '费用类型',
  `charge_amount_code` varchar(64) DEFAULT '' COMMENT '费用货币类型',
  `charge_amount` decimal(15,2) DEFAULT '0.00' COMMENT '商品费用',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊付款事件费用相关';

DROP TABLE IF EXISTS `js_sync_amazon_shipment_event_item`;
CREATE TABLE `js_sync_amazon_shipment_event_item` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `user_natural_id` varchar(32) DEFAULT '' COMMENT '用户 id',
  `store_id` varchar(32) DEFAULT '' COMMENT '绑定的店铺 id',
  `sellersku` varchar(64) DEFAULT '' COMMENT '卖家 sku',
  `order_id` varchar(64) DEFAULT '' COMMENT '商品订单id',
  `order_item_id` varchar(64) DEFAULT '' COMMENT '商品明细 id',
  `order_adjustment_item_id` varchar(64) DEFAULT '' COMMENT '商品明细调整 id',
  `quantity_shipped` decimal(15,2) DEFAULT '0.00' COMMENT '商品数量',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) NOT NULL COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='亚马逊付款事件明细';

DROP TABLE IF EXISTS `platform_statistics_by_kyc`;
CREATE TABLE `platform_statistics_by_kyc` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `kyc_natural_id` varchar(32) NOT NULL DEFAULT '' COMMENT '用户 id',
  `half_year_sale_ratio` decimal(15,4) DEFAULT '0.0000',
  `amazonusshop_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '亚马逊美国店铺数量占比',
  `amazonussale_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '亚马逊美国店铺销售额占比',
  `monthly_sale` decimal(15,2) DEFAULT '0.00' COMMENT '月均销售额',
  `income` decimal(15,2) DEFAULT '0.00' COMMENT '入账金额',
  `income_chain_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '入账环比增涨率',
  `monthly_income` decimal(15,2) DEFAULT '0.00' COMMENT '月均入账金额',
  `income_three_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '近一个月入账金额与前3个月平均入账金额比例',
  `income_six_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '近一个月入账金额与前6个月平均入账金额比例',
  `income_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '入账金额同比增长率',
  `per_customer_transaction` decimal(15,2) DEFAULT '0.00' COMMENT '客单价',
  `per_cus_trans_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '客单价同比增长率',
  `monthly_order_num` decimal(15,2) DEFAULT '0.00' COMMENT '月订单量',
  `monthly_refund_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '月均退款率',
  `monthly_refund_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '退款率同比增长率',
  `available_product_num` decimal(15,2) DEFAULT '0.00' COMMENT '在售商品数量',
  `statistics_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '统计时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='kyc 维度数据统计表';

DROP TABLE IF EXISTS `platform_statistics_by_shop`;
CREATE TABLE `platform_statistics_by_shop` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `store_id` varchar(32) NOT NULL COMMENT '店铺 id',
  `monthly_sale` decimal(15,2) DEFAULT '0.00' COMMENT '月均销售额',
  `monthly_sale_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '月均销售占比',
  `income` decimal(15,2) DEFAULT '0.00' COMMENT '入账金额',
  `monthly_income` decimal(15,2) DEFAULT '0.00' COMMENT '近 12 个月的月均入账金额，如果不足 12 个月会以现有的完整月份进行平均。',
  `average_income` decimal(15,2) DEFAULT '0.00' COMMENT '笔均入账金额',
  `income_chain_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '近一个月入账金额环比增长率',
  `income_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '入账金额同比增长率',
  `per_customer_transaction` decimal(15,2) DEFAULT '0.00' COMMENT '客单价',
  `per_cus_trans_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '客单价同比增长率',
  `monthly_order_num` decimal(15,2) DEFAULT '0.00' COMMENT '月订单量',
  `refund_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '退款率',
  `refund_growth_rate_on_year` decimal(15,4) DEFAULT '0.0000' COMMENT '退款率同比增长率',
  `refund_chain_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '退款率环比波动率',
  `available_product_num` decimal(15,2) DEFAULT '0.00' COMMENT '在售商品数量',
  `available_product_num_chain_rate` decimal(15,4) DEFAULT '0.0000' COMMENT '在售商品数量环比波动率',
  `sales_top_ten_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '销售额前10名商品占比',
  `sales_top_three_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '销售额前3名商品占比',
  `income_three_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '近一个月入账金额与前3个月平均入账金额比例',
  `income_six_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '近一个月入账金额与前6个月平均入账金额比例',
  `bind_time` decimal(15,2) DEFAULT '0.00' COMMENT '绑定回款时间，单位为月',
  `statistics_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '统计时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='店铺维度数据统计表';

DROP TABLE IF EXISTS `platform_store_status_statistics`;
CREATE TABLE `platform_store_status_statistics` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `kyc_natural_id` varchar(32) NOT NULL COMMENT '用户 id',
  `cancel_shop_auth_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '取消授权店铺占比',
  `fail_shop_auth_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '授权失败店铺占比',
  `close_shop_ratio` decimal(15,4) DEFAULT '0.0000' COMMENT '关闭店铺占比',
  `statistics_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '统计时间',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='店铺授权状态历史记录';

DROP TABLE IF EXISTS `qichacha_enterprise_info`;
CREATE TABLE `qichacha_enterprise_info` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `kyc_natural_id` varchar(32) DEFAULT '',
  `key_no` varchar(32) DEFAULT '' COMMENT '根据此字段获取详细信息',
  `name` varchar(32) DEFAULT '' COMMENT '公司名称',
  `no` varchar(32) DEFAULT '' COMMENT '注册号',
  `start_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '成立日期',
  `credit_code` varchar(32) DEFAULT '' COMMENT '信用代码',
  `response_body_data` longtext COMMENT '响应报文',
  `reqest_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '请求时间',
  `province` varchar(32) DEFAULT '' COMMENT '公司所在省',
  `city` varchar(32) DEFAULT '' COMMENT '公司所在市',
  `partner50` varchar(32) DEFAULT '' COMMENT '持股50%以上的股东',
  `oper_is_partner` tinyint(1) unsigned DEFAULT '0' COMMENT '法人是否是股东',
  `oper_change` tinyint(1) unsigned DEFAULT '0' COMMENT '企业近一年法人有无变更',
  `partner_change` tinyint(1) unsigned DEFAULT '0' COMMENT '企业近一年股东有无变更',
  `has_execution` tinyint(1) unsigned DEFAULT '0' COMMENT '近一年借款企业和关联企业命中法院执行或涉诉',
  `has_penalty` tinyint(1) unsigned DEFAULT '0' COMMENT '近一年借款企业和关联企业命中行政处罚',
  `has_exception` tinyint(1) unsigned DEFAULT '0' COMMENT '近一年借款企业和关联企业命中经营地异常信息',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '删除标记 0 是未删除，1 是已删除',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户姓名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='企查查工商数据查询';

DROP TABLE IF EXISTS js_loan_apply_info;
CREATE TABLE `js_loan_apply_info` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `loan_no` varchar(32) NOT NULL DEFAULT '' COMMENT '贷款申请编号',
  `kyc_natural_id` varchar(45) NOT NULL DEFAULT '' COMMENT 'KYC注册ID',
  `name` varchar(8) NOT NULL DEFAULT '' COMMENT '申请人名称',
  `phone` varchar(24) DEFAULT '' COMMENT '申请人手机号',
  `apply_amt` decimal(15,2) DEFAULT '0.00' COMMENT '意向贷款金额',
  `real_amt` decimal(15,2) DEFAULT '0.00' COMMENT '实际放款金额',
  `apply_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '申请贷款时间',
  `pass_date` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '放款时间',
  `loan_status` varchar(32) DEFAULT '' COMMENT '贷款状态',
  `loan_days` int(4) DEFAULT 0 COMMENT '借款天数',
  `total_rate` decimal(8,6) DEFAULT '0.00' COMMENT '综合费率',
  `unpay_principal` decimal(15,2) DEFAULT '0.00' COMMENT '未还本金',
  `unpay_interest` decimal(15,2) DEFAULT '0.00' COMMENT '未还利息',
  `unpay_fee` decimal(15,2) DEFAULT '0.00' COMMENT '未还服务费',
  `unpay_penalty` decimal(15,2) DEFAULT '0.00' COMMENT '未还罚息',
  `unpay_prepayment_fee` decimal(15,2) DEFAULT '0.00' COMMENT '未还提前还款手续费',
  `paid_principal` decimal(15,2) DEFAULT '0.00' COMMENT '已还本金',
  `paid_interest` decimal(15,2) DEFAULT '0.00' COMMENT '已还利息',
  `paid_fee` decimal(15,2) DEFAULT '0.00' COMMENT '已还服务费',
  `paid_penalty` decimal(15,2) DEFAULT '0.00' COMMENT '已还罚息',
  `paid_prepayment_fee` decimal(15,2) DEFAULT '0.00' COMMENT '已还提前还款手续费',
  `first_repay_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '最早还款时间',
  `last_repay_time` datetime DEFAULT '0001-01-01 00:00:00' COMMENT '最晚还款时间',
  `repay_type` varchar(32) DEFAULT '' COMMENT '还款方式',
  `user_acct_id` varchar(45) DEFAULT '' COMMENT '收款账户id',
  `acct_name` varchar(24) DEFAULT '' COMMENT '收款账户名称',
  `acct_no` varchar(24) DEFAULT '' COMMENT '收款账户号',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci  COMMENT='客户贷款申请表';


DROP TABLE IF EXISTS js_loan_plan_detail;
CREATE TABLE `js_loan_plan_detail` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `apply_info_id` varchar(45) NOT NULL DEFAULT '' COMMENT '贷款申请id',
  `loan_no` varchar(32) NOT NULL DEFAULT '' COMMENT '贷款申请编号',
  `kyc_natural_id` varchar(45) NOT NULL DEFAULT '' COMMENT 'KYC注册ID',
  `repay_period` varchar(2) NOT NULL DEFAULT '' COMMENT '还款期数',
  `name` varchar(8) NOT NULL DEFAULT '' COMMENT '还款人名称',
  `phone` varchar(24) DEFAULT '' COMMENT '还款人手机号',
  `unpay_principal` decimal(15,2) DEFAULT '0.00' COMMENT '未还本金',
  `unpay_interest` decimal(15,2) DEFAULT '0.00' COMMENT '未还利息',
  `unpay_fee` decimal(15,2) DEFAULT '0.00' COMMENT '未还服务费',
  `unpay_penalty` decimal(15,2) DEFAULT '0.00' COMMENT '未还罚息',
  `unpay_prepayment_fee` decimal(15,2) DEFAULT '0.00' COMMENT '未还提前还款手续费',
  `paid_principal` decimal(15,2) DEFAULT '0.00' COMMENT '已还本金',
  `paid_interest` decimal(15,2) DEFAULT '0.00' COMMENT '已还利息',
  `paid_fee` decimal(15,2) DEFAULT '0.00' COMMENT '已还服务费',
  `paid_penalty` decimal(15,2) DEFAULT '0.00' COMMENT '已还罚息',
  `paid_prepayment_fee` decimal(15,2) DEFAULT '0.00' COMMENT '已还提前还款手续费',
  `repay_time` datetime DEFAULT '0000-01-01 00:00:00' COMMENT '还款时间',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci  COMMENT='还款计划明细表';

DROP TABLE IF EXISTS js_loan_risk_info;
CREATE TABLE `js_loan_risk_info` (
  `id` varchar(32) NOT NULL COMMENT '主键 id',
  `loan_no` varchar(32) NOT NULL DEFAULT '' COMMENT '贷款申请编号',
  `kyc_natural_id` varchar(45) NOT NULL DEFAULT '' COMMENT 'KYC注册ID',
  `borrower_type` varchar(8) NOT NULL DEFAULT '' COMMENT '借款人类型',
  `borrower_name` varchar(24) DEFAULT '' COMMENT '借款人姓名',
  `borrower_phone` varchar(24) DEFAULT '' COMMENT '借款人手机号',
  `borrower_idcard` varchar(20) DEFAULT '' COMMENT '借款人身份证号',
  `borrower_email` varchar(64) DEFAULT '' COMMENT '借款人邮箱',
  `marriage_status` varchar(4) DEFAULT '' COMMENT '借款人婚姻状态',
  `borrower_colleague` varchar(24) DEFAULT '' COMMENT '借款人同事联系方式',
  `borrower_address` varchar(64) DEFAULT '' COMMENT '借款人现家庭住址',
  `credit_reporting_no` varchar(32) DEFAULT '' COMMENT '人行征信注册账号',
  `credit_reporting_password` varchar(32) DEFAULT '' COMMENT '人行征信登录密码',
  `credit_reporting_authcode` varchar(32) DEFAULT '' COMMENT '人行征信身份验证码',
  `credit_reporting_oss` varchar(128) DEFAULT '' COMMENT '人行征信报告OSS地址',
  `guarantee_type` varchar(8) DEFAULT '' COMMENT '担保人类型',
  `guarantee_corp` varchar(64) DEFAULT '' COMMENT '担保企业名称',
  `guarantee_corp_orgcode` varchar(24) DEFAULT '' COMMENT '担保企业统一信用代码',
  `guarantee_corp_address` varchar(64) DEFAULT '' COMMENT '担保企业实际经营地址',
  `guarantee_corp_qualification` varchar(64) DEFAULT '' COMMENT '担保企业证明材料',
  `guarantee_legalname_front` varchar(128) DEFAULT '' COMMENT '担保企业法人身份证正面',  
  `guarantee_legalname_back` varchar(128) DEFAULT '' COMMENT '担保企业法人身份证反面',    
  `guarantee_corp_legalname` varchar(8) DEFAULT '' COMMENT '担保企业法人姓名',
  `guarantee_corp_idcard` varchar(24) DEFAULT '' COMMENT '担保企业法人证件号码',
  `guarantee_corp_phone` varchar(24) DEFAULT '' COMMENT '担保企业法人手机号',
  `guarantee_corp_email` varchar(24) DEFAULT '' COMMENT '担保企业法人邮箱',
  `guarantee_idcard_valid` varchar(32) DEFAULT '' COMMENT '担保企业法人身份证有效期',
  `guarantee_legal_home_address` varchar(45) DEFAULT '' COMMENT '担保企业法人家庭住址',
  `guarantee_legal_office_address` varchar(45) DEFAULT '' COMMENT '担保企业法人办公地址',
  `corp_acct` varchar(24) DEFAULT '' COMMENT '企业对公账号',
  `corp_acct_bank` varchar(64) DEFAULT '' COMMENT '对公开户行',
  `corp_acct_branch_bank` varchar(64) DEFAULT '' COMMENT '对公开户行支行',
  `is_corp_valid` varchar(24) DEFAULT '' COMMENT '是否打款验证通过',
  `create_id` varchar(32) DEFAULT '' COMMENT '创建用户 id',
  `create_name` varchar(32) DEFAULT '' COMMENT '创建用户名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_id` varchar(32) DEFAULT '' COMMENT '更新用户 id',
  `update_name` varchar(32) DEFAULT '' COMMENT '更新用户名',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) DEFAULT '' COMMENT '说明',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci  COMMENT='贷款风控准入表';


DROP TABLE IF EXISTS `kyc_bank`;
CREATE TABLE `kyc_bank` (
  `id` varchar(32) NOT NULL,
  `kyc_natural_id` varchar(32) NOT NULL DEFAULT '' COMMENT '注册用户主键 id',
  `account_name` varchar(32) DEFAULT '' COMMENT '银行卡用户名',
  `currency_code` varchar(32) DEFAULT '' COMMENT '账号币种',
  `account_no` varchar(32) DEFAULT '' COMMENT '银行卡号',
  `phone` varchar(32) DEFAULT '' COMMENT '银行卡预留手机号',
  `state_or_region` varchar(200) NOT NULL DEFAULT '' COMMENT '银行卡所属地域',
  `bank_name` varchar(32) DEFAULT '' COMMENT '银行名称',
  `bank_code` varchar(32) DEFAULT '' COMMENT '银行编码',
  `province_code` varchar(32) DEFAULT '' COMMENT '省份编码',
  `province_name` varchar(32) DEFAULT '' COMMENT '省份名称',
  `city_code` varchar(32) DEFAULT '' COMMENT '城市编码',
  `city_name` varchar(32) DEFAULT '' COMMENT '城市名称',
  `bank_branch_code` varchar(32) DEFAULT '' COMMENT '银行支行行号',
  `bank_branch_name` varchar(32) DEFAULT '' COMMENT '银行支行名称',
  `acct_type` varchar(32) NOT NULL DEFAULT '' COMMENT '账户类型（‘C’–对公，‘P’–对私）',
  `route_type` varchar(32) NOT NULL DEFAULT '' COMMENT '提现类型-（SUNRATE_走寻汇受益人通道。HFGJ_走汇付国际通道）',
  `swift_code` varchar(32) DEFAULT '' COMMENT 'swiftcode',
  `main_flag` tinyint(1) DEFAULT 0 COMMENT '是否主卡，1主卡',
  `effective_flag` tinyint(1) DEFAULT 0 COMMENT '是否有效，1有效',
  `del_flag` tinyint(1) NOT NULL DEFAULT 0,
  `create_id` varchar(32) NOT NULL DEFAULT '',
  `create_name` varchar(32) NOT NULL DEFAULT '',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(32) DEFAULT '',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `js_remark` varchar(200) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='用户银行卡';

DROP TABLE IF EXISTS `js_bank`;
CREATE TABLE `js_bank` (
  `id` varchar(32) NOT NULL,
  `bank_name` varchar(32) DEFAULT '' COMMENT '开户行名称',
  `bank_code` varchar(32) DEFAULT '' COMMENT '开户行CODE',
  `sort` int(3) unsigned DEFAULT 0 COMMENT '排序',
  `del_flag` tinyint(1) NOT NULL DEFAULT 0,
  `create_id` varchar(32) NOT NULL DEFAULT '',
  `create_name` varchar(32) NOT NULL DEFAULT '',
  `js_remark` varchar(200) DEFAULT '',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_id` varchar(32) DEFAULT '',
  `update_name` varchar(32) DEFAULT '',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='开户银行码表';

DROP TABLE IF EXISTS `js_trade`;
CREATE TABLE `js_trade` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL COMMENT 'id',
  `kyc_natural_id` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '注册信息表主键ID',
  `trade_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '' COMMENT '外部交易单号',
   acc_type  varchar(4) comment '账户类型 1.寻汇，2.汇付',
  `trade_type` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易类型[0:账户入账,1:账户出账]',
  `in_acct` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '入账账户号',
  `in_acct_name` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '入账账户名称',
  `out_acct` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '出账账户号',
  `out_acct_name` varchar(45) CHARACTER SET utf8 DEFAULT '' COMMENT '出账账户名称',
  `trade_sub_type` varchar(32) COLLATE utf8mb4_general_ci NOT NULL COMMENT '交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费,5:vat,6:供应商付款,7:放款]',
  `cur_id` char(3) CHARACTER SET utf8 NOT NULL DEFAULT 'SUD' COMMENT '币种',
  `trade_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '交易金额',
  `out_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '出账金额',
  `in_amt` decimal(15,2) NOT NULL DEFAULT '0.00' COMMENT '入账金额',
  `trade_dts` datetime DEFAULT NULL COMMENT '交易时间',
  `process_status` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT 'TRADE_UNPROCESSED' COMMENT '处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '',
  `create_name` varchar(20) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT NULL,
  `update_name` varchar(20) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='所有账户交易流水表';


CREATE TABLE `generate_file_record` (
  `id` varchar(32) CHARACTER SET utf8 NOT NULL,
  `kyc_natural_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '注册表主键ID',
  `generate_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '生成文件编号',
  `generate_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '生成类型（GENERATE_TRADE_RECORD-下载交易记录，GENERATE_TRADE_RECEIPT-下载回执单，GENERATE_FUND_RECORD-下载资金记录）',
  `generate_start_date` date DEFAULT '0001-01-01' COMMENT '生成起始日期',
  `generate_end_date` date DEFAULT '0001-01-01' COMMENT '生成结束日期',
  `trade_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '交易类型',
  `acct_no` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '账号',
  `comm_file_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT 'js文件资源表主键ID',
  `file_save_path` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '存放路径',
  `file_show_name` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '显示名称',
  `file_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '下载文件类型',
  `store_plateform_code` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '平台编码',
  `store_plateform_name` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '平台名称',
  `kyc_store_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '店铺ID',
  `store_name` varchar(50) DEFAULT '' COMMENT '店铺名称',
  `language_type` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '语言类型',
  `process_status` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT 'TRADE_UNPROCESSED' COMMENT '文件生成状态(TRADE_UNPROCESSED-生成中，TRADE_PROCESSED-生成完成)',
  `create_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '创建人ID',
  `create_name` varchar(100) CHARACTER SET utf8 DEFAULT '创建人名称',
  `create_dts` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_id` varchar(32) CHARACTER SET utf8 DEFAULT '' COMMENT '更新人ID',
  `update_name` varchar(100) CHARACTER SET utf8 DEFAULT '更新人名称',
  `update_dts` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `js_remark` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '说明',
  `del_flag` tinyint(1) unsigned DEFAULT '0' COMMENT '是否删除[0:不删除, 1:删除]',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='文件生成记录表';


