/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.sampledata;

import com.fusioncharts.database.DBConnection;
import com.fusioncharts.sampledata.ChartType;
import com.fusioncharts.sampledata.DOMHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FactoriesWithJSLinkBean {
    protected String chartId = "FactorySum";
    protected String width = "600";
    protected String height = "300";
    protected String filename = ChartType.PIE3D.getFileName();
    protected String xml = null;
    protected String useSingleQuotes = "true";
    protected String factoryDetailsJsArrAsStr = null;

    public String getChartId() {
        return this.chartId;
    }

    public String getFactoryDetailsJsArrAsStr() {
        String jsVarString = "";
        try {
            DBConnection dbConn = new DBConnection();
            Connection oConn = dbConn.getConnection();
            Statement st1 = null;
            Statement st2 = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            String strQuery = "";
            strQuery = "select * from Factory_Master";
            st1 = oConn.createStatement();
            rs1 = st1.executeQuery(strQuery);
            String factoryId = null;
            String quantity = "";
            java.sql.Date date = null;
            Date uDate = null;
            String uDateStr = "";
            int indexCount = 0;
            while (rs1.next()) {
                factoryId = rs1.getString("FactoryId");
                jsVarString = String.valueOf(jsVarString) + "\t\tdata[" + ++indexCount + "] = new Array();\n";
                strQuery = "select * from Factory_Output where FactoryId=" + factoryId + " order by DatePro Asc ";
                st2 = oConn.createStatement();
                rs2 = st2.executeQuery(strQuery);
                while (rs2.next()) {
                    date = rs2.getDate("DatePro");
                    quantity = rs2.getString("Quantity");
                    if (date != null) {
                        uDate = new Date(date.getTime());
                        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM");
                        uDateStr = sdf.format(uDate);
                    }
                    jsVarString = String.valueOf(jsVarString) + "\t\tdata[" + indexCount + "].push(new Array('" + uDateStr + "'," + quantity + "));" + "\n\r";
                }
            }
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st1 != null) {
                    st1.close();
                    st1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            try {
                if (oConn != null) {
                    oConn.close();
                    oConn = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the connection");
            }
        }
        catch (SQLException e) {
            System.out.println("Could not close the statement");
        }
        return jsVarString;
    }

    private String getFactoryXML() {
        String strXML = "";
        try {
            DBConnection dbConn = new DBConnection();
            Connection oConn = dbConn.getConnection();
            Statement st1 = null;
            Statement st2 = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            String strQuery = "";
            HashMap<String, String> chartAttributes = new HashMap<String, String>();
            chartAttributes.put("caption", "Factory Output report");
            chartAttributes.put("subCaption", "By Quantity");
            chartAttributes.put("pieSliceDepth", "30");
            chartAttributes.put("showBorder", "1");
            chartAttributes.put("formatNumberScale", "0");
            chartAttributes.put("numberSuffix", " Units");
            DOMHelper domHelper = new DOMHelper();
            Document chartDoc = domHelper.getDocument();
            Element rootElement = chartDoc.createElement("chart");
            domHelper.addAttributesToElement(rootElement, chartAttributes);
            strQuery = "select * from Factory_Master";
            st1 = oConn.createStatement();
            rs1 = st1.executeQuery(strQuery);
            String factoryId = null;
            String factoryName = null;
            String totalOutput = "";
            int indexCount = 0;
            while (rs1.next()) {
                ++indexCount;
                totalOutput = "";
                factoryId = rs1.getString("FactoryId");
                factoryName = rs1.getString("FactoryName");
                strQuery = "select sum(Quantity) as TotOutput from Factory_Output where FactoryId=" + factoryId;
                st2 = oConn.createStatement();
                rs2 = st2.executeQuery(strQuery);
                if (rs2.next()) {
                    totalOutput = rs2.getString("TotOutput");
                }
                Element setElem = chartDoc.createElement("set");
                setElem.setAttribute("label", factoryName);
                setElem.setAttribute("value", totalOutput);
                setElem.setAttribute("link", "javaScript:updateChart(" + indexCount + ",\"" + factoryName + "\")");
                rootElement.appendChild(setElem);
                try {
                    if (rs2 != null) {
                        rs2.close();
                        rs2 = null;
                    }
                }
                catch (SQLException e) {
                    System.out.println("Could not close the resultset");
                }
                try {
                    if (st2 == null) continue;
                    st2.close();
                    st2 = null;
                }
                catch (SQLException e) {
                    System.out.println("Could not close the statement");
                }
            }
            chartDoc.appendChild(rootElement);
            strXML = domHelper.getXMLString(chartDoc);
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st1 != null) {
                    st1.close();
                    st1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            try {
                if (oConn != null) {
                    oConn.close();
                    oConn = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the connection");
            }
        }
        catch (SQLException e) {
            System.out.println("Could not close the statement");
        }
        return strXML;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeight() {
        return this.height;
    }

    public String getUseSingleQuotes() {
        return this.useSingleQuotes;
    }

    public String getWidth() {
        return this.width;
    }

    public String getXml() {
        this.xml = this.getFactoryXML();
        return this.xml;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setUseSingleQuotes(String useSingleQuotes) {
        this.useSingleQuotes = useSingleQuotes;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

