/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.sampledata;

import com.fusioncharts.database.DBConnection;
import com.fusioncharts.sampledata.ChartType;
import com.fusioncharts.sampledata.DOMHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FactoriesBean {
    protected String chartId = "FactorySum";
    protected String width = "600";
    protected String height = "300";
    protected String filename = ChartType.PIE3D.getFileName();
    protected String xml = null;
    protected String useSingleQuotes = "true";

    public String getChartId() {
        return this.chartId;
    }

    private String getFactoryXML() {
        String strXML = "";
        try {
            DBConnection dbConn = new DBConnection();
            Connection oConn = dbConn.getConnection();
            Statement st1 = null;
            Statement st2 = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            String strQuery = "";
            HashMap<String, String> chartAttributes = new HashMap<String, String>();
            chartAttributes.put("caption", "Factory Output report");
            chartAttributes.put("subCaption", "By Quantity");
            chartAttributes.put("pieSliceDepth", "30");
            chartAttributes.put("showBorder", "1");
            chartAttributes.put("formatNumberScale", "0");
            chartAttributes.put("numberSuffix", " Units");
            DOMHelper domHelper = new DOMHelper();
            Document chartDoc = domHelper.getDocument();
            Element rootElement = chartDoc.createElement("chart");
            domHelper.addAttributesToElement(rootElement, chartAttributes);
            strQuery = "select * from Factory_Master";
            st1 = oConn.createStatement();
            rs1 = st1.executeQuery(strQuery);
            String factoryId = null;
            String factoryName = null;
            String totalOutput = "";
            while (rs1.next()) {
                totalOutput = "";
                factoryId = rs1.getString("FactoryId");
                factoryName = rs1.getString("FactoryName");
                strQuery = "select sum(Quantity) as TotOutput from Factory_Output where FactoryId=" + factoryId;
                st2 = oConn.createStatement();
                rs2 = st2.executeQuery(strQuery);
                if (rs2.next()) {
                    totalOutput = rs2.getString("TotOutput");
                }
                Element setElem = chartDoc.createElement("set");
                setElem.setAttribute("label", factoryName);
                setElem.setAttribute("value", totalOutput);
                setElem.setAttribute("link", "javaScript:updateChart(" + factoryId + ")");
                rootElement.appendChild(setElem);
                try {
                    if (rs2 != null) {
                        rs2.close();
                        rs2 = null;
                    }
                }
                catch (SQLException e) {
                    System.out.println("Could not close the resultset");
                }
                try {
                    if (st2 == null) continue;
                    st2.close();
                    st2 = null;
                }
                catch (SQLException e) {
                    System.out.println("Could not close the statement");
                }
            }
            chartDoc.appendChild(rootElement);
            strXML = domHelper.getXMLString(chartDoc);
            try {
                if (rs1 != null) {
                    rs1.close();
                    rs1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the resultset");
            }
            try {
                if (st1 != null) {
                    st1.close();
                    st1 = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the statement");
            }
            try {
                if (oConn != null) {
                    oConn.close();
                    oConn = null;
                }
            }
            catch (SQLException e) {
                System.out.println("Could not close the connection");
            }
        }
        catch (SQLException e) {
            System.out.println("Could not close the statement");
        }
        return strXML;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHeight() {
        return this.height;
    }

    public String getUseSingleQuotes() {
        return this.useSingleQuotes;
    }

    public String getWidth() {
        return this.width;
    }

    public String getXml() {
        this.xml = this.getFactoryXML();
        return this.xml;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setUseSingleQuotes(String useSingleQuotes) {
        this.useSingleQuotes = useSingleQuotes;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

