/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.beans;

import com.fusioncharts.exporter.FusionChartsExportHelper;
import com.fusioncharts.exporter.beans.ChartMetadata;
import com.fusioncharts.exporter.beans.ExportParameterNames;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportBean {
    private ChartMetadata metadata;
    private String stream;
    private HashMap<String, Object> exportParameters = null;

    public ExportBean() {
        this.exportParameters = new HashMap();
        this.exportParameters.put(ExportParameterNames.EXPORTFILENAME.toString(), "FusionCharts");
        this.exportParameters.put(ExportParameterNames.EXPORTACTION.toString(), "download");
        this.exportParameters.put(ExportParameterNames.EXPORTTARGETWINDOW.toString(), "_self");
        this.exportParameters.put(ExportParameterNames.EXPORTFORMAT.toString(), "PDF");
    }

    public ExportBean(String stream, ChartMetadata metadata, HashMap<String, Object> exportParameters) {
        this.stream = stream;
        this.metadata = metadata;
        this.exportParameters = exportParameters;
    }

    public void addExportParameter(String parameterName, Object value) {
        this.exportParameters.put(parameterName.toLowerCase(), value);
    }

    public void addExportParametersFromMap(HashMap<String, String> moreParameters) {
        this.exportParameters.putAll(moreParameters);
    }

    public HashMap<String, Object> getExportParameters() {
        return new HashMap<String, Object>(this.exportParameters);
    }

    public Object getExportParameterValue(String key) {
        return this.exportParameters.get(key);
    }

    public ChartMetadata getMetadata() {
        return this.metadata;
    }

    public String getMetadataAsQueryString(String filePath, boolean isError, boolean isHTML) {
        String queryParams = "";
        if (isError) {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "width=0";
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "height=0";
        } else {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "width=" + this.metadata.getWidth();
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "height=" + this.metadata.getHeight();
        }
        queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "DOMId=" + this.metadata.getDOMId();
        if (filePath != null) {
            queryParams = String.valueOf(queryParams) + (isHTML ? "<BR>" : "&") + "fileName=" + filePath;
        }
        return queryParams;
    }

    public String getParametersAndMetadataAsQueryString() {
        String queryParams = "";
        queryParams = String.valueOf(queryParams) + "?width=" + this.metadata.getWidth();
        queryParams = String.valueOf(queryParams) + "&height=" + this.metadata.getHeight();
        queryParams = String.valueOf(queryParams) + "&bgcolor=" + this.metadata.getBgColor();
        for (String key : this.exportParameters.keySet()) {
            String value = (String)this.exportParameters.get(key);
            queryParams = String.valueOf(queryParams) + "&" + key + "=" + value;
        }
        return queryParams;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isHTMLResponse() {
        boolean isHTML = false;
        String exportAction = (String)this.getExportParameterValue(ExportParameterNames.EXPORTACTION.toString());
        if (exportAction != null && exportAction.equals("download")) {
            isHTML = true;
        }
        return isHTML;
    }

    public void setExportParameters(HashMap<String, Object> exportParameters) {
        this.exportParameters = exportParameters;
    }

    public void setMetadata(ChartMetadata metadata) {
        this.metadata = metadata;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public LogMessageSetVO validate() {
        LogMessageSetVO errorSetVO = new LogMessageSetVO();
        if (this.getMetadata().getWidth() == -1.0 || this.getMetadata().getHeight() == -1.0 || this.getMetadata().getWidth() == 0.0 || this.getMetadata().getHeight() == 0.0) {
            errorSetVO.addError(LOGMESSAGE.E101);
        }
        if (this.getMetadata().getBgColor() == null) {
            errorSetVO.addWarning(LOGMESSAGE.W513);
        }
        if (this.getStream() == null) {
            errorSetVO.addError(LOGMESSAGE.E100);
        }
        if (this.exportParameters == null || this.exportParameters.isEmpty()) {
            errorSetVO.addWarning(LOGMESSAGE.W102);
        } else {
            String exportFormat = (String)this.getExportParameterValue(ExportParameterNames.EXPORTFORMAT.toString());
            boolean exportFormatSupported = FusionChartsExportHelper.getHandlerAssociationsMap().containsKey(exportFormat.toUpperCase());
            if (!exportFormatSupported) {
                errorSetVO.addError(LOGMESSAGE.E517);
            }
        }
        return errorSetVO;
    }
}

