/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static byte[] readResourceBytes(String resourceName) {
        InputStream is = Util.class.getResourceAsStream(resourceName);
        try {
            byte[] byArray = Util.bytes(is);
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            Util.close(is);
        }
    }

    public static String readResource(String resourceName) {
        InputStream is = Util.class.getResourceAsStream(resourceName);
        try {
            String string = Util.read(is);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            Util.close(is);
        }
    }

    public static String readResource(String resourceName, String charset) {
        InputStream is = Util.class.getResourceAsStream(resourceName);
        try {
            String string = Util.read(is, charset);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            Util.close(is);
        }
    }

    public static String readFile(String fileName) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            string = Util.read(in);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
        }
        Util.close(in);
        return string;
    }

    public static String readFile(String fileName, String charset) {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            string = Util.read(in, charset);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Util.close(in);
                throw throwable;
            }
        }
        Util.close(in);
        return string;
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String read(InputStream in) throws IOException {
        return Util.read(in, "UTF-8");
    }

    public static String read(InputStream in, String charset) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        int x = reader.read(buffer);
        while (x != -1) {
            sb.append(buffer, 0, x);
            x = reader.read(buffer);
        }
        return sb.toString();
    }

    public static byte[] bytes(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[1024];
        int x = in.read(bytes);
        while (x != -1) {
            bout.write(bytes, 0, x);
            x = in.read(bytes);
        }
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] byArray = Util.bytes(is);
            return byArray;
        }
        finally {
            Util.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResourceLines(String resourceName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(Util.class.getResourceAsStream(resourceName)));
        try {
            String tmp;
            while ((tmp = reader.readLine()) != null) {
                lines.add(tmp);
            }
        }
        finally {
            Util.close(reader);
        }
        return lines;
    }

    public static boolean blank(Object value) {
        return value == null || value.toString().trim().equals("");
    }

    public static String join(String[] collection, String delimiter) {
        return Util.join(Arrays.asList(collection), delimiter);
    }

    public static String[] split(String input, char delimiter) {
        if (input == null) {
            throw new NullPointerException("input cannot be null");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(input, new String(new byte[]{(byte)delimiter}));
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String join(Collection collection, String delimiter) {
        if (collection.size() == 0) {
            return "";
        }
        String tmp = "";
        for (Object o : collection) {
            tmp = tmp + o + delimiter;
        }
        return tmp.substring(0, tmp.length() - delimiter.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTo(String path, InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("input stream cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        FileOutputStream out = new FileOutputStream(path);
        try {
            byte[] bytes = new byte[1024];
            int x = in.read(bytes);
            while (x != -1) {
                out.write(bytes, 0, x);
                x = in.read(bytes);
            }
        }
        finally {
            Util.close(out);
        }
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(throwable.toString());
        throwable.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

