/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.RowListener;

public class RowProcessor {
    private ResultSet rs;
    private Statement s;

    protected RowProcessor(ResultSet rs, Statement s) {
        this.rs = rs;
        this.s = s;
    }

    public void with(RowListener listener) {
        try {
            this.processRS(listener);
        }
        catch (Exception e) {
            throw new DBException(e);
        }
        finally {
            try {
                this.rs.close();
            }
            catch (Exception e) {}
            try {
                this.s.close();
            }
            catch (Exception e) {}
        }
    }

    protected void processRS(RowListener listener) throws SQLException {
        ResultSetMetaData metaData = this.rs.getMetaData();
        String[] labels = new String[metaData.getColumnCount()];
        for (int i = 1; i <= labels.length; ++i) {
            labels[i - 1] = metaData.getColumnLabel(i);
        }
        while (this.rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (String label : labels) {
                row.put(label.toLowerCase(), this.rs.getObject(label));
            }
            if (listener.next(row)) continue;
            break;
        }
        this.rs.close();
        this.s.close();
    }
}

