/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.annotations.DbName;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.common.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModel<T extends Model, E extends Association>
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MetaModel.class);
    private Map<String, ColumnMetadata> columnMetadata;
    private List<Association> associations = new ArrayList<Association>();
    private String idName;
    private String tableName;
    private String dbType;
    private String dbName;
    private Class<T> modelClass;
    private boolean cached;
    private String idGeneratorCode;
    private List<String> attributeNamesNoId;

    protected MetaModel(String dbName, String tableName, String idName, Class<T> modelClass, String dbType, boolean cached, String idGeneratorCode) {
        this.idName = idName.toLowerCase();
        this.tableName = tableName;
        this.modelClass = modelClass;
        this.dbType = dbType;
        this.cached = cached;
        this.dbName = dbName;
        this.idGeneratorCode = idGeneratorCode;
    }

    public String getIdGeneratorCode() {
        return this.idGeneratorCode;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean cached() {
        return this.cached;
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    void setColumnMetadata(Map<String, ColumnMetadata> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    protected boolean tableExists() {
        return this.columnMetadata != null && this.columnMetadata.size() > 0;
    }

    public List<String> getAttributeNamesSkipId() {
        if (this.attributeNamesNoId == null) {
            this.attributeNamesNoId = this.getAttributeNames();
            this.attributeNamesNoId.remove(this.getIdName());
        }
        return this.attributeNamesNoId;
    }

    public List<String> getAttributeNamesSkipGenerated() {
        List<String> attributes = this.getAttributeNames();
        attributes.remove(this.getIdName().toLowerCase());
        attributes.remove("created_at");
        attributes.remove("updated_at");
        attributes.remove("record_version");
        return attributes;
    }

    public List<String> getAttributeNamesSkip(String ... names) {
        List<String> attributes = this.getAttributeNames();
        for (String name : names) {
            attributes.remove(name.toLowerCase());
        }
        return attributes;
    }

    public boolean isVersioned() {
        List<String> attrs = this.getAttributeNames();
        return attrs.contains("record_version") || attrs.contains("RECORD_VERSION");
    }

    protected List<String> getAttributeNames() {
        ArrayList<String> keysList = new ArrayList<String>();
        if (this.columnMetadata == null || this.columnMetadata.size() == 0) {
            throw new InitException("Failed to find table: " + this.getTableName());
        }
        for (String key : this.columnMetadata.keySet()) {
            keysList.add(key);
        }
        return keysList;
    }

    public String getIdName() {
        return this.idName;
    }

    public E getAssociationForTarget(String target, Class<? extends Association> associationClass) {
        Association result = null;
        for (Association association : this.associations) {
            if (!association.getTarget().equalsIgnoreCase(target) || !association.getClass().equals(associationClass)) continue;
            result = association;
            break;
        }
        return (E)result;
    }

    public E getAssociationForTarget(String target) {
        Association result = null;
        for (Association association : this.associations) {
            if (!association.getTarget().equalsIgnoreCase(target)) continue;
            result = association;
            break;
        }
        return (E)result;
    }

    public ArrayList<Association> getAssociationsForTarget(String target) {
        ArrayList<Association> result = new ArrayList<Association>();
        for (Association association : this.associations) {
            if (!association.getTarget().equalsIgnoreCase(target)) continue;
            result.add(association);
        }
        return result;
    }

    protected void addAssociation(Association association) {
        if (!this.associations.contains(association)) {
            LogFilter.log(logger, "Association found: " + association);
            this.associations.add(association);
        }
    }

    boolean hasAttribute(String attribute) {
        return this.columnMetadata != null && this.columnMetadata.containsKey(attribute.toLowerCase());
    }

    protected boolean hasAssociation(String table, Class<? extends Association> associationClass) {
        for (Association association : this.associations) {
            if (!association.getTarget().equalsIgnoreCase(table) || !association.getClass().equals(associationClass)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder t = new StringBuilder();
        t.append("MetaModel: ").append(this.tableName).append(", ").append(this.modelClass).append("\n");
        if (this.columnMetadata != null) {
            for (String key : this.columnMetadata.keySet()) {
                t.append(this.columnMetadata.get(key)).append(", ");
            }
        }
        return t.toString();
    }

    public String getFKName() {
        return Inflector.singularize(this.getTableName()).toLowerCase() + "_id";
    }

    protected List<OneToManyAssociation> getOneToManyAssociations(List<Association> exclusions) {
        ArrayList<OneToManyAssociation> one2Manies = new ArrayList<OneToManyAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(OneToManyAssociation.class) || exclusions.contains(association)) continue;
            one2Manies.add((OneToManyAssociation)association);
        }
        return one2Manies;
    }

    protected List<OneToManyPolymorphicAssociation> getPolymorphicAssociations(List<Association> exclusions) {
        ArrayList<OneToManyPolymorphicAssociation> one2Manies = new ArrayList<OneToManyPolymorphicAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(OneToManyPolymorphicAssociation.class) || exclusions.contains(association)) continue;
            one2Manies.add((OneToManyPolymorphicAssociation)association);
        }
        return one2Manies;
    }

    protected List<Many2ManyAssociation> getManyToManyAssociations(List<Association> excludedAssociations) {
        ArrayList<Many2ManyAssociation> many2Manies = new ArrayList<Many2ManyAssociation>();
        for (Association association : this.associations) {
            if (!association.getClass().equals(Many2ManyAssociation.class) || excludedAssociations.contains(association)) continue;
            many2Manies.add((Many2ManyAssociation)association);
        }
        return many2Manies;
    }

    public String getDbType() {
        return this.dbType;
    }

    public DefaultDialect getDialect() {
        return Registry.instance().getConfiguration().getDialect(this);
    }

    protected List<Association> getAssociations() {
        return Collections.unmodifiableList(this.associations);
    }

    protected void checkAttributeOrAssociation(String attributeOrAssociation) {
        List<Association> associations = this.getAssociations();
        ArrayList<String> associationTargets = new ArrayList<String>();
        String message = "\n";
        for (Association association : associations) {
            message = message + association + "\n";
            associationTargets.add(association.getTarget());
        }
        if (!this.hasAttribute(attributeOrAssociation) && !associationTargets.contains(attributeOrAssociation)) {
            throw new IllegalArgumentException("Attribute: '" + attributeOrAssociation + "' is not defined in model: '" + this.getModelClass() + "' and also, did not find an association by the same name, available attributes: " + this.getAttributeNames() + "\nAvailable associations: " + message);
        }
    }

    protected static String getDbName(Class<? extends Model> modelClass) {
        DbName dbNameAnnotation = modelClass.getAnnotation(DbName.class);
        return dbNameAnnotation == null ? "default" : dbNameAnnotation.value();
    }

    public Map<String, ColumnMetadata> getColumnMetadata() {
        return Collections.unmodifiableMap(this.columnMetadata);
    }

    public boolean isAssociatedTo(Class<? extends Model> targetModelClass) {
        boolean associated = false;
        for (Association association : this.associations) {
            Class<? extends Model> targetClass = null;
            targetClass = Registry.instance().getModelClass(association.getTarget(), true);
            if (targetClass == null || !targetClass.equals(targetModelClass)) continue;
            associated = true;
        }
        return associated;
    }
}

