/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.InternalException;
import org.javalite.activejdbc.LogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionsAccess {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionsAccess.class);
    private static ThreadLocal<HashMap<String, Connection>> connectionsTL = new ThreadLocal();

    static Map<String, Connection> getConnectionMap() {
        if (connectionsTL.get() == null) {
            connectionsTL.set(new HashMap());
        }
        return connectionsTL.get();
    }

    static Connection getConnection(String dbName) {
        return ConnectionsAccess.getConnectionMap().get(dbName);
    }

    static void attach(String dbName, Connection connection) {
        if (ConnectionsAccess.getConnectionMap().get(dbName) != null) {
            throw new InternalException("You are opening a connection " + dbName + " without closing a previous one. Check your logic. Connection still remains on thread: " + ConnectionsAccess.getConnectionMap().get(dbName));
        }
        LogFilter.log(logger, "Attaching connection: " + connection);
        ConnectionsAccess.getConnectionMap().put(dbName, connection);
        LogFilter.log(logger, "Opened connection:" + connection + " named: " + dbName + " on thread: " + Thread.currentThread());
    }

    static void detach(String dbName) {
        LogFilter.log(logger, "Detached connection: " + dbName);
        ConnectionsAccess.getConnectionMap().remove(dbName);
    }

    static List<Connection> getAllConnections() {
        return new ArrayList<Connection>(ConnectionsAccess.getConnectionMap().values());
    }
}

