/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.utils;

import com.deem.zkui.utils.ServletUtil;
import com.deem.zkui.vo.LeafBean;
import com.deem.zkui.vo.ZKNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ZooKeeperUtil {
    INSTANCE;

    public static final Integer MAX_CONNECT_ATTEMPT;
    public static final String ZK_ROOT_NODE = "/";
    public static final String ZK_SYSTEM_NODE = "zookeeper";
    public static final String ZK_HOSTS = "/appconfig/hosts";
    public static final String ROLE_USER = "USER";
    public static final String ROLE_ADMIN = "ADMIN";
    public static final String SOPA_PIPA = "SOPA/PIPA BLACKLISTED VALUE";
    private static final Logger logger;
    private ArrayList<ACL> defaultAcl = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    public ZooKeeper createZKConnection(String url, Integer zkSessionTimeout) throws IOException, InterruptedException {
        Integer connectAttempt = 0;
        ZooKeeper zk = new ZooKeeper(url, zkSessionTimeout, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
                logger.trace("Connecting to ZK.");
            }
        });
        while (zk.getState() != ZooKeeper.States.CONNECTED) {
            Thread.sleep(30L);
            Integer n = connectAttempt;
            Integer n2 = connectAttempt = Integer.valueOf(connectAttempt + 1);
            if (connectAttempt != MAX_CONNECT_ATTEMPT) continue;
            break;
        }
        return zk;
    }

    private ArrayList<ACL> defaultAcl() {
        return this.defaultAcl;
    }

    public void setDefaultAcl(String jsonAcl) {
        if (jsonAcl == null || jsonAcl.trim().length() == 0) {
            logger.trace("Using UNSAFE ACL. Anyone on your LAN can change your Zookeeper data");
            this.defaultAcl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
            return;
        }
        ArrayList<ACL> newDefault = new ArrayList<ACL>();
        try {
            JSONArray acls = (JSONArray)((JSONObject)new JSONParser().parse(jsonAcl)).get("acls");
            for (JSONObject acl : acls) {
                String scheme = ((String)acl.get("scheme")).trim();
                String id = ((String)acl.get("id")).trim();
                int perms = 0;
                String permStr = ((String)acl.get("perms")).toLowerCase().trim();
                block11: for (char c : permStr.toCharArray()) {
                    switch (c) {
                        case 'a': {
                            perms += 16;
                            continue block11;
                        }
                        case 'c': {
                            perms += 4;
                            continue block11;
                        }
                        case 'd': {
                            perms += 8;
                            continue block11;
                        }
                        case 'r': {
                            ++perms;
                            continue block11;
                        }
                        case 'w': {
                            perms += 2;
                            continue block11;
                        }
                        case '*': {
                            perms += 31;
                            continue block11;
                        }
                        default: {
                            throw new RuntimeException("Illegal permission character in ACL " + c);
                        }
                    }
                }
                newDefault.add(new ACL(perms, new Id(scheme, id)));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse default ACL " + jsonAcl, e);
        }
        this.defaultAcl = newDefault;
    }

    public Set<LeafBean> searchTree(String searchString, ZooKeeper zk, String authRole) throws InterruptedException, KeeperException {
        TreeSet<LeafBean> searchResult = new TreeSet<LeafBean>();
        TreeSet<LeafBean> leaves = new TreeSet<LeafBean>();
        this.exportTreeInternal(leaves, ZK_ROOT_NODE, zk, authRole);
        for (LeafBean leaf : leaves) {
            String leafValue = ServletUtil.INSTANCE.externalizeNodeValue(leaf.getValue());
            if (!leaf.getPath().contains(searchString) && !leaf.getName().contains(searchString) && !leafValue.contains(searchString)) continue;
            searchResult.add(leaf);
        }
        return searchResult;
    }

    public Set<LeafBean> exportTree(String zkPath, ZooKeeper zk, String authRole) throws InterruptedException, KeeperException {
        long startTime = System.currentTimeMillis();
        TreeSet<LeafBean> leaves = new TreeSet<LeafBean>();
        this.exportTreeInternal(leaves, zkPath, zk, authRole);
        long estimatedTime = System.currentTimeMillis() - startTime;
        logger.trace("Elapsed Time in Secs for Export: " + estimatedTime / 1000L);
        return leaves;
    }

    private void exportTreeInternal(Set<LeafBean> entries, String path, ZooKeeper zk, String authRole) throws InterruptedException, KeeperException {
        entries.addAll(this.listLeaves(zk, path, authRole));
        for (String folder : this.listFolders(zk, path)) {
            this.exportTreeInternal(entries, this.getNodePath(path, folder), zk, authRole);
        }
    }

    public void importData(List<String> importFile, Boolean overwrite, ZooKeeper zk) throws IOException, InterruptedException, KeeperException {
        for (String line : importFile) {
            logger.debug("Importing line " + line);
            if (line.startsWith("-")) {
                String nodeToDelete = line.substring(1);
                this.deleteNodeIfExists(nodeToDelete, zk);
                continue;
            }
            int firstEq = line.indexOf(61);
            int secEq = line.indexOf(61, firstEq + 1);
            String path = line.substring(0, firstEq);
            if (ZK_ROOT_NODE.equals(path)) {
                path = "";
            }
            String name = line.substring(firstEq + 1, secEq);
            String value = this.readExternalizedNodeValue(line.substring(secEq + 1));
            String fullNodePath = path + ZK_ROOT_NODE + name;
            if (fullNodePath.startsWith(ZK_SYSTEM_NODE)) {
                logger.debug("Skipping System Node Import: " + fullNodePath);
                continue;
            }
            boolean nodeExists = this.nodeExists(fullNodePath, zk);
            if (!nodeExists) {
                this.createPathAndNode(path, name, value.getBytes(), true, zk);
                continue;
            }
            if (overwrite.booleanValue()) {
                this.setPropertyValue(path + ZK_ROOT_NODE, name, value, zk);
                continue;
            }
            logger.info("Skipping update for existing property " + path + ZK_ROOT_NODE + name + " as overwrite is not enabled!");
        }
    }

    private String readExternalizedNodeValue(String raw) {
        return raw.replaceAll("\\\\n", "\n");
    }

    private void createPathAndNode(String path, String name, byte[] data, boolean force, ZooKeeper zk) throws InterruptedException, KeeperException {
        StringBuilder currPath = new StringBuilder();
        for (String folder : path.split(ZK_ROOT_NODE)) {
            if (folder.length() == 0) continue;
            currPath.append('/');
            currPath.append(folder);
            if (this.nodeExists(currPath.toString(), zk)) continue;
            this.createIfDoesntExist(currPath.toString(), new byte[0], true, zk);
        }
        this.createIfDoesntExist(path + '/' + name, data, force, zk);
    }

    private void createIfDoesntExist(String path, byte[] data, boolean force, ZooKeeper zooKeeper) throws InterruptedException, KeeperException {
        try {
            zooKeeper.create(path, data, this.defaultAcl(), CreateMode.PERSISTENT);
        }
        catch (KeeperException ke) {
            if (KeeperException.Code.NODEEXISTS.equals(ke.code())) {
                if (force) {
                    zooKeeper.delete(path, -1);
                    zooKeeper.create(path, data, this.defaultAcl(), CreateMode.PERSISTENT);
                }
            }
            throw ke;
        }
    }

    public ZKNode listNodeEntries(ZooKeeper zk, String path, String authRole) throws KeeperException, InterruptedException {
        ArrayList<String> folders = new ArrayList<String>();
        ArrayList<LeafBean> leaves = new ArrayList<LeafBean>();
        List<String> children = zk.getChildren(path, false);
        if (children != null) {
            for (String child : children) {
                boolean isFolder;
                if (child.equals(ZK_SYSTEM_NODE)) continue;
                List<String> subChildren = zk.getChildren(path + (ZK_ROOT_NODE.equals(path) ? "" : ZK_ROOT_NODE) + child, false);
                boolean bl = isFolder = subChildren != null && !subChildren.isEmpty();
                if (isFolder) {
                    folders.add(child);
                    continue;
                }
                String childPath = this.getNodePath(path, child);
                leaves.add(this.getNodeValue(zk, path, childPath, child, authRole));
            }
        }
        Collections.sort(folders);
        Collections.sort(leaves, new Comparator<LeafBean>(){

            @Override
            public int compare(LeafBean o1, LeafBean o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ZKNode zkNode = new ZKNode();
        zkNode.setLeafBeanLSt(leaves);
        zkNode.setNodeLst(folders);
        return zkNode;
    }

    @Deprecated
    public List<LeafBean> listLeaves(ZooKeeper zk, String path, String authRole) throws InterruptedException, KeeperException {
        ArrayList<LeafBean> leaves = new ArrayList<LeafBean>();
        List<String> children = zk.getChildren(path, false);
        if (children != null) {
            for (String child : children) {
                String childPath = this.getNodePath(path, child);
                List<Object> subChildren = Collections.emptyList();
                subChildren = zk.getChildren(childPath, false);
                boolean isFolder = subChildren != null && !subChildren.isEmpty();
                if (isFolder) continue;
                leaves.add(this.getNodeValue(zk, path, childPath, child, authRole));
            }
        }
        Collections.sort(leaves, new Comparator<LeafBean>(){

            @Override
            public int compare(LeafBean o1, LeafBean o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return leaves;
    }

    @Deprecated
    public List<String> listFolders(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        ArrayList<String> folders = new ArrayList<String>();
        List<String> children = zk.getChildren(path, false);
        if (children != null) {
            for (String child : children) {
                List<String> subChildren;
                boolean isFolder;
                if (child.equals(ZK_SYSTEM_NODE) || !(isFolder = (subChildren = zk.getChildren(path + (ZK_ROOT_NODE.equals(path) ? "" : ZK_ROOT_NODE) + child, false)) != null && !subChildren.isEmpty())) continue;
                folders.add(child);
            }
        }
        Collections.sort(folders);
        return folders;
    }

    public String getNodePath(String path, String name) {
        return path + (ZK_ROOT_NODE.equals(path) ? "" : ZK_ROOT_NODE) + name;
    }

    public LeafBean getNodeValue(ZooKeeper zk, String path, String childPath, String child, String authRole) {
        try {
            logger.trace("Lookup: path=" + path + ",childPath=" + childPath + ",child=" + child + ",authRole=" + authRole);
            byte[] dataBytes = zk.getData(childPath, false, new Stat());
            if (!authRole.equals(ROLE_ADMIN)) {
                if (this.checkIfPwdField(child).booleanValue()) {
                    return new LeafBean(path, child, SOPA_PIPA.getBytes());
                }
                return new LeafBean(path, child, dataBytes);
            }
            return new LeafBean(path, child, dataBytes);
        }
        catch (InterruptedException | KeeperException ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public Boolean checkIfPwdField(String property) {
        if (property.contains("PWD") || property.contains("pwd") || property.contains("PASSWORD") || property.contains("password") || property.contains("PASSWD") || property.contains("passwd")) {
            return true;
        }
        return false;
    }

    public void createNode(String path, String name, String value, ZooKeeper zk) throws KeeperException, InterruptedException {
        String nodePath = path + name;
        logger.debug("Creating node " + nodePath + " with value " + value);
        zk.create(nodePath, value == null ? null : value.getBytes(), this.defaultAcl(), CreateMode.PERSISTENT);
    }

    public void createFolder(String folderPath, String propertyName, String propertyValue, ZooKeeper zk) throws KeeperException, InterruptedException {
        logger.debug("Creating folder " + folderPath + " with property " + propertyName + " and value " + propertyValue);
        zk.create(folderPath, "".getBytes(), this.defaultAcl(), CreateMode.PERSISTENT);
        zk.create(folderPath + ZK_ROOT_NODE + propertyName, propertyValue == null ? null : propertyValue.getBytes(), this.defaultAcl(), CreateMode.PERSISTENT);
    }

    public void setPropertyValue(String path, String name, String value, ZooKeeper zk) throws KeeperException, InterruptedException {
        String nodePath = path + name;
        logger.debug("Setting property " + nodePath + " to " + value);
        zk.setData(nodePath, value.getBytes(), -1);
    }

    public boolean nodeExists(String nodeFullPath, ZooKeeper zk) throws KeeperException, InterruptedException {
        logger.trace("Checking if exists: " + nodeFullPath);
        return zk.exists(nodeFullPath, false) != null;
    }

    public void deleteFolders(List<String> folderNames, ZooKeeper zk) throws KeeperException, InterruptedException {
        for (String folderPath : folderNames) {
            this.deleteFolderInternal(folderPath, zk);
        }
    }

    private void deleteFolderInternal(String folderPath, ZooKeeper zk) throws KeeperException, InterruptedException {
        logger.debug("Deleting folder " + folderPath);
        for (String child : zk.getChildren(folderPath, false)) {
            this.deleteFolderInternal(this.getNodePath(folderPath, child), zk);
        }
        zk.delete(folderPath, -1);
    }

    public void deleteLeaves(List<String> leafNames, ZooKeeper zk) throws InterruptedException, KeeperException {
        for (String leafPath : leafNames) {
            logger.debug("Deleting leaf " + leafPath);
            zk.delete(leafPath, -1);
        }
    }

    private void deleteNodeIfExists(String path, ZooKeeper zk) throws InterruptedException, KeeperException {
        zk.delete(path, -1);
    }

    public void closeZooKeeper(ZooKeeper zk) throws InterruptedException {
        logger.trace("Closing ZooKeeper");
        if (zk != null) {
            zk.close();
            logger.trace("Closed ZooKeeper");
        }
    }

    static {
        MAX_CONNECT_ATTEMPT = 5;
        logger = LoggerFactory.getLogger(ZooKeeperUtil.class);
    }
}

