/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.validation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.javalite.activejdbc.Messages;
import org.javalite.activejdbc.Model;
import org.javalite.activejdbc.validation.Converter;
import org.javalite.common.Util;

public class DateConverter
extends Converter {
    private String attributeName;
    private String message;
    private String format;
    private SimpleDateFormat df;

    public DateConverter(String attributeName, String format) {
        this.attributeName = attributeName;
        this.message = "attribute {0} does not conform to format: {1}";
        this.df = new SimpleDateFormat(format);
        this.format = format;
    }

    public void convert(Model m) {
        Object val = m.get(this.attributeName);
        if (!Util.blank(val) && !(val instanceof Date)) {
            try {
                long time = this.df.parse(val.toString()).getTime();
                java.sql.Date d = new java.sql.Date(time);
                m.set(this.attributeName, (Object)d);
            }
            catch (Exception e) {
                m.addValidator(this, this.attributeName);
            }
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String formatMessage(Locale locale, Object ... params) {
        return locale != null ? Messages.message(this.message, locale, this.attributeName, this.format) : Messages.message(this.message, this.attributeName, this.format);
    }
}

