/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.listener;

import java.util.Arrays;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class SessionListener
implements HttpSessionListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionListener.class);

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        logger.trace("Session created");
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            ZooKeeper zk = (ZooKeeper)event.getSession().getAttribute("zk");
            zk.close();
            logger.trace("Session destroyed");
        }
        catch (InterruptedException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
        }
    }
}

