/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.dao;

import com.deem.zkui.domain.History;
import com.googlecode.flyway.core.Flyway;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.javalite.activejdbc.Base;
import org.javalite.activejdbc.LazyList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dao {
    private static final Integer FETCH_LIMIT = 50;
    private static final Logger logger = LoggerFactory.getLogger(Dao.class);
    private final Properties globalProps;

    public Dao(Properties globalProps) {
        this.globalProps = globalProps;
    }

    public void open() {
        Base.open(this.globalProps.getProperty("jdbcClass"), this.globalProps.getProperty("jdbcUrl"), this.globalProps.getProperty("jdbcUser"), this.globalProps.getProperty("jdbcPwd"));
    }

    public void close() {
        Base.close();
    }

    public void checkNCreate() {
        try {
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.globalProps.getProperty("jdbcUrl"), this.globalProps.getProperty("jdbcUser"), this.globalProps.getProperty("jdbcPwd"));
            if (this.globalProps.getProperty("env").equals("dev")) {
                flyway.clean();
            }
            flyway.migrate();
        }
        catch (Exception ex) {
            logger.error("Error trying to migrate db! Not severe hence proceeding forward.");
        }
    }

    public List<History> fetchHistoryRecords() {
        this.open();
        LazyList<History> history = History.findAll().orderBy("ID desc").limit(FETCH_LIMIT.intValue());
        history.size();
        this.close();
        return history;
    }

    public List<History> fetchHistoryRecordsByNode(String historyNode) {
        this.open();
        LazyList<History> history = History.where("CHANGE_SUMMARY like ?", historyNode).orderBy("ID desc").limit(FETCH_LIMIT.intValue());
        history.size();
        this.close();
        return history;
    }

    public void insertHistory(String user, String ipAddress, String summary) {
        try {
            this.open();
            if (summary.length() >= 500) {
                summary = summary.substring(0, 500);
            }
            History history = new History();
            history.setChangeUser(user);
            history.setChangeIp(ipAddress);
            history.setChangeSummary(summary);
            history.setChangeDate(new Date());
            history.save();
            this.close();
        }
        catch (Exception ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
        }
    }
}

