/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.controller;

import com.deem.zkui.utils.LdapAuth;
import com.deem.zkui.utils.ServletUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/login"})
public class Login
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(Login.class);

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("Login Action!");
        try {
            Properties globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
            HashMap<String, Object> templateParam = new HashMap<String, Object>();
            templateParam.put("uptime", globalProps.getProperty("uptime"));
            templateParam.put("loginMessage", globalProps.getProperty("loginMessage"));
            ServletUtil.INSTANCE.renderHtml(request, response, templateParam, "login.ftl.html");
        }
        catch (TemplateException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("Login Post Action!");
        try {
            Boolean authenticated;
            String role;
            String username;
            HttpSession session;
            HashMap<String, Object> templateParam;
            block8: {
                String password;
                Properties globalProps;
                block7: {
                    globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
                    templateParam = new HashMap<String, Object>();
                    session = request.getSession(true);
                    session.setMaxInactiveInterval(Integer.valueOf(globalProps.getProperty("sessionTimeout")));
                    username = request.getParameter("username");
                    password = request.getParameter("password");
                    role = null;
                    authenticated = false;
                    if (!globalProps.getProperty("ldapAuth").equals("true")) break block7;
                    authenticated = new LdapAuth().authenticateUser(globalProps.getProperty("ldapUrl"), username, password, globalProps.getProperty("ldapDomain"));
                    if (!authenticated.booleanValue()) break block8;
                    JSONArray jsonRoleSet = (JSONArray)((JSONObject)new JSONParser().parse(globalProps.getProperty("ldapRoleSet"))).get("users");
                    for (JSONObject jsonUser : jsonRoleSet) {
                        if (jsonUser.get("username") != null && jsonUser.get("username").equals("*")) {
                            role = (String)jsonUser.get("role");
                        }
                        if (jsonUser.get("username") == null || !jsonUser.get("username").equals(username)) continue;
                        role = (String)jsonUser.get("role");
                    }
                    if (role != null) break block8;
                    role = "USER";
                    break block8;
                }
                JSONArray jsonRoleSet = (JSONArray)((JSONObject)new JSONParser().parse(globalProps.getProperty("userSet"))).get("users");
                for (JSONObject jsonUser : jsonRoleSet) {
                    if (!jsonUser.get("username").equals(username) || !jsonUser.get("password").equals(password)) continue;
                    authenticated = true;
                    role = (String)jsonUser.get("role");
                }
            }
            if (authenticated.booleanValue()) {
                logger.info("Login successful: " + username);
                session.setAttribute("authName", username);
                session.setAttribute("authRole", role);
                response.sendRedirect("/home");
            } else {
                session.setAttribute("flashMsg", "Invalid Login");
                ServletUtil.INSTANCE.renderHtml(request, response, templateParam, "login.ftl.html");
            }
        }
        catch (TemplateException | ParseException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
    }
}

