/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.controller;

import com.deem.zkui.dao.Dao;
import com.deem.zkui.utils.ServletUtil;
import com.deem.zkui.utils.ZooKeeperUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/import"})
@MultipartConfig(fileSizeThreshold=0xA00000, maxFileSize=0x3200000L, maxRequestSize=0x6400000L)
public class Import
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(Import.class);

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("Importing Action!");
        try {
            String inputLine;
            InputStream inpStream;
            Properties globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
            Dao dao = new Dao(globalProps);
            String zkServer = globalProps.getProperty("zkServer");
            String[] zkServerLst = zkServer.split(",");
            StringBuilder sbFile = new StringBuilder();
            String scmOverwrite = "false";
            String scmServer = "";
            String scmFilePath = "";
            String scmFileRevision = "";
            String uploadFileName = "";
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(1034);
            ServletFileUpload upload = new ServletFileUpload(factory);
            List<FileItem> items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    if (item.getFieldName().equals("scmOverwrite")) {
                        scmOverwrite = item.getString();
                    }
                    if (item.getFieldName().equals("scmServer")) {
                        scmServer = item.getString();
                    }
                    if (item.getFieldName().equals("scmFilePath")) {
                        scmFilePath = item.getString();
                    }
                    if (!item.getFieldName().equals("scmFileRevision")) continue;
                    scmFileRevision = item.getString();
                    continue;
                }
                uploadFileName = item.getName();
                sbFile.append(item.getString());
            }
            if (sbFile.toString().length() == 0) {
                uploadFileName = scmServer + scmFileRevision + "@" + scmFilePath;
                logger.debug("P4 file Processing " + uploadFileName);
                dao.insertHistory((String)request.getSession().getAttribute("authName"), request.getRemoteAddr(), "Importing P4 File: " + uploadFileName + "<br/>Overwrite: " + scmOverwrite);
                URL url = new URL(uploadFileName);
                URLConnection conn = url.openConnection();
                inpStream = conn.getInputStream();
            } else {
                logger.debug("Upload file Processing " + uploadFileName);
                dao.insertHistory((String)request.getSession().getAttribute("authName"), request.getRemoteAddr(), "Uploading File: " + uploadFileName + "<br/>Overwrite: " + scmOverwrite);
                inpStream = new ByteArrayInputStream(sbFile.toString().getBytes());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(inpStream));
            ArrayList<String> importFile = new ArrayList<String>();
            Integer lineCnt = 0;
            while ((inputLine = br.readLine()) != null) {
                Integer n = lineCnt;
                Integer n2 = lineCnt = Integer.valueOf(lineCnt + 1);
                if (inputLine.trim().equals("") || inputLine.trim().startsWith("#")) continue;
                if (!inputLine.startsWith("-") && !inputLine.matches("/.+=.+=.*")) {
                    throw new IOException("Invalid format at line " + lineCnt + ": " + inputLine);
                }
                importFile.add(inputLine);
            }
            br.close();
            ZooKeeperUtil.INSTANCE.importData(importFile, Boolean.valueOf(scmOverwrite), ServletUtil.INSTANCE.getZookeeper(request, response, zkServerLst[0], globalProps));
            for (String line : importFile) {
                if (line.startsWith("-")) {
                    dao.insertHistory((String)request.getSession().getAttribute("authName"), request.getRemoteAddr(), "File: " + uploadFileName + ", Deleting Entry: " + line);
                    continue;
                }
                dao.insertHistory((String)request.getSession().getAttribute("authName"), request.getRemoteAddr(), "File: " + uploadFileName + ", Adding Entry: " + line);
            }
            request.getSession().setAttribute("flashMsg", "Import Completed!");
            response.sendRedirect("/home");
        }
        catch (IOException | InterruptedException | FileUploadException | KeeperException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
    }
}

