/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.controller;

import com.deem.zkui.dao.Dao;
import com.deem.zkui.domain.History;
import com.deem.zkui.utils.ServletUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/history"})
public class ChangeLog
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ChangeLog.class);

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("History Get Action!");
        try {
            Properties globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
            Dao dao = new Dao(globalProps);
            HashMap<String, Object> templateParam = new HashMap<String, Object>();
            List<History> historyLst = dao.fetchHistoryRecords();
            templateParam.put("historyLst", historyLst);
            templateParam.put("historyNode", "");
            ServletUtil.INSTANCE.renderHtml(request, response, templateParam, "history.ftl.html");
        }
        catch (TemplateException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("History Post Action!");
        try {
            Properties globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
            Dao dao = new Dao(globalProps);
            HashMap<String, Object> templateParam = new HashMap<String, Object>();
            String action = request.getParameter("action");
            if (action.equals("showhistory")) {
                String historyNode = request.getParameter("historyNode");
                List<History> historyLst = dao.fetchHistoryRecordsByNode("%" + historyNode + "%");
                templateParam.put("historyLst", historyLst);
                templateParam.put("historyNode", historyNode);
                ServletUtil.INSTANCE.renderHtml(request, response, templateParam, "history.ftl.html");
            } else {
                response.sendRedirect("/history");
            }
        }
        catch (TemplateException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
    }
}

