/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.javalite.http.Delete;
import org.javalite.http.Get;
import org.javalite.http.HttpException;
import org.javalite.http.Post;
import org.javalite.http.Put;

public class Http {
    public static int CONNECTION_TIMEOUT = 5000;
    public static int READ_TIMEOUT = 5000;

    public static Post post(String uri, String content) {
        return Http.post(uri, content.getBytes(), CONNECTION_TIMEOUT, READ_TIMEOUT);
    }

    public static Post post(String uri, byte[] content) {
        return Http.post(uri, content, CONNECTION_TIMEOUT, READ_TIMEOUT);
    }

    public static Post post(String url, byte[] content, int connectTimeout, int readTimeout) {
        try {
            return new Post(url, content, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Get get(String url) {
        return Http.get(url, CONNECTION_TIMEOUT, READ_TIMEOUT);
    }

    public static Get get(String url, int connectTimeout, int readTimeout) {
        try {
            return new Get(url, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Put put(String uri, String content) {
        return Http.put(uri, content.getBytes());
    }

    public static Put put(String uri, byte[] content) {
        return Http.put(uri, content, CONNECTION_TIMEOUT, READ_TIMEOUT);
    }

    public static Put put(String url, byte[] content, int connectTimeout, int readTimeout) {
        try {
            return new Put(url, content, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static Delete delete(String uri) {
        return Http.delete(uri, CONNECTION_TIMEOUT, READ_TIMEOUT);
    }

    public static Delete delete(String url, int connectTimeout, int readTimeout) {
        try {
            return new Delete(url, connectTimeout, readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public static String map2Content(Map params) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Set keySet = params.keySet();
            Object[] keys = keySet.toArray();
            for (int i = 0; i < keys.length; ++i) {
                stringBuilder.append(URLEncoder.encode(keys[i].toString(), "UTF-8")).append("=").append(URLEncoder.encode(params.get(keys[i]).toString(), "UTF-8"));
                if (i >= keys.length - 1) continue;
                stringBuilder.append("&");
            }
        }
        catch (Exception e) {
            throw new HttpException("failed to generate content from map", e);
        }
        return stringBuilder.toString();
    }
}

