/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.GregorianCalendar;
import org.javalite.common.ConversionException;
import org.javalite.common.Util;

public class Convert {
    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return Convert.clobToString((Clob)value);
        }
        return value.toString();
    }

    private static String clobToString(Clob clob) {
        try {
            Reader r = clob.getCharacterStream();
            StringWriter sw = new StringWriter();
            Convert.copyStream(r, sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyStream(Reader r, Writer w) throws IOException {
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = r.read(buffer))) {
            w.write(buffer, 0, n);
        }
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return value.equals(BigDecimal.ONE);
        }
        if (value instanceof Long) {
            return value.equals(1L);
        }
        if (value instanceof Integer) {
            return value.equals(1);
        }
        if (value instanceof Character) {
            return value.equals(Character.valueOf('y')) || value.equals(Character.valueOf('Y')) || value.equals(Character.valueOf('t')) || value.equals(Character.valueOf('T'));
        }
        return value.toString().equalsIgnoreCase("yes") || value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("y") || value.toString().equalsIgnoreCase("t") || Boolean.parseBoolean(value.toString());
    }

    public static Date toSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Time) {
            return new Date(((Time)value).getTime());
        }
        try {
            return Date.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("failed to convert: '" + value + "' to java.sql.Date", e);
        }
    }

    public static Date truncateToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Timestamp) {
            return Convert.utilDate2sqlDate(((Timestamp)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return Convert.utilDate2sqlDate(((java.util.Date)value).getTime());
        }
        if (value instanceof Time) {
            return Convert.utilDate2sqlDate(((Time)value).getTime());
        }
        try {
            return Date.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("failed to convert: '" + value + "' to java.sql.Date", e);
        }
    }

    private static Date utilDate2sqlDate(long time) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(time);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        DecimalFormat nf = new DecimalFormat();
        try {
            return nf.parse(value.toString()).doubleValue();
        }
        catch (ParseException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Double", e);
        }
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        return Timestamp.valueOf(value.toString());
    }

    public static Float toFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        DecimalFormat nf = new DecimalFormat();
        try {
            return Float.valueOf(nf.parse(value.toString()).floatValue());
        }
        catch (ParseException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Float", e);
        }
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        DecimalFormat nf = new DecimalFormat();
        try {
            return nf.parse(value.toString()).longValue();
        }
        catch (ParseException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Long", e);
        }
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        DecimalFormat nf = new DecimalFormat();
        try {
            return nf.parse(value.toString()).intValue();
        }
        catch (ParseException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Integer", e);
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public static byte[] toBytes(Object value) {
        try {
            if (value instanceof Blob) {
                Blob b = (Blob)value;
                return Util.bytes(b.getBinaryStream());
            }
            return value instanceof byte[] ? (byte[])value : Convert.toString(value).getBytes();
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
    }
}

