/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.dialects;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.ColumnMetadata;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.dialects.DefaultDialect;
import org.javalite.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDialect
extends DefaultDialect {
    @Override
    public String formSelect(String tableName, String subQuery, List<String> orderBys, long limit, long offset) {
        boolean needOffset;
        boolean needLimit = limit != -1L;
        boolean bl = needOffset = offset != -1L;
        if (needOffset && (orderBys == null || orderBys.isEmpty())) {
            throw new DBException("MSSQL offset queries require an order by column.");
        }
        limit = offset == -1L ? limit : offset + limit;
        String fullQuery = this.createBaseQuery(tableName, subQuery, needOffset);
        fullQuery = this.addOderBys(orderBys, needOffset, fullQuery);
        fullQuery = this.addOffsetAndLimit(orderBys, limit, ++offset, needLimit, needOffset, fullQuery);
        return fullQuery;
    }

    @Override
    public Object overrideDriverTypeConversion(MetaModel mm, String attributeName, Object value) {
        Map<String, ColumnMetadata> types = mm.getColumnMetadata();
        if (value != null && value instanceof String && types.get(attributeName.toLowerCase()).getTypeName().equalsIgnoreCase("date") && mm.getDialect() instanceof MSSQLDialect) {
            return Date.valueOf((String)value);
        }
        if (value != null && value instanceof String && types.get(attributeName.toLowerCase()).getTypeName().equalsIgnoreCase("datetime2") && mm.getDialect() instanceof MSSQLDialect) {
            return Timestamp.valueOf((String)value);
        }
        return value;
    }

    private String createBaseQuery(String tableName, String subQuery, boolean needOffset) {
        String fullQuery;
        if (tableName == null) {
            fullQuery = subQuery;
        } else {
            fullQuery = needOffset ? " * FROM " + tableName + " " : "SELECT {LIMIT} * FROM " + tableName;
            fullQuery = this.addSubQuery(subQuery, fullQuery);
        }
        return fullQuery;
    }

    private String addOderBys(List<String> orderBys, boolean needOffset, String fullQuery) {
        if (orderBys.size() != 0 && !needOffset) {
            fullQuery = fullQuery + " ORDER BY " + Util.join(orderBys, ", ");
        }
        return fullQuery;
    }

    private String addOffsetAndLimit(List<String> orderBys, long limit, long offset, boolean needLimit, boolean needOffset, String fullQuery) {
        String limitString = "";
        String fullQueryWithoutSelect = fullQuery.replaceFirst("^\\s*[Ss][Ee][Ll][Ee][Cc][Tt]", "");
        if (needLimit && needOffset) {
            fullQuery = "SELECT sq.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY " + Util.join(orderBys, ", ") + ") AS rownumber, " + fullQueryWithoutSelect + " ) AS sq WHERE rownumber BETWEEN " + offset + " AND " + limit + " ";
        } else if (needLimit && !needOffset) {
            limitString = " TOP " + limit + " ";
        } else if (needOffset) {
            fullQuery = "SELECT sq.* FROM ( SELECT ROW_NUMBER() OVER (ORDER BY " + Util.join(orderBys, ", ") + ") AS rownumber, " + fullQueryWithoutSelect + " ) AS sq WHERE rownumber >= " + offset + " ";
        }
        fullQuery = fullQuery.replace("{LIMIT}", limitString);
        return fullQuery;
    }

    private String addSubQuery(String subQuery, String fullQuery) {
        if (!Util.blank(subQuery)) {
            String where = " WHERE ";
            if (!this.groupByPattern.matcher(subQuery.toLowerCase().trim()).find() && !this.orderByPattern.matcher(subQuery.toLowerCase().trim()).find()) {
                fullQuery = fullQuery + where;
            }
            fullQuery = fullQuery + subQuery;
        }
        return fullQuery;
    }
}

