/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.Arrays;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCache {
    private static final Logger logger = LoggerFactory.getLogger(QueryCache.class);
    private static QueryCache instance = new QueryCache();
    private boolean enabled = Registry.instance().getConfiguration().cacheEnabled();
    private CacheManager cacheManager = Registry.instance().getConfiguration().getCacheManager();

    private QueryCache() {
    }

    public static QueryCache instance() {
        return instance;
    }

    public void addItem(String tableName, String query, Object[] params, Object cache) {
        if (this.enabled) {
            this.cacheManager.addCache(tableName, this.getKey(tableName, query, params), cache);
        }
    }

    public Object getItem(String tableName, String query, Object[] params) {
        if (this.enabled) {
            String key = this.getKey(tableName, query, params);
            Object item = this.cacheManager.getCache(tableName, key);
            if (item == null) {
                QueryCache.logAccess(query, params, "MISS");
            } else {
                QueryCache.logAccess(query, params, "HIT");
            }
            return item;
        }
        return null;
    }

    static void logAccess(String query, Object[] params, String access) {
        StringBuffer log = new StringBuffer(access).append(", ").append("\"").append(query).append("\"");
        if (params != null && params.length != 0) {
            log.append(", with parameters: ").append("<").append(Util.join(Arrays.asList(params), ">, <")).append(">");
        }
        LogFilter.log(logger, log.toString());
    }

    private String getKey(String tableName, String query, Object[] params) {
        return new StringBuffer(tableName).append(query).append(params == null ? null : Arrays.asList(params).toString()).toString();
    }

    public void purgeTableCache(String tableName) {
        if (this.enabled && Registry.instance().getMetaModel(tableName).cached()) {
            this.cacheManager.flush(new CacheEvent(tableName, this.getClass().getName()));
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

