/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.javalite.activejdbc.Association;
import org.javalite.activejdbc.CallbackListener;
import org.javalite.activejdbc.CallbackSupport;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.DBException;
import org.javalite.activejdbc.Errors;
import org.javalite.activejdbc.Formatter;
import org.javalite.activejdbc.FrozenException;
import org.javalite.activejdbc.InitException;
import org.javalite.activejdbc.LazyList;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.ModelListener;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.RowListenerAdapter;
import org.javalite.activejdbc.SimpleFormatter;
import org.javalite.activejdbc.StaleModelException;
import org.javalite.activejdbc.associations.BelongsToAssociation;
import org.javalite.activejdbc.associations.BelongsToPolymorphicAssociation;
import org.javalite.activejdbc.associations.Many2ManyAssociation;
import org.javalite.activejdbc.associations.NotAssociatedException;
import org.javalite.activejdbc.associations.OneToManyAssociation;
import org.javalite.activejdbc.associations.OneToManyPolymorphicAssociation;
import org.javalite.activejdbc.cache.QueryCache;
import org.javalite.activejdbc.validation.NumericValidationBuilder;
import org.javalite.activejdbc.validation.ValidationBuilder;
import org.javalite.activejdbc.validation.ValidationException;
import org.javalite.activejdbc.validation.ValidationHelper;
import org.javalite.activejdbc.validation.Validator;
import org.javalite.common.Convert;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.javalite.common.XmlEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model
extends CallbackSupport
implements Externalizable {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean frozen = false;
    private MetaModel metaModelLocal;
    private Map<Class, Model> cachedParents = new HashMap<Class, Model>();
    private Map<Class, List<Model>> cachedChildren = new HashMap<Class, List<Model>>();
    protected Errors errors = new Errors();

    protected Model() {
    }

    public static MetaModel getMetaModel() {
        Registry.instance().init(MetaModel.getDbName(Model.getDaClass()));
        return Registry.instance().getMetaModel(Model.getTableName());
    }

    protected Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void fromMap(Map input) {
        List<String> attributeNames = this.getMetaModelLocal().getAttributeNames();
        for (String attrName : attributeNames) {
            Object value = input.get(attrName.toLowerCase());
            if (value == null) {
                value = input.get(attrName.toUpperCase());
            }
            if (!input.containsKey(attrName.toLowerCase()) && !input.containsKey(attrName.toUpperCase())) continue;
            this.attributes.put(attrName.toLowerCase(), value);
        }
    }

    protected void hydrate(Map attributesMap) {
        List<String> attributeNames = this.getMetaModelLocal().getAttributeNamesSkipId();
        String idName = this.getMetaModelLocal().getIdName();
        Object id = attributesMap.get(idName);
        if (id != null) {
            this.attributes.put(idName, id);
        }
        for (String attrName : attributeNames) {
            if (attrName.equalsIgnoreCase(this.getMetaModelLocal().getIdName())) continue;
            Object value = attributesMap.get(attrName.toLowerCase());
            if (value == null) {
                value = attributesMap.get(attrName.toUpperCase());
            }
            if (value instanceof Clob && this.getMetaModelLocal().cached()) {
                this.attributes.put(attrName.toLowerCase(), Convert.toString(value));
                continue;
            }
            this.attributes.put(attrName, this.getMetaModelLocal().getDialect().overrideDriverTypeConversion(this.getMetaModelLocal(), attrName, value));
        }
    }

    public <T extends Model> T setId(Object id) {
        this.set(this.getIdName(), id);
        return (T)this;
    }

    public Model setDate(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toSqlDate(value));
    }

    public Date getDate(String attribute) {
        return Convert.toSqlDate(this.get(attribute));
    }

    public void setTS(String name, java.util.Date date) {
        if (date == null) {
            this.set(name, null);
        } else {
            this.set(name, (Object)new Timestamp(date.getTime()));
        }
    }

    public void set(String[] attributeNames, Object[] values) {
        if (attributeNames == null || values == null || attributeNames.length != values.length) {
            throw new IllegalArgumentException("must pass non-null arrays of equal length");
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            this.set(attributeNames[i], values[i]);
        }
    }

    public Model set(String attribute, Object value) {
        if (attribute.equalsIgnoreCase("created_at")) {
            throw new IllegalArgumentException("cannot set 'created_at'");
        }
        this.getMetaModelLocal().checkAttributeOrAssociation(attribute);
        this.attributes.put(attribute.toLowerCase(), value);
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static List<String> attributes() {
        return Model.getMetaModel().getAttributeNames();
    }

    public static List<Association> associations() {
        return Model.getMetaModel().getAssociations();
    }

    public boolean isNew() {
        return this.getId() == null;
    }

    public boolean frozen() {
        return this.isFrozen();
    }

    public boolean delete() {
        boolean result;
        this.fireBeforeDelete(this);
        if (1 == new DB(this.getMetaModelLocal().getDbName()).exec("DELETE FROM " + this.getMetaModelLocal().getTableName() + " WHERE " + this.getMetaModelLocal().getIdName() + "= ?", this.getId())) {
            this.frozen = true;
            if (this.getMetaModelLocal().cached()) {
                QueryCache.instance().purgeTableCache(this.getMetaModelLocal().getTableName());
            }
            Model.purgeEdges();
            result = true;
        } else {
            result = false;
        }
        this.fireAfterDelete(this);
        return result;
    }

    public void delete(boolean cascade) {
        if (cascade) {
            this.deleteCascade();
        } else {
            this.delete();
        }
    }

    public void deleteCascade() {
        this.deleteCascadeExcept(new Association[0]);
    }

    public void deleteCascadeExcept(Association ... excludedAssociations) {
        List<Association> excludedAssociationsList = Arrays.asList(excludedAssociations);
        this.deleteMany2ManyDeep(this.getMetaModelLocal().getManyToManyAssociations(excludedAssociationsList));
        this.deleteChildrenDeep(this.getMetaModelLocal().getOneToManyAssociations(excludedAssociationsList));
        this.deleteChildrenDeep(this.getMetaModelLocal().getPolymorphicAssociations(excludedAssociationsList));
        this.delete();
    }

    private void deleteMany2ManyDeep(List<Many2ManyAssociation> many2ManyAssociations) {
        ArrayList<? extends Model> allMany2ManyChildren = new ArrayList<Model>();
        for (Many2ManyAssociation many2ManyAssociation : many2ManyAssociations) {
            String targetTableName = many2ManyAssociation.getTarget();
            Class<? extends Model> c = Registry.instance().getModelClass(targetTableName, false);
            if (c == null) {
                logger.error("ActiveJDBC WARNING: failed to find a model class for: " + targetTableName + ", maybe model is not defined for this table?" + " There might be a risk of running into integrity constrain violation if this model is not defined.");
                continue;
            }
            allMany2ManyChildren.addAll(this.getAll(c));
        }
        this.deleteJoinsForManyToMany();
        for (Model model : allMany2ManyChildren) {
            model.deleteCascade();
        }
    }

    public void deleteCascadeShallow() {
        this.deleteJoinsForManyToMany();
        this.deleteOne2ManyChildrenShallow();
        this.deletePolymorphicChildrenShallow();
        this.delete();
    }

    private void deleteJoinsForManyToMany() {
        List<Many2ManyAssociation> associations = this.getMetaModelLocal().getManyToManyAssociations(new ArrayList<Association>());
        for (Association association : associations) {
            String join = ((Many2ManyAssociation)association).getJoin();
            String sourceFK = ((Many2ManyAssociation)association).getSourceFkName();
            String query = "DELETE FROM " + join + " WHERE " + sourceFK + " = " + this.getId();
            new DB(this.getMetaModelLocal().getDbName()).exec(query);
        }
    }

    private void deleteOne2ManyChildrenShallow() {
        List<OneToManyAssociation> childAssociations = this.getMetaModelLocal().getOneToManyAssociations(new ArrayList<Association>());
        for (OneToManyAssociation association : childAssociations) {
            String target = association.getTarget();
            String query = "DELETE FROM " + target + " WHERE " + association.getFkName() + " = ?";
            new DB(this.getMetaModelLocal().getDbName()).exec(query, this.getId());
        }
    }

    private void deletePolymorphicChildrenShallow() {
        List<OneToManyPolymorphicAssociation> polymorphics = this.getMetaModelLocal().getPolymorphicAssociations(new ArrayList<Association>());
        for (OneToManyPolymorphicAssociation association : polymorphics) {
            String target = association.getTarget();
            String parentType = association.getTypeLabel();
            String query = "DELETE FROM " + target + " WHERE parent_id = ? AND parent_type = ?";
            new DB(this.getMetaModelLocal().getDbName()).exec(query, this.getId(), parentType);
        }
    }

    private void deleteChildrenDeep(List<Association> childAssociations) {
        for (Association association : childAssociations) {
            String targetTableName = association.getTarget();
            Class<? extends Model> c = Registry.instance().getModelClass(targetTableName, false);
            if (c == null) {
                logger.error("ActiveJDBC WARNING: failed to find a model class for: " + targetTableName + ", maybe model is not defined for this table?" + " There might be a risk of running into integrity constrain violation if this model is not defined.");
                continue;
            }
            LazyList<? extends Model> dependencies = this.getAll(c);
            for (Model model : dependencies) {
                model.deleteCascade();
            }
        }
    }

    public static int delete(String query, Object ... params) {
        int count;
        MetaModel metaModel = Model.getMetaModel();
        int n = count = params == null || params.length == 0 ? new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName() + " WHERE " + query) : new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName() + " WHERE " + query, params);
        if (metaModel.cached()) {
            QueryCache.instance().purgeTableCache(metaModel.getTableName());
        }
        Model.purgeEdges();
        return count;
    }

    public static boolean exists(Object id) {
        MetaModel metaModel = Model.getMetaModel();
        return null != new DB(metaModel.getDbName()).firstCell("SELECT " + metaModel.getIdName() + " FROM " + metaModel.getTableName() + " WHERE " + metaModel.getIdName() + " = ?", id);
    }

    public boolean exists() {
        MetaModel metaModel = this.getMetaModelLocal();
        return null != new DB(metaModel.getDbName()).firstCell("SELECT " + metaModel.getIdName() + " FROM " + metaModel.getTableName() + " WHERE " + metaModel.getIdName() + " = ?", this.getId());
    }

    public static int deleteAll() {
        MetaModel metaModel = Model.getMetaModel();
        int count = new DB(metaModel.getDbName()).exec("DELETE FROM " + metaModel.getTableName());
        if (metaModel.cached()) {
            QueryCache.instance().purgeTableCache(metaModel.getTableName());
        }
        Model.purgeEdges();
        return count;
    }

    public static int update(String updates, String conditions, Object ... params) {
        return ModelDelegate.update(Model.getMetaModel(), updates, conditions, params);
    }

    public static int updateAll(String updates, Object ... params) {
        return Model.update(updates, null, params);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (String key : this.attributes.keySet()) {
            if (this.attributes.get(key) == null) continue;
            if (this.attributes.get(key) instanceof Clob) {
                retVal.put(key.toLowerCase(), this.getString(key));
                continue;
            }
            retVal.put(key.toLowerCase(), this.attributes.get(key));
        }
        for (Class parentClass : this.cachedParents.keySet()) {
            retVal.put(Inflector.underscore(Inflector.shortName(parentClass.getName())), this.cachedParents.get(parentClass).toMap());
        }
        for (Class childClass : this.cachedChildren.keySet()) {
            List<Model> children = this.cachedChildren.get(childClass);
            ArrayList<Map<String, Object>> childMaps = new ArrayList<Map<String, Object>>(children.size());
            for (Model child : children) {
                childMaps.add(child.toMap());
            }
            retVal.put(Inflector.pluralize(Inflector.underscore(Inflector.shortName(childClass.getName()))), childMaps);
        }
        return retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Model: ").append(this.getClass().getName()).append(", table: '").append(this.getMetaModelLocal().getTableName()).append("', attributes: ").append(this.attributes);
        if (this.cachedParents.size() > 0) {
            sb.append(", parents: ").append(this.cachedParents);
        }
        if (this.cachedChildren.size() > 0) {
            sb.append(", children: ").append(this.cachedChildren);
        }
        return sb.toString();
    }

    public String toXml(int spaces, boolean declaration, String ... attrs) {
        Map<String, Object> modelMap = this.toMap();
        String indent = "";
        for (int i = 0; i < spaces; ++i) {
            indent = indent + " ";
        }
        List<String> attrList = Arrays.asList(attrs);
        StringWriter sw = new StringWriter();
        if (declaration) {
            sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + (spaces > 0 ? "\n" : ""));
        }
        String topTag = Inflector.underscore(this.getClass().getSimpleName());
        sw.write(indent + "<" + topTag + ">" + (spaces > 0 ? "\n" : ""));
        for (String name : modelMap.keySet()) {
            Object value = modelMap.get(name);
            if ((attrList.contains(name) || attrs.length == 0) && !(value instanceof List)) {
                sw.write(indent + indent + "<" + name + ">" + XmlEntities.XML.escape(value.toString()) + "</" + name + ">" + (spaces > 0 ? "\n" : ""));
                continue;
            }
            if (!(value instanceof List)) continue;
            List children = (List)value;
            sw.write(indent + indent + "<" + name + ">" + (spaces > 0 ? "\n" : ""));
            for (Map child : children) {
                sw.write(indent + indent + indent + "<" + Inflector.singularize(name) + ">" + (spaces > 0 ? "\n" : ""));
                for (Object childKey : child.keySet()) {
                    sw.write(indent + indent + indent + indent + "<" + childKey + ">" + XmlEntities.XML.escape(child.get(childKey).toString()) + "</" + childKey + ">" + (spaces > 0 ? "\n" : ""));
                }
                sw.write(indent + indent + indent + "</" + Inflector.singularize(name) + ">" + (spaces > 0 ? "\n" : ""));
            }
            sw.write(indent + indent + "</" + name + ">" + (spaces > 0 ? "\n" : ""));
        }
        this.beforeClosingTag(spaces, sw, attrs);
        sw.write(indent + "</" + topTag + ">" + (spaces > 0 ? "\n" : ""));
        return sw.toString();
    }

    public void beforeClosingTag(int spaces, StringWriter writer, String ... attrs) {
    }

    public String toJson(boolean pretty, String ... attrs) {
        return this.toJsonP(pretty, "", attrs);
    }

    protected String toJsonP(boolean pretty, String indent, String ... attrs) {
        String val;
        List<String> attrList = Arrays.asList(attrs);
        Collections.sort(attrList);
        StringWriter sw = new StringWriter();
        sw.write(indent + "{" + (pretty ? "" + indent : ""));
        if (attrList.size() == 0) {
            sw.write("\"model_class\":\"" + this.getClass().getName() + "\",");
        }
        ArrayList<String> attributeStrings = new ArrayList<String>();
        if (attrList.size() == 0) {
            for (String name : this.attributes.keySet()) {
                val = this.getString(name);
                val = val == null ? val : val.replaceAll("\"", "\\\\\"");
                attributeStrings.add((pretty ? "\n  " + indent : "") + "\"" + name + "\":\"" + val + "\"");
            }
        } else {
            for (String name : attrList) {
                val = this.getString(name);
                val = val == null ? val : val.replaceAll("\"", "\\\\\"");
                attributeStrings.add((pretty ? "\n  " + indent : "") + "\"" + name + "\":\"" + val + "\"");
            }
        }
        sw.write(Util.join(attributeStrings, ","));
        if (this.cachedChildren != null && this.cachedChildren.size() > 0) {
            sw.write("," + (pretty ? "\n  " + indent : "") + "\"children\" : {");
            for (Class childClass : this.cachedChildren.keySet()) {
                String name = Inflector.pluralize(childClass.getSimpleName()).toLowerCase();
                sw.write((pretty ? "\n" + indent + "    " : "") + "\"" + name + "\" : [");
                ArrayList<String> childrenList = new ArrayList<String>();
                for (Model child : this.cachedChildren.get(childClass)) {
                    childrenList.add((pretty ? "\n" + indent : "") + child.toJsonP(pretty, pretty ? indent + "    " : "", new String[0]));
                }
                sw.write(Util.join(childrenList, ","));
                sw.write((pretty ? "\n" + indent + indent : "") + "]");
            }
            sw.write((pretty ? "\n" + indent + indent : "") + "}");
        }
        this.beforeClosingBrace(pretty, pretty ? "  " + indent : "", sw);
        sw.write((pretty ? "\n" + indent : "") + "}");
        return sw.toString();
    }

    public void beforeClosingBrace(boolean pretty, String indent, StringWriter writer) {
    }

    public <T extends Model> T parent(Class<T> parentClass) {
        Model parent;
        String fkName;
        String fkValue;
        Model cachedParent = this.cachedParents.get(parentClass);
        if (cachedParent != null) {
            return (T)cachedParent;
        }
        MetaModel parentMM = Registry.instance().getMetaModel(parentClass);
        String parentTable = parentMM.getTableName();
        BelongsToAssociation ass = (BelongsToAssociation)this.getMetaModelLocal().getAssociationForTarget(parentTable, BelongsToAssociation.class);
        BelongsToPolymorphicAssociation assP = (BelongsToPolymorphicAssociation)this.getMetaModelLocal().getAssociationForTarget(parentTable, BelongsToPolymorphicAssociation.class);
        if (ass != null) {
            fkValue = this.getString(ass.getFkName());
            fkName = ass.getFkName();
        } else if (assP != null) {
            fkValue = this.getString("parent_id");
            fkName = "parent_id";
            if (!assP.getTypeLabel().equals(this.getString("parent_type"))) {
                throw new IllegalArgumentException("Wrong parent: '" + parentClass + "'. Actual parent type label of this record is: '" + this.getString("parent_type") + "'");
            }
        } else {
            throw new IllegalArgumentException("there is no association with table: " + parentTable);
        }
        if (fkValue == null) {
            logger.debug("Attribute:  " + fkName + " is null, cannot determine parent. Child record: " + this);
            return null;
        }
        String parentIdName = parentMM.getIdName();
        String query = this.getMetaModelLocal().getDialect().selectStarParametrized(parentTable, parentIdName);
        if (parentMM.cached() && (parent = (Model)QueryCache.instance().getItem(parentTable, query, new Object[]{fkValue})) != null) {
            return (T)parent;
        }
        List<Map> results = new DB(this.getMetaModelLocal().getDbName()).findAll(query, Integer.parseInt(fkValue));
        if (results.size() == 0) {
            return null;
        }
        try {
            parent = (Model)parentClass.newInstance();
            parent.hydrate(results.get(0));
            if (parentMM.cached()) {
                QueryCache.instance().addItem(parentTable, query, new Object[]{fkValue}, parent);
            }
            return (T)parent;
        }
        catch (Exception e) {
            throw new InitException(e.getMessage(), e);
        }
    }

    protected void setCachedParent(Model parent) {
        if (parent != null) {
            this.cachedParents.put(parent.getClass(), parent);
        }
    }

    public void setParents(Model ... parents) {
        for (Model parent : parents) {
            this.setParent(parent);
        }
    }

    public void setParent(Model parent) {
        if (parent == null || parent.getId() == null) {
            throw new IllegalArgumentException("parent cannot ne null and parent ID cannot be null");
        }
        List<Association> associations = this.getMetaModelLocal().getAssociations();
        for (Association association : associations) {
            if (association instanceof BelongsToAssociation && association.getTarget().equals(parent.getMetaModelLocal().getTableName())) {
                this.set(((BelongsToAssociation)association).getFkName(), parent.getId());
                return;
            }
            if (!(association instanceof BelongsToPolymorphicAssociation) || !association.getTarget().equals(parent.getMetaModelLocal().getTableName())) continue;
            this.set("parent_id", parent.getId());
            this.set("parent_type", (Object)((BelongsToPolymorphicAssociation)association).getTypeLabel());
            return;
        }
        throw new IllegalArgumentException("Class: " + parent.getClass() + " is not associated with " + this.getClass() + ", list of existing associations: \n" + Util.join(this.getMetaModelLocal().getAssociations(), "\n"));
    }

    public <T extends Model> void copyTo(T other) {
        if (!this.getMetaModelLocal().getTableName().equals(other.getMetaModelLocal().getTableName())) {
            throw new IllegalArgumentException("can only copy between the same types");
        }
        List<String> attrs = this.getMetaModelLocal().getAttributeNamesSkip(this.getMetaModelLocal().getIdName());
        for (String name : attrs) {
            other.getAttributes().put(name, this.get(name));
        }
    }

    public void copyFrom(Model other) {
        other.copyTo(this);
    }

    protected MetaModel getMetaModelLocal() {
        if (this.metaModelLocal == null) {
            this.metaModelLocal = Model.getMetaModel();
        }
        return this.metaModelLocal;
    }

    protected void setMetamodelLocal(MetaModel metamodelLocal) {
        this.metaModelLocal = metamodelLocal;
    }

    public void refresh() {
        Model fresh = Model.findById(this.getId());
        if (fresh == null) {
            throw new StaleModelException("Failed to refresh self because probably record with this ID does not exist anymore. Stale model: " + this);
        }
        fresh.copyTo((Model)this);
    }

    public Object get(String attribute) {
        boolean getInference;
        if (this.frozen) {
            throw new FrozenException(this);
        }
        if (attribute == null) {
            throw new IllegalArgumentException("attribute cannot be null");
        }
        if (attribute.equalsIgnoreCase("id")) {
            String idName = this.getMetaModelLocal().getIdName();
            return this.attributes.get(idName.toLowerCase());
        }
        String attributeName = attribute.toLowerCase();
        String getInferenceProperty = System.getProperty("activejdbc.get.inference");
        boolean bl = getInference = getInferenceProperty == null || getInferenceProperty.equals("true");
        if (getInference) {
            if (this.attributes.containsKey(attributeName)) {
                return this.attributes.get(attributeName);
            }
            Object returnValue = this.tryParent(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryPolymorphicParent(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryChildren(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryPolymorphicChildren(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            returnValue = this.tryOther(attributeName);
            if (returnValue != null) {
                return returnValue;
            }
            this.getMetaModelLocal().checkAttributeOrAssociation(attributeName);
            return null;
        }
        return this.attributes.get(attributeName);
    }

    private Object tryPolymorphicParent(String parentTable) {
        MetaModel parentMM = this.inferTargetMetaModel(parentTable);
        if (parentMM == null) {
            return null;
        }
        return this.getMetaModelLocal().hasAssociation(parentMM.getTableName(), BelongsToPolymorphicAssociation.class) ? this.parent(parentMM.getModelClass()) : null;
    }

    private Object tryParent(String parentTable) {
        MetaModel parentMM = this.inferTargetMetaModel(parentTable);
        if (parentMM == null) {
            return null;
        }
        return this.getMetaModelLocal().hasAssociation(parentMM.getTableName(), BelongsToAssociation.class) ? this.parent(parentMM.getModelClass()) : null;
    }

    private Object tryPolymorphicChildren(String childTable) {
        MetaModel childMM = this.inferTargetMetaModel(childTable);
        if (childMM == null) {
            return null;
        }
        return this.getMetaModelLocal().hasAssociation(childMM.getTableName(), OneToManyPolymorphicAssociation.class) ? this.getAll(childMM.getModelClass()) : null;
    }

    private Object tryChildren(String childTable) {
        MetaModel childMM = this.inferTargetMetaModel(childTable);
        if (childMM == null) {
            return null;
        }
        return this.getMetaModelLocal().hasAssociation(childMM.getTableName(), OneToManyAssociation.class) ? this.getAll(childMM.getModelClass()) : null;
    }

    private Object tryOther(String otherTable) {
        MetaModel otherMM = this.inferTargetMetaModel(otherTable);
        if (otherMM == null) {
            return null;
        }
        return this.getMetaModelLocal().hasAssociation(otherMM.getTableName(), Many2ManyAssociation.class) ? this.getAll(otherMM.getModelClass()) : null;
    }

    private MetaModel inferTargetMetaModel(String targetTableName) {
        String targetTable = Inflector.singularize(targetTableName);
        MetaModel targetMM = Registry.instance().getMetaModel(targetTable);
        if (targetMM == null) {
            targetTable = Inflector.pluralize(targetTableName);
            targetMM = Registry.instance().getMetaModel(targetTable);
        }
        return targetMM != null ? targetMM : null;
    }

    public String getString(String attribute) {
        Object value = this.get(attribute);
        return Convert.toString(value);
    }

    public byte[] getBytes(String attribute) {
        Object value = this.get(attribute);
        return Convert.toBytes(value);
    }

    public BigDecimal getBigDecimal(String attribute) {
        return Convert.toBigDecimal(this.get(attribute));
    }

    public Integer getInteger(String attribute) {
        return Convert.toInteger(this.get(attribute));
    }

    public Long getLong(String attribute) {
        return Convert.toLong(this.get(attribute));
    }

    public Float getFloat(String attribute) {
        return Convert.toFloat(this.get(attribute));
    }

    public Timestamp getTimestamp(String attribute) {
        return Convert.toTimestamp(this.get(attribute));
    }

    public Double getDouble(String attribute) {
        return Convert.toDouble(this.get(attribute));
    }

    public Boolean getBoolean(String attribute) {
        return Convert.toBoolean(this.get(attribute));
    }

    public Model setString(String attribute, Object value) {
        return this.set(attribute, (Object)value.toString());
    }

    public Model setBigDecimal(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toBigDecimal(value));
    }

    public Model setInteger(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toInteger(value));
    }

    public Model setLong(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toLong(value));
    }

    public Model setFloat(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toFloat(value));
    }

    public Model setTimestamp(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toTimestamp(value));
    }

    public Model setDouble(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toDouble(value));
    }

    public Model setBoolean(String attribute, Object value) {
        return this.set(attribute, (Object)Convert.toBoolean(value));
    }

    public <T extends Model> LazyList<T> getAll(Class<T> clazz) {
        List<Model> children = this.cachedChildren.get(clazz);
        if (children != null) {
            return (LazyList)children;
        }
        String tableName = Registry.instance().getTableName(clazz);
        if (tableName == null) {
            throw new IllegalArgumentException("table: " + tableName + " does not exist for model: " + clazz);
        }
        return this.get(tableName, null, new Object[0]);
    }

    public <T extends Model> LazyList<T> get(Class<T> clazz, String query, Object ... params) {
        return this.get(Registry.instance().getTableName(clazz), query, params);
    }

    private <T extends Model> LazyList<T> get(String targetTable, String criteria, Object ... params) {
        String subQuery;
        String additionalCriteria;
        OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)this.getMetaModelLocal().getAssociationForTarget(targetTable, OneToManyAssociation.class);
        Many2ManyAssociation manyToManyAssociation = (Many2ManyAssociation)this.getMetaModelLocal().getAssociationForTarget(targetTable, Many2ManyAssociation.class);
        OneToManyPolymorphicAssociation oneToManyPolymorphicAssociation = (OneToManyPolymorphicAssociation)this.getMetaModelLocal().getAssociationForTarget(targetTable, OneToManyPolymorphicAssociation.class);
        String string = additionalCriteria = criteria != null ? " AND ( " + criteria + " ) " : "";
        if (oneToManyAssociation != null) {
            subQuery = oneToManyAssociation.getFkName() + " = " + this.getId() + additionalCriteria;
        } else {
            if (manyToManyAssociation != null) {
                String targetId = Registry.instance().getMetaModel(targetTable).getIdName();
                String joinTable = manyToManyAssociation.getJoin();
                String query = "SELECT " + targetTable + ".* FROM " + targetTable + ", " + joinTable + " WHERE " + targetTable + "." + targetId + " = " + joinTable + "." + manyToManyAssociation.getTargetFkName() + " AND " + joinTable + "." + manyToManyAssociation.getSourceFkName() + " = " + this.getId() + additionalCriteria;
                return new LazyList(true, Registry.instance().getMetaModel(targetTable), query, params);
            }
            if (oneToManyPolymorphicAssociation != null) {
                subQuery = "parent_id = " + this.getId() + " AND " + " parent_type = '" + oneToManyPolymorphicAssociation.getTypeLabel() + "'" + additionalCriteria;
            } else {
                throw new NotAssociatedException(this.getMetaModelLocal().getTableName(), targetTable);
            }
        }
        return new LazyList(subQuery, params, Registry.instance().getMetaModel(targetTable));
    }

    protected static NumericValidationBuilder validateNumericalityOf(String ... attributes) {
        return ValidationHelper.addNumericalityValidators(Model.getClassName(), ModelDelegate.toLowerCase(attributes));
    }

    public static ValidationBuilder addValidator(Validator validator) {
        return ValidationHelper.addValidator(Model.getClassName(), validator);
    }

    public void addError(String key, String value) {
        this.errors.put(key, value);
    }

    public static void removeValidator(Validator validator) {
        Registry.instance().removeValidator(Model.<Model>getDaClass(), validator);
    }

    public static List<Validator> getValidators(Class<Model> daClass) {
        return Registry.instance().getValidators(daClass.getName());
    }

    protected static ValidationBuilder validateRegexpOf(String attribute, String pattern) {
        return ValidationHelper.addRegexpValidator(Model.getClassName(), attribute.toLowerCase(), pattern);
    }

    protected static ValidationBuilder validateEmailOf(String attribute) {
        return ValidationHelper.addEmailValidator(Model.getClassName(), attribute.toLowerCase());
    }

    protected static ValidationBuilder validateRange(String attribute, Number min, Number max) {
        return ValidationHelper.addRangevalidator(Model.getClassName(), attribute.toLowerCase(), min, max);
    }

    protected static ValidationBuilder validatePresenceOf(String ... attributes) {
        return ValidationHelper.addPresensevalidators(Model.getClassName(), ModelDelegate.toLowerCase(attributes));
    }

    protected static ValidationBuilder validateWith(Validator validator) {
        return Model.addValidator(validator);
    }

    protected static ValidationBuilder convertDate(String attributeName, String format) {
        return ValidationHelper.addDateConverter(Model.getClassName(), attributeName, format);
    }

    protected static ValidationBuilder convertTimestamp(String attributeName, String format) {
        return ValidationHelper.addTimestampConverter(Model.getClassName(), attributeName, format);
    }

    public static boolean belongsTo(Class<? extends Model> targetClass) {
        String targetTable = Registry.instance().getTableName(targetClass);
        MetaModel metaModel = Model.getMetaModel();
        return null != metaModel.getAssociationForTarget(targetTable, BelongsToAssociation.class) || null != metaModel.getAssociationForTarget(targetTable, Many2ManyAssociation.class);
    }

    public static void addCallbacks(CallbackListener ... listeners) {
        for (CallbackListener listener : listeners) {
            Registry.instance().addListener(Model.getDaClass(), listener);
        }
    }

    public boolean isValid() {
        this.validate();
        return !this.hasErrors();
    }

    public void validate() {
        this.fireBeforeValidation(this);
        this.errors = new Errors();
        List<Validator> theValidators = Registry.instance().getValidators(this.getClass().getName());
        if (theValidators != null) {
            for (Validator validator : theValidators) {
                validator.validate(this);
            }
        }
        this.fireAfterValidation(this);
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public void addValidator(Validator validator, String errorKey) {
        if (!this.errors.containsKey(errorKey)) {
            this.errors.addValidator(errorKey, validator);
        }
    }

    public Errors errors() {
        return this.errors;
    }

    public Errors errors(Locale locale) {
        this.errors.setLocale(locale);
        return this.errors;
    }

    public static <T extends Model> T create(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number of arguments must be even");
        }
        try {
            Model m = (Model)Model.getDaClass().newInstance();
            ModelDelegate.setNamesAndValues(m, namesAndValues);
            return (T)m;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("All even arguments must be strings");
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitException("Model '" + Model.getClassName() + "' must provide a default constructor. Table:", e);
        }
    }

    public Model set(Object ... namesAndValues) {
        ModelDelegate.setNamesAndValues(this, namesAndValues);
        return this;
    }

    public static <T extends Model> T createIt(Object ... namesAndValues) {
        T m = Model.create(namesAndValues);
        ((Model)m).saveIt();
        return m;
    }

    public static <T extends Model> T findById(Object id) {
        if (id == null) {
            return null;
        }
        MetaModel mm = Model.getMetaModel();
        LazyList l = new LazyList(mm.getIdName() + " = ?", new Object[]{id}, mm).limit(1L);
        return (T)(l.size() > 0 ? l.get(0) : null);
    }

    public static <T extends Model> LazyList<T> where(String subquery, Object ... params) {
        return Model.find(subquery, params);
    }

    public static <T extends Model> LazyList<T> find(String subquery, Object ... params) {
        if (subquery.trim().equals("*") && params.length == 0) {
            return Model.findAll();
        }
        if (subquery.equals("*") && params.length != 0) {
            throw new IllegalArgumentException("cannot provide parameters with query: '*', use findAll() method instead");
        }
        return new LazyList(subquery, params, Model.getMetaModel());
    }

    public static <T extends Model> T findFirst(String subQuery, Object ... params) {
        LazyList results = new LazyList(subQuery, params, Model.getMetaModel()).limit(1L);
        return (T)(results.size() > 0 ? results.get(0) : null);
    }

    public static <T extends Model> T first(String subQuery, Object ... params) {
        return Model.findFirst(subQuery, params);
    }

    public static void find(String query, ModelListener listener) {
        Model.findWith(listener, query, new Object[0]);
    }

    public static void findWith(final ModelListener listener, String query, Object ... params) {
        long start = System.currentTimeMillis();
        final MetaModel metaModel = Model.getMetaModel();
        String sql = metaModel.getDialect().selectStar(metaModel.getTableName(), query);
        new DB(metaModel.getDbName()).find(sql, params).with(new RowListenerAdapter(){

            @Override
            public void onNext(Map<String, Object> row) {
                listener.onModel(Model.instance(row, metaModel));
            }
        });
        LogFilter.logQuery(logger, sql, null, start);
    }

    public static <T extends Model> LazyList<T> findBySQL(String fullQuery, Object ... params) {
        return new LazyList(false, Model.getMetaModel(), fullQuery, params);
    }

    public static <T extends Model> LazyList<T> findAll() {
        return new LazyList(null, new Object[0], Model.getMetaModel());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Model child) {
        String childTable = Registry.instance().getTableName(child.getClass());
        MetaModel metaModel = this.getMetaModelLocal();
        if (this.getId() == null) throw new IllegalArgumentException("You can only add associated model to an instance that exists in DB. Save this instance first, then you will be able to add dependencies to it.");
        if (metaModel.hasAssociation(childTable, OneToManyAssociation.class)) {
            OneToManyAssociation ass = (OneToManyAssociation)metaModel.getAssociationForTarget(childTable, OneToManyAssociation.class);
            String fkName = ass.getFkName();
            child.set(fkName, this.getId());
            child.saveIt();
            return;
        } else if (metaModel.hasAssociation(childTable, Many2ManyAssociation.class)) {
            MetaModel joinMM;
            Many2ManyAssociation ass = (Many2ManyAssociation)metaModel.getAssociationForTarget(childTable, Many2ManyAssociation.class);
            String join = ass.getJoin();
            String sourceFkName = ass.getSourceFkName();
            String targetFkName = ass.getTargetFkName();
            if (child.getId() == null) {
                child.saveIt();
            }
            if ((joinMM = Registry.instance().getMetaModel(join)) == null) {
                new DB(metaModel.getDbName()).exec("INSERT INTO " + join + " ( " + sourceFkName + ", " + targetFkName + " ) VALUES ( " + this.getId() + ", " + child.getId() + ")");
                return;
            } else {
                try {
                    Model joinModel = (Model)joinMM.getModelClass().newInstance();
                    joinModel.set(sourceFkName, this.getId());
                    joinModel.set(targetFkName, child.getId());
                    joinModel.saveIt();
                    return;
                }
                catch (InstantiationException e) {
                    throw new InitException("failed to create a new instance of class: " + joinMM.getClass() + ", are you sure this class has a default constructor?", e);
                }
                catch (IllegalAccessException e) {
                    throw new InitException(e);
                }
                finally {
                    QueryCache.instance().purgeTableCache(join);
                    QueryCache.instance().purgeTableCache(metaModel.getTableName());
                    QueryCache.instance().purgeTableCache(childTable);
                }
            }
        } else {
            if (!metaModel.hasAssociation(childTable, OneToManyPolymorphicAssociation.class)) throw new NotAssociatedException(metaModel.getTableName(), childTable);
            OneToManyPolymorphicAssociation ass = (OneToManyPolymorphicAssociation)metaModel.getAssociationForTarget(childTable, OneToManyPolymorphicAssociation.class);
            child.set("parent_id", this.getId());
            child.set("parent_type", (Object)ass.getTypeLabel());
            child.saveIt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(Model child) {
        if (child == null) {
            throw new IllegalArgumentException("cannot remove what is null");
        }
        if (child.frozen() || child.getId() == null) {
            throw new IllegalArgumentException("Cannot remove a child that does not exist in DB (either frozen, or ID not set)");
        }
        String childTable = Registry.instance().getTableName(child.getClass());
        MetaModel metaModel = this.getMetaModelLocal();
        if (this.getId() == null) throw new IllegalArgumentException("You can only add associated model to an instance that exists in DB. Save this instance first, then you will be able to add dependencies to it.");
        if (metaModel.hasAssociation(childTable, OneToManyAssociation.class) || metaModel.hasAssociation(childTable, OneToManyPolymorphicAssociation.class)) {
            child.delete();
            return;
        } else {
            if (!metaModel.hasAssociation(childTable, Many2ManyAssociation.class)) throw new NotAssociatedException(metaModel.getTableName(), childTable);
            Many2ManyAssociation ass = (Many2ManyAssociation)metaModel.getAssociationForTarget(childTable, Many2ManyAssociation.class);
            String join = ass.getJoin();
            String sourceFkName = ass.getSourceFkName();
            String targetFkName = ass.getTargetFkName();
            new DB(metaModel.getDbName()).exec("DELETE FROM " + join + " WHERE " + sourceFkName + " = ? AND " + targetFkName + " = ?", this.getId(), child.getId());
        }
    }

    public boolean saveIt() {
        boolean result = this.save();
        Model.purgeEdges();
        if (this.errors.size() > 0) {
            throw new ValidationException(this);
        }
        return result;
    }

    public void reset() {
        this.attributes = new HashMap<String, Object>();
    }

    public void thaw() {
        this.attributes.put(this.getMetaModelLocal().getIdName(), "");
        this.frozen = false;
    }

    public void defrost() {
        this.thaw();
    }

    public boolean save() {
        if (this.frozen) {
            throw new FrozenException(this);
        }
        this.fireBeforeSave(this);
        this.validate();
        if (this.hasErrors()) {
            return false;
        }
        boolean result = Util.blank(this.getId()) ? this.doInsert() : this.update();
        this.fireAfterSave(this);
        return result;
    }

    public static Long count() {
        Long result;
        MetaModel metaModel = Model.getMetaModel();
        String sql = "SELECT COUNT(*) FROM " + metaModel.getTableName();
        if (metaModel.cached()) {
            result = (Long)QueryCache.instance().getItem(metaModel.getTableName(), sql, null);
            if (result == null) {
                result = new DB(metaModel.getDbName()).count(metaModel.getTableName());
                QueryCache.instance().addItem(metaModel.getTableName(), sql, null, result);
            }
        } else {
            result = new DB(metaModel.getDbName()).count(metaModel.getTableName());
        }
        return result;
    }

    public static Long count(String query, Object ... params) {
        Long result;
        MetaModel metaModel = Model.getMetaModel();
        String sql = "SELECT COUNT(*) FROM " + metaModel.getTableName() + " where " + query;
        if (metaModel.cached()) {
            result = (Long)QueryCache.instance().getItem(metaModel.getTableName(), sql, params);
            if (result == null) {
                result = new DB(metaModel.getDbName()).count(metaModel.getTableName(), query, params);
                QueryCache.instance().addItem(metaModel.getTableName(), sql, params, result);
            }
        } else {
            result = new DB(metaModel.getDbName()).count(metaModel.getTableName(), query, params);
        }
        return result;
    }

    private List<String> getValueAttributeNames(boolean includeId) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (String name : this.attributes.keySet()) {
            if (includeId) {
                if (name.equalsIgnoreCase("record_version")) continue;
                attributeNames.add(name);
                continue;
            }
            if (name.equalsIgnoreCase("record_version") || name.equalsIgnoreCase(this.getMetaModelLocal().getIdName())) continue;
            attributeNames.add(name);
        }
        return attributeNames;
    }

    private boolean doInsert() {
        this.fireBeforeCreate(this);
        this.doCreatedAt();
        this.doUpdatedAt();
        List<String> valueAttributes = this.getValueAttributeNames(false);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String attribute : valueAttributes) {
            values.add(this.attributes.get(attribute));
        }
        String query = this.getMetaModelLocal().getDialect().createParametrizedInsert(this.getMetaModelLocal(), valueAttributes);
        try {
            long id = new DB(this.getMetaModelLocal().getDbName()).execInsert(query, this.getMetaModelLocal().getIdName(), values.toArray());
            if (this.getMetaModelLocal().cached()) {
                QueryCache.instance().purgeTableCache(this.getMetaModelLocal().getTableName());
            }
            this.attributes.put(this.getMetaModelLocal().getIdName(), id);
            this.fireAfterCreate(this);
            if (this.getMetaModelLocal().isVersioned()) {
                this.set("record_version", (Object)1);
            }
            return true;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    public boolean insert() {
        this.fireBeforeCreate(this);
        this.doCreatedAt();
        this.doUpdatedAt();
        List<String> valueAttributes = this.getValueAttributeNames(true);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String attribute : valueAttributes) {
            values.add(this.attributes.get(attribute));
        }
        String query = this.getMetaModelLocal().getDialect().createParametrizedInsertIdUnmanaged(this.getMetaModelLocal(), valueAttributes);
        try {
            long recordsUpdated = new DB(this.getMetaModelLocal().getDbName()).exec(query, values.toArray());
            if (this.getMetaModelLocal().cached()) {
                QueryCache.instance().purgeTableCache(this.getMetaModelLocal().getTableName());
            }
            this.fireAfterCreate(this);
            if (this.getMetaModelLocal().isVersioned()) {
                this.set("record_version", (Object)1);
            }
            return recordsUpdated == 1L;
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    private void doCreatedAt() {
        if (this.getMetaModelLocal().hasAttribute("created_at")) {
            this.attributes.remove("created_at");
            this.attributes.remove("CREATED_AT");
            this.attributes.put("created_at", new Timestamp(System.currentTimeMillis()));
        }
    }

    private void doUpdatedAt() {
        if (this.getMetaModelLocal().hasAttribute("updated_at")) {
            this.attributes.remove("updated_at");
            this.attributes.remove("UPDATED_AT");
            this.set("updated_at", (Object)new Timestamp(System.currentTimeMillis()));
        }
    }

    private boolean update() {
        this.doUpdatedAt();
        MetaModel metaModel = this.getMetaModelLocal();
        String query = "UPDATE " + metaModel.getTableName() + " SET ";
        List<String> names = metaModel.getAttributeNamesSkipGenerated();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            query = query + name + "= ?";
            if (i >= names.size() - 1) continue;
            query = query + ", ";
        }
        List values = this.getAttributeValuesSkipGenerated();
        if (metaModel.hasAttribute("updated_at")) {
            query = query + ", updated_at = ? ";
            values.add(this.get("updated_at"));
        }
        if (metaModel.isVersioned()) {
            query = query + ", record_version = ? ";
            values.add(this.getLong("record_version") + 1L);
        }
        query = query + " where " + metaModel.getIdName() + " = ?";
        query = query + (metaModel.isVersioned() ? " and record_version = ?" : "");
        values.add(this.getId());
        if (metaModel.isVersioned()) {
            values.add(this.get("record_version"));
        }
        int updated = new DB(metaModel.getDbName()).exec(query, values.toArray());
        if (metaModel.isVersioned() && updated == 0) {
            throw new StaleModelException("Failed to update record for model '" + this.getClass() + "', with " + this.getIdName() + " = " + this.getId() + " and record_version = " + this.get("record_version") + ". Either this record does not exist anymore, or has been updated to have another record_version.");
        }
        if (metaModel.isVersioned()) {
            this.set("record_version", (Object)(this.getLong("record_version") + 1L));
        }
        if (metaModel.cached()) {
            QueryCache.instance().purgeTableCache(metaModel.getTableName());
        }
        return updated > 0;
    }

    private List getAttributeValuesSkipGenerated() {
        List<String> names = this.getMetaModelLocal().getAttributeNamesSkipGenerated();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String name : names) {
            values.add(this.get(name));
        }
        return values;
    }

    static <T extends Model> T instance(Map m, MetaModel metaModel) {
        try {
            Model instance = (Model)metaModel.getModelClass().newInstance();
            instance.setMetamodelLocal(metaModel);
            instance.hydrate(m);
            return (T)instance;
        }
        catch (InstantiationException e) {
            throw new InitException("Failed to create a new instance of: " + metaModel.getModelClass() + ", are you sure this class has a default constructor?");
        }
        catch (DBException e) {
            throw e;
        }
        catch (InitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static <T extends Model> Class<T> getDaClass() {
        try {
            if (Registry.instance().initialized()) {
                MetaModel mm = Registry.instance().getMetaModelByClassName(Model.getClassName());
                return mm == null ? Class.forName(Model.getClassName()) : mm.getModelClass();
            }
            return Class.forName(Model.getClassName());
        }
        catch (Exception e) {
            throw new DBException(e.getMessage(), e);
        }
    }

    private static String getClassName() {
        return new ClassGetter().getClassName();
    }

    public static String getTableName() {
        return Registry.instance().getTableName(Model.getDaClass());
    }

    public Object getId() {
        return this.get(this.getMetaModelLocal().getIdName());
    }

    public String getIdName() {
        return this.getMetaModelLocal().getIdName();
    }

    protected void setChildren(Class childClass, List<Model> children) {
        this.cachedChildren.put(childClass, children);
    }

    public String toInsert() {
        return this.toInsert("'", "'");
    }

    public String toInsert(String leftStringQuote, String rightStringQuote) {
        return this.toInsert(new SimpleFormatter(Date.class, "'", "'"), new SimpleFormatter(Timestamp.class, "'", "'"), new SimpleFormatter(String.class, leftStringQuote, rightStringQuote));
    }

    public String toInsert(Formatter ... formatters) {
        HashMap<Class, Formatter> formatterMap = new HashMap<Class, Formatter>();
        for (Formatter f : formatters) {
            formatterMap.put(f.getValueClass(), f);
        }
        ArrayList<String> names = new ArrayList<String>(this.attributes.keySet());
        Collections.sort(names);
        ArrayList<Object> values = new ArrayList<Object>();
        for (String name : names) {
            Object value = this.get(name);
            if (value == null) {
                values.add("NULL");
                continue;
            }
            if (value instanceof String && !formatterMap.containsKey(String.class)) {
                values.add("'" + value + "'");
                continue;
            }
            if (formatterMap.containsKey(value.getClass())) {
                values.add(((Formatter)formatterMap.get(value.getClass())).format(value));
                continue;
            }
            values.add(value);
        }
        return new StringBuffer("INSERT INTO ").append(this.getMetaModelLocal().getTableName()).append(" (").append(Util.join(names, ", ")).append(") VALUES (").append(Util.join(values, ", ")).append(")").toString();
    }

    public static void purgeCache() {
        MetaModel mm = Model.getMetaModel();
        if (mm.cached()) {
            QueryCache.instance().purgeTableCache(mm.getTableName());
        }
    }

    public Long getLongId() {
        Object id = this.get(this.getIdName());
        if (id == null) {
            throw new NullPointerException(this.getIdName() + " is null, cannot convert to Long");
        }
        return Convert.toLong(id);
    }

    private static void purgeEdges() {
        ModelDelegate.purgeEdges(Model.getMetaModel());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.attributes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.attributes = (Map)in.readObject();
    }

    static class ClassGetter
    extends SecurityManager {
        ClassGetter() {
        }

        public String getClassName() {
            Class<?>[] classes;
            for (Class<?> clazz : classes = this.getClassContext()) {
                if (!Model.class.isAssignableFrom(clazz) || clazz == null || clazz.equals(Model.class)) continue;
                return clazz.getName();
            }
            throw new InitException("failed to determine Model class name, are you sure models have been instrumented?");
        }
    }
}

