/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.statistics.QueryExecutionEvent;
import org.javalite.common.Util;
import org.slf4j.Logger;

public class LogFilter {
    private static Pattern pattern;

    public static void setLogExpression(String regexp) {
        pattern = Pattern.compile(regexp, 2);
    }

    static void logQuery(Logger logger, String query, Object[] params, long queryStartTime) {
        long time = System.currentTimeMillis() - queryStartTime;
        if (Registry.instance().getConfiguration().collectStatistics()) {
            Registry.instance().getStatisticsQueue().enqueue(new QueryExecutionEvent(query, time));
        }
        StringBuilder log = new StringBuilder("Query: \"").append(query).append("\"");
        if (params != null && params.length != 0) {
            log.append(", with parameters: ").append("<").append(Util.join(Arrays.asList(params), ">, <")).append(">");
        }
        LogFilter.log(logger, log.append(", took: ").append(time).append(" milliseconds").toString());
    }

    public static void log(Logger logger, String log) {
        if (pattern.matcher(log).matches()) {
            logger.info(log);
        }
    }

    static {
        String logFlag = System.getProperty("activejdbc.log");
        if (logFlag != null && logFlag.equals("")) {
            LogFilter.setLogExpression(".*");
        } else if (logFlag != null) {
            LogFilter.setLogExpression(logFlag);
        } else {
            LogFilter.setLogExpression("a{10000000}");
        }
    }
}

