/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BalanceStrategy;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionGroup;
import com.mysql.jdbc.ConnectionGroupManager;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.LoadBalanceExceptionChecker;
import com.mysql.jdbc.LoadBalancedMySQLConnection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private long totalPhysicalConnections = 0L;
    private long activePhysicalConnections = 0L;
    private String hostToRemove = null;
    private long lastUsed = 0L;
    private long transactionCount = 0L;
    private ConnectionGroup connectionGroup = null;
    protected String closedReason = null;
    protected boolean closedExplicitly = false;
    protected boolean autoReconnect = false;
    public static final String BLACKLIST_TIMEOUT_PROPERTY_KEY = "loadBalanceBlacklistTimeout";
    protected MySQLConnection currentConn;
    protected List<String> hostList;
    protected Map<String, ConnectionImpl> liveConnections;
    private Map<ConnectionImpl, String> connectionsToHostsMap;
    private long[] responseTimes;
    private Map<String, Integer> hostsToListIndexMap;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private Properties localProps;
    protected boolean isClosed = false;
    private BalanceStrategy balancer;
    private int retriesAllDown;
    private static Map<String, Long> globalBlacklist;
    private int globalBlacklistTimeout = 0;
    private long connectionGroupProxyID = 0L;
    private LoadBalanceExceptionChecker exceptionChecker;
    private Map<Class<?>, Boolean> jdbcInterfacesForProxyCache = new HashMap();
    private MySQLConnection thisAsConnection = null;
    private int autoCommitSwapThreshold = 0;
    private static Constructor<?> JDBC_4_LB_CONNECTION_CTOR;
    private Map<Class<?>, Class<?>[]> allInterfacesToProxy = new HashMap();

    LoadBalancingConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        String group = props.getProperty("loadBalanceConnectionGroup", null);
        boolean enableJMX = false;
        String enableJMXAsString = props.getProperty("loadBalanceEnableJMX", "false");
        try {
            enableJMX = Boolean.parseBoolean(enableJMXAsString);
        }
        catch (Exception e) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
        }
        if (group != null) {
            this.connectionGroup = ConnectionGroupManager.getConnectionGroupInstance(group);
            if (enableJMX) {
                ConnectionGroupManager.registerJmx();
            }
            this.connectionGroupProxyID = this.connectionGroup.registerConnectionProxy(this, hosts);
            hosts = new ArrayList<String>(this.connectionGroup.getInitialHosts());
        }
        this.autoReconnect = "true".equalsIgnoreCase(props.getProperty("autoReconnect")) || "true".equalsIgnoreCase(props.getProperty("autoReconnectForPools"));
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap<String, ConnectionImpl>(numHosts);
        this.connectionsToHostsMap = new HashMap<ConnectionImpl, String>(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap<String, Integer>(numHosts);
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put(this.hostList.get(i), i);
            this.localProps.remove("HOST." + (i + 1));
            this.localProps.remove("PORT." + (i + 1));
        }
        this.localProps.remove("NUM_HOSTS");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        String lbExceptionChecker = this.localProps.getProperty("loadBalanceExceptionChecker", "com.mysql.jdbc.StandardLoadBalanceExceptionChecker");
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty(BLACKLIST_TIMEOUT_PROPERTY_KEY, "0");
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.RandomBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.BestResponseTimeBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null).get(0));
        String autoCommitSwapThresholdAsString = props.getProperty("loadBalanceAutoCommitStatementThreshold", "0");
        try {
            this.autoCommitSwapThreshold = Integer.parseInt(autoCommitSwapThresholdAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceAutoCommitStatementThreshold", new Object[]{autoCommitSwapThresholdAsString}), "S1009", null);
        }
        String autoCommitSwapRegex = props.getProperty("loadBalanceAutoCommitStatementRegex", "");
        if (!"".equals(autoCommitSwapRegex)) {
            try {
                "".matches(autoCommitSwapRegex);
            }
            catch (Exception e) {
                throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceAutoCommitStatementRegex", new Object[]{autoCommitSwapRegex}), "S1009", null);
            }
        }
        if (this.autoCommitSwapThreshold > 0) {
            String statementInterceptors = this.localProps.getProperty("statementInterceptors");
            if (statementInterceptors == null) {
                this.localProps.setProperty("statementInterceptors", "com.mysql.jdbc.LoadBalancedAutoCommitInterceptor");
            } else if (statementInterceptors.length() > 0) {
                this.localProps.setProperty("statementInterceptors", statementInterceptors + ",com.mysql.jdbc.LoadBalancedAutoCommitInterceptor");
            }
            props.setProperty("statementInterceptors", this.localProps.getProperty("statementInterceptors"));
        }
        this.balancer.init(null, props);
        this.exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, lbExceptionChecker, "InvalidLoadBalanceExceptionChecker", null).get(0);
        this.thisAsConnection = Util.isJdbc4() || JDBC_4_LB_CONNECTION_CTOR != null ? (MySQLConnection)Util.handleNewInstance(JDBC_4_LB_CONNECTION_CTOR, new Object[]{this}, null) : new LoadBalancedMySQLConnection(this);
        this.pickNewConnection();
    }

    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        String hostName = hostPortPair[0];
        String portNumber = hostPortPair[1];
        String dbName = connProps.getProperty("DBNAME");
        if (hostName == null) {
            throw new SQLException("Could not find a hostname to start a connection to");
        }
        if (portNumber == null) {
            portNumber = "3306";
        }
        connProps.setProperty("HOST", hostName);
        connProps.setProperty("PORT", portNumber);
        connProps.setProperty("HOST.1", hostName);
        connProps.setProperty("PORT.1", portNumber);
        connProps.setProperty("NUM_HOSTS", "1");
        connProps.setProperty("roundRobinLoadBalance", "false");
        ConnectionImpl conn = (ConnectionImpl)ConnectionImpl.getInstance(hostName, Integer.parseInt(portNumber), connProps, dbName, "jdbc:mysql://" + hostName + ":" + portNumber + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        ++this.activePhysicalConnections;
        ++this.totalPhysicalConnections;
        conn.setProxy(this.thisAsConnection);
        conn.setRealProxy(this);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            if (t instanceof SQLException && this.shouldExceptionTriggerFailover((SQLException)t)) {
                this.invalidateCurrentConnection();
                this.pickNewConnection();
            }
            throw t;
        }
        throw e;
    }

    synchronized void invalidateCurrentConnection() throws SQLException {
        this.invalidateConnection(this.currentConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void invalidateConnection(MySQLConnection conn) throws SQLException {
        try {
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                Object var4_3 = null;
                if (this.isGlobalBlacklistEnabled()) {
                    this.addToGlobalBlacklist(this.connectionsToHostsMap.get(conn));
                }
                this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                String mappedHost = this.connectionsToHostsMap.remove(conn);
                if (mappedHost == null) return;
                if (!this.hostsToListIndexMap.containsKey(mappedHost)) return;
                int hostIndex = this.hostsToListIndexMap.get(mappedHost);
                long[] lArray2 = this.responseTimes;
                synchronized (this.responseTimes) {
                    this.responseTimes[hostIndex] = 0L;
                    // ** MonitorExit[lArray2] (shouldn't be in output)
                    return;
                }
            }
            Object var4_2 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist(this.connectionsToHostsMap.get(conn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist(this.connectionsToHostsMap.get(conn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
            String mappedHost = this.connectionsToHostsMap.remove(conn);
            if (mappedHost == null) throw throwable;
            if (!this.hostsToListIndexMap.containsKey(mappedHost)) throw throwable;
            int hostIndex = this.hostsToListIndexMap.get(mappedHost);
            long[] lArray = this.responseTimes;
            synchronized (this.responseTimes) {
                this.responseTimes[hostIndex] = 0L;
                // ** MonitorExit[lArray] (shouldn't be in output)
                throw throwable;
            }
        }
        String mappedHost = this.connectionsToHostsMap.remove(conn);
        if (mappedHost == null) return;
        if (!this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = this.hostsToListIndexMap.get(mappedHost);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[lArray] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator<ConnectionImpl> allConnections = this.liveConnections.values().iterator();
            while (allConnections.hasNext()) {
                try {
                    --this.activePhysicalConnections;
                    allConnections.next().close();
                }
                catch (SQLException sQLException) {}
            }
            if (!this.isClosed) {
                this.balancer.destroy();
                if (this.connectionGroup != null) {
                    this.connectionGroup.closeConnectionProxy(this);
                }
            }
            this.liveConnections.clear();
            this.connectionsToHostsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortAllConnectionsInternal() {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator<ConnectionImpl> allConnections = this.liveConnections.values().iterator();
            while (allConnections.hasNext()) {
                try {
                    --this.activePhysicalConnections;
                    allConnections.next().abortInternal();
                }
                catch (SQLException sQLException) {}
            }
            if (!this.isClosed) {
                this.balancer.destroy();
                if (this.connectionGroup != null) {
                    this.connectionGroup.closeConnectionProxy(this);
                }
            }
            this.liveConnections.clear();
            this.connectionsToHostsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortAllConnections(Executor executor) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator<ConnectionImpl> allConnections = this.liveConnections.values().iterator();
            while (allConnections.hasNext()) {
                try {
                    --this.activePhysicalConnections;
                    allConnections.next().abort(executor);
                }
                catch (SQLException e) {}
            }
            if (!this.isClosed) {
                this.balancer.destroy();
                if (this.connectionGroup != null) {
                    this.connectionGroup.closeConnectionProxy(this);
                }
            }
            this.liveConnections.clear();
            this.connectionsToHostsMap.clear();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invoke(proxy, method, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized Object invoke(Object proxy, Method method, Object[] args, boolean swapAtTransactionBoundary) throws Throwable {
        String methodName = method.getName();
        if ("getLoadBalanceSafeProxy".equals(methodName)) {
            return this.currentConn;
        }
        if ("equals".equals(methodName) && args.length == 1) {
            if (!(args[0] instanceof Proxy)) return this.equals(args[0]);
            return ((Proxy)args[0]).equals(this);
        }
        if ("hashCode".equals(methodName)) {
            return this.hashCode();
        }
        if ("close".equals(methodName)) {
            this.closeAllConnections();
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            this.closedExplicitly = true;
            return null;
        }
        if ("abortInternal".equals(methodName)) {
            this.abortAllConnectionsInternal();
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            return null;
        }
        if ("abort".equals(methodName) && args.length == 1) {
            this.abortAllConnections((Executor)args[0]);
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            return null;
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            if (this.autoReconnect && !this.closedExplicitly) {
                this.currentConn = null;
                this.pickNewConnection();
                this.isClosed = false;
                this.closedReason = null;
            } else {
                String reason = "No operations allowed after connection closed.";
                if (this.closedReason == null) throw SQLError.createSQLException(reason, "08003", null);
                reason = reason + "  " + this.closedReason;
                throw SQLError.createSQLException(reason, "08003", null);
            }
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
            ++this.transactionCount;
        }
        Object result = null;
        try {
            block29: {
                try {
                    this.lastUsed = System.currentTimeMillis();
                    result = method.invoke((Object)this.thisAsConnection, args);
                    if (result == null) break block29;
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                    }
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
                catch (InvocationTargetException e) {
                    this.dealWithInvocationException(e);
                    Object var9_9 = null;
                    if (!swapAtTransactionBoundary) return result;
                    if (!"commit".equals(methodName)) {
                        if (!"rollback".equals(methodName)) return result;
                    }
                    this.inTransaction = false;
                    String host = this.connectionsToHostsMap.get(this.currentConn);
                    if (host != null) {
                        long[] lArray = this.responseTimes;
                        // MONITORENTER : this.responseTimes
                        Integer hostIndex = this.hostsToListIndexMap.get(host);
                        if (hostIndex != null && hostIndex < this.responseTimes.length) {
                            this.responseTimes[hostIndex.intValue()] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                        }
                        // MONITOREXIT : lArray
                    }
                    this.pickNewConnection();
                    return result;
                }
            }
            Object var9_8 = null;
            if (!swapAtTransactionBoundary) return result;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) return result;
            }
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                Integer hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex.intValue()] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            return result;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!swapAtTransactionBoundary) throw throwable;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) throw throwable;
            }
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                Integer hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex.intValue()] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            throw throwable;
        }
    }

    protected synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            return;
        }
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        if (this.currentConn.isClosed()) {
            this.invalidateCurrentConnection();
        }
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        boolean pingBeforeReturn = this.currentConn.getLoadBalanceValidateConnectionOnSwapServer();
        int hostsToTry = this.hostList.size();
        for (int hostsTried = 0; hostsTried <= hostsToTry; ++hostsTried) {
            ConnectionImpl newConn = null;
            try {
                newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
                if (this.currentConn != null) {
                    if (pingBeforeReturn) {
                        if (pingTimeout == 0) {
                            newConn.ping();
                        } else {
                            newConn.pingInternal(true, pingTimeout);
                        }
                    }
                    this.syncSessionState(this.currentConn, newConn);
                }
                this.currentConn = newConn;
                return;
            }
            catch (SQLException e) {
                if (!this.shouldExceptionTriggerFailover(e) || newConn == null) continue;
                this.invalidateConnection(newConn);
                continue;
            }
        }
        this.isClosed = true;
        this.closedReason = "Connection closed after inability to pick valid new connection during fail-over.";
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class<?> clazz) {
        if (this.isInterfaceJdbc(clazz)) {
            Class<?>[] interfacesToProxy = this.getAllInterfacesToProxy(clazz);
            return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfacesToProxy, (InvocationHandler)this.createConnectionProxy(toProxy));
        }
        return toProxy;
    }

    private Class<?>[] getAllInterfacesToProxy(Class<?> clazz) {
        Class<?>[] interfacesToProxy = this.allInterfacesToProxy.get(clazz);
        if (interfacesToProxy != null) {
            return interfacesToProxy;
        }
        LinkedList interfaces = new LinkedList();
        Class<?> superClass = clazz;
        while (!superClass.equals(Object.class)) {
            Class<?>[] declared = superClass.getInterfaces();
            for (int i = 0; i < declared.length; ++i) {
                interfaces.add(declared[i]);
            }
            superClass = superClass.getSuperclass();
        }
        interfacesToProxy = new Class[interfaces.size()];
        interfaces.toArray(interfacesToProxy);
        this.allInterfacesToProxy.put(clazz, interfacesToProxy);
        return interfacesToProxy;
    }

    private boolean isInterfaceJdbc(Class<?> clazz) {
        if (this.jdbcInterfacesForProxyCache.containsKey(clazz)) {
            return this.jdbcInterfacesForProxyCache.get(clazz);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String packageName = interfaces[i].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName) || "com.mysql.jdbc".equals(packageName)) {
                this.jdbcInterfacesForProxyCache.put(clazz, true);
                return true;
            }
            if (!this.isInterfaceJdbc(interfaces[i])) continue;
            this.jdbcInterfacesForProxyCache.put(clazz, true);
            return true;
        }
        this.jdbcInterfacesForProxyCache.put(clazz, false);
        return false;
    }

    protected ConnectionErrorFiringInvocationHandler createConnectionProxy(Object toProxy) {
        return new ConnectionErrorFiringInvocationHandler(toProxy);
    }

    private static long getLocalTimeBestResolution() {
        if (getLocalTimeMethod != null) {
            try {
                return (Long)getLocalTimeMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            for (String host : this.hostList) {
                ConnectionImpl conn = this.liveConnections.get(host);
                if (conn == null) continue;
                try {
                    if (pingTimeout == 0) {
                        conn.ping();
                    } else {
                        conn.pingInternal(true, pingTimeout);
                    }
                    foundHost = true;
                }
                catch (SQLException e) {
                    --this.activePhysicalConnections;
                    if (host.equals(this.connectionsToHostsMap.get(this.currentConn))) {
                        this.closeAllConnections();
                        this.isClosed = true;
                        this.closedReason = "Connection closed because ping of current connection failed.";
                        throw e;
                    }
                    if (e.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                        if (se == null) {
                            se = e;
                        }
                    } else {
                        se = e;
                        if (this.isGlobalBlacklistEnabled()) {
                            this.addToGlobalBlacklist(host);
                        }
                    }
                    this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                }
            }
        }
        if (!foundHost) {
            this.closeAllConnections();
            this.isClosed = true;
            this.closedReason = "Connection closed due to inability to ping any active connections.";
            if (se != null) {
                throw se;
            }
            ((ConnectionImpl)this.currentConn).throwConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host, long timeout) {
        if (this.isGlobalBlacklistEnabled()) {
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, timeout);
            }
        }
    }

    public void addToGlobalBlacklist(String host) {
        this.addToGlobalBlacklist(host, System.currentTimeMillis() + (long)this.globalBlacklistTimeout);
    }

    public boolean isGlobalBlacklistEnabled() {
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Long> getGlobalBlacklist() {
        if (!this.isGlobalBlacklistEnabled()) {
            String localHostToRemove = this.hostToRemove;
            if (this.hostToRemove != null) {
                HashMap<String, Long> fakedBlacklist = new HashMap<String, Long>();
                fakedBlacklist.put(localHostToRemove, System.currentTimeMillis() + 5000L);
                return fakedBlacklist;
            }
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> blacklistClone = new HashMap<String, Long>(globalBlacklist.size());
        Map<String, Long> fakedBlacklist = globalBlacklist;
        synchronized (fakedBlacklist) {
            blacklistClone.putAll(globalBlacklist);
        }
        Set keys = blacklistClone.keySet();
        keys.retainAll(this.hostList);
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String host = (String)i.next();
            Long timeout = globalBlacklist.get(host);
            if (timeout == null || timeout >= System.currentTimeMillis()) continue;
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.remove(host);
            }
            i.remove();
        }
        if (keys.size() == this.hostList.size()) {
            return new HashMap<String, Long>(1);
        }
        return blacklistClone;
    }

    public boolean shouldExceptionTriggerFailover(SQLException ex) {
        return this.exceptionChecker.shouldExceptionTriggerFailover(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostWhenNotInUse(String host) throws SQLException {
        int timeBetweenChecks = 1000;
        long timeBeforeHardFail = 15000L;
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            this.addToGlobalBlacklist(host, timeBeforeHardFail + 1000L);
            long cur = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeBeforeHardFail < cur) {
                this.hostToRemove = host;
                if (host.equals(this.currentConn.getHost())) continue;
                this.removeHost(host);
                return;
            }
        }
        try {
            Thread.sleep(timeBetweenChecks);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.removeHost(host);
    }

    public synchronized void removeHost(String host) throws SQLException {
        if (this.connectionGroup != null) {
            if (this.connectionGroup.getInitialHosts().size() == 1 && this.connectionGroup.getInitialHosts().contains(host)) {
                throw SQLError.createSQLException("Cannot remove only configured host.", null);
            }
            this.hostToRemove = host;
            if (host.equals(this.currentConn.getHost())) {
                this.closeAllConnections();
            } else {
                this.connectionsToHostsMap.remove(this.liveConnections.remove(host));
                Integer idx = this.hostsToListIndexMap.remove(host);
                long[] newResponseTimes = new long[this.responseTimes.length - 1];
                int newIdx = 0;
                for (String copyHost : this.hostList) {
                    if (idx != null && idx < this.responseTimes.length) {
                        newResponseTimes[newIdx] = this.responseTimes[idx];
                        this.hostsToListIndexMap.put(copyHost, newIdx);
                    }
                    ++newIdx;
                }
                this.responseTimes = newResponseTimes;
            }
        }
    }

    public synchronized boolean addHost(String host) {
        if (this.hostsToListIndexMap.containsKey(host)) {
            return false;
        }
        long[] newResponseTimes = new long[this.responseTimes.length + 1];
        System.arraycopy(this.responseTimes, 0, newResponseTimes, 0, this.responseTimes.length);
        this.responseTimes = newResponseTimes;
        this.hostList.add(host);
        this.hostsToListIndexMap.put(host, this.responseTimes.length - 1);
        return true;
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized boolean inTransaction() {
        return this.inTransaction;
    }

    public synchronized long getTransactionCount() {
        return this.transactionCount;
    }

    public synchronized long getActivePhysicalConnectionCount() {
        return this.activePhysicalConnections;
    }

    public synchronized long getTotalPhysicalConnectionCount() {
        return this.totalPhysicalConnections;
    }

    public synchronized long getConnectionGroupProxyID() {
        return this.connectionGroupProxyID;
    }

    public synchronized String getCurrentActiveHost() {
        String o;
        MySQLConnection c = this.currentConn;
        if (c != null && (o = this.connectionsToHostsMap.get(c)) != null) {
            return o.toString();
        }
        return null;
    }

    public synchronized long getCurrentTransactionDuration() {
        if (this.inTransaction && this.transactionStartTime > 0L) {
            return LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
        }
        return 0L;
    }

    protected void syncSessionState(Connection initial, Connection target) throws SQLException {
        if (initial == null || target == null) {
            return;
        }
        target.setAutoCommit(initial.getAutoCommit());
        target.setCatalog(initial.getCatalog());
        target.setTransactionIsolation(initial.getTransactionIsolation());
        target.setReadOnly(initial.isReadOnly());
        target.setSessionMaxRows(initial.getSessionMaxRows());
    }

    static {
        try {
            getLocalTimeMethod = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        globalBlacklist = new HashMap<String, Long>();
        if (Util.isJdbc4()) {
            try {
                JDBC_4_LB_CONNECTION_CTOR = Class.forName("com.mysql.jdbc.JDBC4LoadBalancedMySQLConnection").getConstructor(LoadBalancingConnectionProxy.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            return result;
        }
    }
}

