/*
 * Decompiled with CFR 0.152.
 */
package com.deem.zkui.controller;

import com.deem.zkui.utils.ServletUtil;
import com.deem.zkui.utils.ZooKeeperUtil;
import com.deem.zkui.vo.LeafBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/acd/appconfig"})
public class RestAccess
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RestAccess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.debug("Rest Action!");
        ZooKeeper zk = null;
        try {
            Properties globalProps = (Properties)this.getServletContext().getAttribute("globalProps");
            String zkServer = globalProps.getProperty("zkServer");
            String[] zkServerLst = zkServer.split(",");
            String accessRole = "USER";
            if (globalProps.getProperty("blockPwdOverRest") != null && Boolean.valueOf(globalProps.getProperty("blockPwdOverRest")) == Boolean.FALSE) {
                accessRole = "ADMIN";
            }
            StringBuilder resultOut = new StringBuilder();
            String clusterName = request.getParameter("cluster");
            String appName = request.getParameter("app");
            String hostName = request.getParameter("host");
            String[] propNames = request.getParameterValues("propNames");
            String propValue = "";
            if (hostName == null) {
                hostName = ServletUtil.INSTANCE.getRemoteAddr(request);
            }
            zk = ServletUtil.INSTANCE.getZookeeper(request, response, zkServerLst[0], globalProps);
            LeafBean hostsNode = null;
            hostsNode = appName != null && ZooKeeperUtil.INSTANCE.nodeExists("/appconfig/hosts/" + hostName + ":" + appName, zk) ? ZooKeeperUtil.INSTANCE.getNodeValue(zk, "/appconfig/hosts", "/appconfig/hosts/" + hostName + ":" + appName, hostName + ":" + appName, accessRole) : ZooKeeperUtil.INSTANCE.getNodeValue(zk, "/appconfig/hosts", "/appconfig/hosts/" + hostName, hostName, accessRole);
            String lookupPath = hostsNode.getStrValue();
            logger.trace("Root Path:" + lookupPath);
            String[] pathElements = lookupPath.split("/");
            ArrayList<String> searchPath = new ArrayList<String>();
            StringBuilder pathSubSet = new StringBuilder();
            for (String pathElement : pathElements) {
                pathSubSet.append(pathElement);
                pathSubSet.append("/");
                searchPath.add(pathSubSet.substring(0, pathSubSet.length() - 1));
            }
            if (clusterName != null && appName == null) {
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + hostName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName + "/" + hostName);
                }
            } else if (appName != null && clusterName == null) {
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + hostName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + appName, zk)) {
                    searchPath.add(lookupPath + "/" + appName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + appName + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + appName + "/" + hostName);
                }
            } else if (appName != null && clusterName != null) {
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + hostName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + appName, zk)) {
                    searchPath.add(lookupPath + "/" + appName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + appName + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + appName + "/" + hostName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName + "/" + hostName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName + "/" + appName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName + "/" + appName);
                }
                if (ZooKeeperUtil.INSTANCE.nodeExists(lookupPath + "/" + clusterName + "/" + appName + "/" + hostName, zk)) {
                    searchPath.add(lookupPath + "/" + clusterName + "/" + appName + "/" + hostName);
                }
            }
            for (String propName : propNames) {
                propValue = null;
                for (String path : searchPath) {
                    logger.trace("Looking up " + path);
                    LeafBean propertyNode = ZooKeeperUtil.INSTANCE.getNodeValue(zk, path, path + "/" + propName, propName, accessRole);
                    if (propertyNode == null) continue;
                    propValue = propertyNode.getStrValue();
                }
                if (propValue == null) continue;
                resultOut.append(propName).append("=").append(propValue).append("\n");
            }
            response.setContentType("text/plain;charset=UTF-8");
            try (PrintWriter out = response.getWriter();){
                out.write(resultOut.toString());
            }
            if (zk != null) {
                ServletUtil.INSTANCE.closeZookeeper(zk);
            }
        }
        catch (InterruptedException | KeeperException ex) {
            logger.error(Arrays.toString(ex.getStackTrace()));
            ServletUtil.INSTANCE.renderError(request, response, ex.getMessage());
        }
        finally {
            if (zk != null) {
                ServletUtil.INSTANCE.closeZookeeper(zk);
            }
        }
    }
}

