package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.sys.model.Organization;
import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class OrganizationDto {
    /**
     * 组织ID
     **/
    private String id;

    /**
     * 组织编码
     **/
    @NotNull(message = "组织编码不为空")
    @Size(min = 1, max = 32, message = "组织编码必须在{min}-{max}之间")
    private String code;

    /**
     * 组织名称
     */
    @NotNull(message = "组织名称不为空")
    @Size(min = 1, max = 64, message = "组织名称必须在{min}-{max}之间")
    private String name;

    /**
     * 排序号
     **/
    @DecimalMax(value = "60000", message = "排序号不能超过{value}")
    @DecimalMin(value = "0", message = "排序号不能小于{value}")
    private Integer sortNo = 1;

    /**
     * 组织全称
     **/
    @NotNull(message = "组织全称不为空")
    @Size(min = 1, max = 255, message = "组织全称必须在{min}-{max}之间")
    private String fullName;

    /**
     * 描述
     */
    @Size(max = 128, message = "组织描述不能超过{max}")
    private String description;

    /**
     * 上级组织ID
     **/
    private Organization parent;

    private String supplierCode;
}
