package cn.quantgroup.big.stms.sys.dto;

import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author meng.xin@quantgroup.cn
 * @Date 2020-01-06 16:01
 * @Version 1.0
 */
@Data
public class AppDto {
    /**
     * 应用ID
     **/
    private Integer id;

    /**
     * 应用编码
     **/
    @NotNull(message = "应用编码不为空")
    @Size(min = 1, max = 32, message = "应用编码必须在{min}-{max}之间")
    private String code;

    /**
     * 应用名称
     */
    @NotNull(message = "应用名称不为空")
    @Size(min = 1, max = 64, message = "应用名称必须在{min}-{max}之间")
    private String name;

    /**
     * 排序号
     **/
    @DecimalMax(value = "60000", message = "排序号不能超过{value}")
    @DecimalMin(value = "0", message = "排序号不能小于{value}")
    private Integer sortNo = 1;

    /**
     * 描述
     */
    @Size(max = 128, message = "应用描述不能超过{max}")
    private String description;
}
