
package cn.quantgroup.big.stms.common.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


public class XssFilter implements Filter {
 
    private static Logger logger = LoggerFactory.getLogger(XssFilter.class);
    
    /**
     * 排除不过滤的request请求
     */
    public List<String> excludes = new ArrayList<>();
  
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException,ServletException {
        logger.debug("Xss Filter is Open");
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest) request);
        filterChain.doFilter(xssRequest, response);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        
    }

    @Override
    public void destroy() {
        
    }
}
