package cn.quantgroup.big.stms.common.dao;

import cn.quantgroup.big.stms.common.model.BaseTreeVO;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.query.Param;

import java.io.Serializable;


@NoRepositoryBean
public interface TreeRepository<T extends BaseTreeVO<T,ID>,ID extends Serializable> extends BaseRepository<T, ID>{
	
	/**
	 * 
	 * <p>date: 2019年10月16日 上午10:13:25</p>
	 * <p>description:  查询根节点的最大层级码</p>
	 * @author rong.yang/阳荣
	 * @param
	 * @return
	 */
	 @Query("select max(t.levelCode) from #{#entityName} t where t.parent.id is null")
	 String getMaxLevelCodeOfTopNode();
	 
	 @Query("select max(t.levelCode) from #{#entityName} t where t.parent.id = :parentId")
	 String getMaxLevelCodeOfChildren(@Param("parentId") ID parentId);
	 
}
