package cn.quantgroup.big.stms.common.aop;

import cn.quantgroup.big.stms.common.constants.HttpReqHeadKeyCnst;
import cn.quantgroup.big.stms.common.constants.StmsConstants;
import cn.quantgroup.big.stms.common.context.AppContextHolder;
import cn.quantgroup.big.stms.common.context.OnlineUser;
import cn.quantgroup.big.stms.common.enums.TenantEnum;
import cn.quantgroup.big.stms.common.exception.BizException;
import cn.quantgroup.big.stms.common.result.ResultCode;
import cn.quantgroup.big.stms.common.service.PermissionService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.Set;

/**
 * 权限处理
 * 
 * @author yutong
 * @data 2020年1月19日
 */
@Aspect
@Order(99)
@Component
@Slf4j
public class PermissionAop {

	@Autowired
	private PermissionService service;

	/**
	 * 先使用弱校验, 仅保证关键后端接口增加注解后校验权限
	 */
//	@Pointcut(value = "@annotation(cn.quantgroup.big.stms.common.annotation.Permission)")
	@Pointcut("execution(public * cn.quantgroup.big.stms..controller.*.*(..))  && !execution(public * cn.quantgroup.big.stms.sys.controller.OauthController.login(..))")
	private void cutPermission() {
	}

	@Around("cutPermission()")
	public Object checkPermission(ProceedingJoinPoint point) throws Throwable {
		MethodSignature ms = (MethodSignature) point.getSignature();
//		Permission permission = ms.getMethod().getAnnotation(Permission.class);
		OnlineUser onlineUser = AppContextHolder.getOnlineUser();

		ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
		HttpServletRequest request = attributes.getRequest();
		String tenantId = request.getHeader(HttpReqHeadKeyCnst.tenantId);
		Integer tenant = TenantEnum.KDSP.getTenantId();
		if(StringUtils.isNotEmpty(tenantId) && !"undefined".equals(tenantId)){
			tenant=Integer.parseInt(tenantId);
		}

		// 先判断用户&角色
		if (onlineUser == null) {
			return point.proceed();
		} else if (onlineUser.getId().equalsIgnoreCase(StmsConstants.ADMINISTRATOR_ID)) {
			log.debug("超级管理员访问，越过权限处理！");
			// 超级管理员
			return point.proceed();
		} else {
			String requestUrl = getRequestURL();
			log.info("用户:{},请求路径:{}", onlineUser.getName(), requestUrl);
//			String appCode = req.getHeader("AppCode");
			if (service.checkIgnore(requestUrl)) {
				// 忽略全局无需验证权限的接口
				return point.proceed();
			} else if (service.checkUri(tenant,requestUrl)) {
				// 通过redis中缓存的权限匹配
				return point.proceed();
			} else {
				throw new BizException("没有权限，拒绝访问", ResultCode.FORBIDDEN);
			}
		}
	}

	/**
	 * 从req中获取url
	 * @return
	 */
	private String getRequestURL() {
		// 判断用户登录应用系统(TODO 考虑通过域名或登录时指定的应用AppCode)
		HttpServletRequest req = ((ServletRequestAttributes) RequestContextHolder.currentRequestAttributes())
				.getRequest();
//		StringBuffer requestURL = req.getRequestURL();
//		String params_ymbol = "?";
//		String anchor_ymbol = "#";
//		if (requestURL.indexOf(anchor_ymbol) > -1) {
//			requestURL.deleteCharAt(requestURL.indexOf(anchor_ymbol));
//		}
//		if (requestURL.indexOf(params_ymbol) > -1) {
//			requestURL.deleteCharAt(requestURL.indexOf(params_ymbol));
//		}
		return req.getRequestURI();
	}

	/*
	 * 从RequestMapping中获取全部uri
	 */
	private String[] getMappingUri(MethodSignature ms) {
		Set<String> mappingUri = new HashSet<>();
		@SuppressWarnings("unchecked")
		RequestMapping tma = (RequestMapping) ms.getDeclaringType().getAnnotation(RequestMapping.class);
		RequestMapping mma = ms.getMethod().getAnnotation(RequestMapping.class);
		GetMapping gma = ms.getMethod().getAnnotation(GetMapping.class);
		PostMapping pma = ms.getMethod().getAnnotation(PostMapping.class);
		String[] tms = tma.value().length > 0 ? tma.value() : new String[] { "" };
		if (mma != null && mma.value().length > 0) {
			doubleloop(mappingUri, tms, mma.value());
		} else if (gma != null && gma.value().length > 0) {
			doubleloop(mappingUri, tms, gma.value());
		} else if (pma != null && pma.value().length > 0) {
			doubleloop(mappingUri, tms, pma.value());
		} else {
			mappingUri.add(tms[0]);
		}
		if (log.isDebugEnabled()) {
			for (String mu : mappingUri) {
				log.debug("用户访问后端controller层mapping: {}", mu);
			}
		}
		return mappingUri.toArray(new String[mappingUri.size()]);
	}

	private void doubleloop(Set<String> mappingUri, String[] ph1, String[] ph2) {
		for (String h1 : ph1) {
			for (String h2 : ph2) {
				mappingUri.add(h1 + h2);
			}
		}
	}
}
