package cn.quantgroup.big.stms;

import feign.Logger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@Slf4j
@ComponentScan(basePackages = {"cn.quantgroup.big.stms.*"})
@EnableTransactionManagement
@EnableAsync
@EnableFeignClients
public class STMSApplication {

	public static void main(String[] args) {
		SpringApplication.run(STMSApplication.class, args);
		log.info("big stms started...");
	}

	@Bean
	Logger.Level feignLoggerLevel() {
		return Logger.Level.FULL;
	}

}
