package cn.quantgroup.big.stms.sys.service.v2.impl;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import cn.quantgroup.big.stms.sys.dao.OrganizationDao;
import cn.quantgroup.big.stms.sys.model.Organization;
import cn.quantgroup.big.stms.sys.service.v2.IOrgSerivice;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class OrgServiceV2Impl implements IOrgSerivice {

  private final OrganizationDao organizationDao;
  @Value("${default.org.id}")
  private String defaultOrgId;
  public OrgServiceV2Impl(OrganizationDao organizationDao) {
    this.organizationDao = organizationDao;
  }

  @Override
  @Transactional
  public boolean frozen(String orgId) {
    Organization organization = organizationDao.findOne(orgId);

    /**
     * 如果是商户，则同时冻结下级店铺
     */
    if(defaultOrgId.equals(organization.getParent().getId())){
      List<Organization> orgs = organizationDao.findAllByParentId(orgId);
      orgs.forEach(i->i.setStatus(BasicDataStatus.INVALID));
      organizationDao.save(orgs);
    }
    organization.setStatus(BasicDataStatus.INVALID);
    return organizationDao.save(organization)!=null;
  }

  @Override
  @Transactional
  public boolean unFrozen(String orgId) {
    Organization organization = organizationDao.findOne(orgId);
    /**
     * 如果是商户，直接解冻；如果是门店，解冻当前门店和商户
     */
    if(defaultOrgId.equals(organization.getParent().getId())){
      organization.setStatus(BasicDataStatus.VALID);
    }else{
      Organization parent = organization.getParent();
      parent.setStatus(BasicDataStatus.VALID);
      organizationDao.save(parent);
    }

    return organizationDao.save(organization)!=null;
  }
}
