package cn.quantgroup.big.stms.sys.service;

import cn.quantgroup.big.stms.common.model.TreeNode;
import cn.quantgroup.big.stms.common.service.BasicDataService;
import cn.quantgroup.big.stms.sys.dto.ResourceLiteDto;
import cn.quantgroup.big.stms.sys.dto.UserDto;
import cn.quantgroup.big.stms.sys.dto.UserRoleDto;
import cn.quantgroup.big.stms.sys.dto.UserV2Dto;
import cn.quantgroup.big.stms.sys.model.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

public interface UserService extends BasicDataService<User, String> {

    /**
     * 根据登录账户获取用户信息
     *
     * @param account
     * @return
     */
    User getByAccount(String account);

    /**
     * 根据邮箱获取用户信息
     *
     * @param email
     * @return
     */
    User getByEmail(String email);
    /**
     * 根据手机号码获取用户信息
     *
     * @param phone
     * @return
     */
    User getByMobile(String phone);


    /**
     * 获取user翻页列表，包含组织机构和其所有子集
     *
     * @param user
     * @param pageable
     * @return
     */
    Page<User> findAllByOrgChildren(User user, Pageable pageable);


    /**
     * 获取当前组织下的用户列表
     * @param
     * @param pageable
     * @return
     */
    Page<UserDto> findAllByOrganizationDto(UserV2Dto userV2Dto, Pageable pageable);

    /**
     * 验证用户登录信息
     *
     * @param account
     * @param password
     * @return
     */
    boolean checkLogin(String account, String password);

    /**
     * 获取当前登录用户,指定应用的资源权限列表
     *
     * @param appCode 应用编码
     * @return
     */
    List<TreeNode<ResourceLiteDto>> getResources(String appCode,Integer tenantId);

    /**
     * 设置用户角色更新
     *
     * @param userRoleDto
     */
    void updateUserRole(UserRoleDto userRoleDto);

    /**
     * 获取用户角色信息
     *
     * @param appId 应用id, 可以为null
     * @param user
     * @return
     */
    List<UserRole> getUserRoles(Integer appId, User user);

    /**
     * 获取所有资源列表
     *
     * @param appId
     * @param user
     * @return
     */
    List<Resource> getResourcesList(Integer appId, User user);

    /**
     * 获取 不同租户对应的所有资源
     * @param appId
     * @param user
     * @return
     */
    Map<Integer,List<Resource>> getResourcesTenantList(Integer appId, User user);

    /**
     * 相关用户，分配了某些角色的用户
     *
     * @param roles
     * @return userIds, 返回用户id集合
     */
    List<String> relevantUser(Role... roles);

    /**
     * 相关用户，分配了某些资源的用户
     *
     * @param resources
     * @return userIds, 返回用户id集合
     */
    List<String> relevantUser(Resource... resources);

    /**
     * 获取当前用户，所有分配的应用系统
     *
     * @return
     */
    Set<App> getApps(Integer tenantId);

    /**
     * 新增用户
     * @param user
     * @param accessToken
     */
    public void saveUser(User user,String accessToken);

    void addMasterAccount(User user,String externalId,List<String> roleId);

    void addAccount(User user, List<String> roleIds);

    void updateAccount(User user, List<String> roleIds);
}
