package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import cn.quantgroup.big.stms.sys.model.Organization;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.Email;

import javax.validation.constraints.*;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class UserDto {

  /**
   * 用户ID
   */
  private String id;

  /**
   * 用户编码
   **/
  @NotNull(message = "用户编码不为空")
  @Size(min = 1, max = 32, message = "用户编码必须在{min}-{max}之间")
  private String code;

  /**
   * 用户名称
   */
  @NotNull(message = "用户名称不为空")
  @Size(min = 1, max = 64, message = "用户名称必须在{min}-{max}之间")
  private String name;

  @NotNull(message = "登录账号不能为空")
  @Size(min = 1, max = 32, message = "登录账号必须在{min}-{max}之间")
  private String account;

  @NotNull(message = "登录密码不能为空")
//    @Size(min = 13, max = 18, message = "登录密码必须在{min}-{max}之间")
  // 测试用例"123456789012!A"
  @Pattern(regexp = "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^a-zA-Z0-9]).{13,18}", message = "登录密码必须在13-18之间，且必须包含大小写字母、数字、特殊字符四类")
  private String password;

  @NotNull(message = "所属组织不能为空")
  private Organization organization;

  //@NotNull(message = "手机号不能为空")
  @Size(max = 15, message = "手机号不能超过{max}")
  private String mobile;

  @NotNull(message = "电子邮箱不能为空")
  @Size(min = 1, max = 64, message = "电子邮箱必须在{min}-{max}之间")
  @Email(message = "邮箱格式错误")
  private String email;
  /**
   * 描述
   */
  @Size(max = 128, message = "用户描述不能超过{max}")
  private String description;

  private String supplierCode;

  /**
   * 排序号
   **/
  @DecimalMax(value = "60000", message = "排序号不能超过{value}")
  @DecimalMin(value = "0", message = "排序号不能小于{value}")
  private Integer sortNo = 1;

  /**
   * 是否启用
   */
  private Boolean isEnable = true;

  /**
   * 初始密码是否已更改
   */
  private Boolean isChange = true;

  /**
   * 初始新建的角色id
   */
  private List<String> roleId;


  private List<RoleV2Dto> roles;


  /**
   * 创建时间
   */
  @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
  private LocalDateTime createTime;

  /**
   *
   */
  private BasicDataStatus status;
  @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
  private LocalDateTime lastLogin;

}
