package cn.quantgroup.big.stms.sys.dao.V2;

import cn.quantgroup.big.stms.sys.model.Role;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RoleV2Dao extends JpaRepository<Role, String> {

  @Query(value = "SELECT role.* FROM t_sys_role role JOIN t_sys_user_role u ON role.id = u.role_id  WHERE role.app_id = ?2 AND role.tenant_id = ?1 AND u.user_id = ?3"
      , nativeQuery = true)
  List<Role> findByCurrent(Integer tenantId, String applicationId, String userId);


  /**
   * 只查询回角色名和id、code
   *
   * @param userId
   * @return
   */


  @Query(value = "select r.* from t_sys_user_role u join t_sys_role  r on u.role_id=r.id  where u.user_id=?1"
      , nativeQuery = true)
  List<Role> findAllByUserId(String userId);

  @Modifying
  @Query(value = "DELETE FROM t_sys_role_resource WHERE role_id =?1",nativeQuery = true)
  int deleteAllByRoleId(String roleId);

}
