package cn.quantgroup.big.stms.common.utils;

import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

@Component
public class RandomSequenceUtils {

  /**
   * 获取指定长度的随机字符串
   *
   * @param length 生成字符串的长度
   * @return
   */
  public String getRandomSequence(int length) {
    List<Character> temp = new ArrayList<>(length);
    StringBuilder result = new StringBuilder(length);
    if (length <= 4) {
      throw new IllegalArgumentException("最小长度必须大于4");
    }
    //1.新添加四个不同字符，这样保证每个字符最少一次
    Random random = new Random(System.nanoTime());
    temp.add(this.getNumber(random));
    temp.add(this.getUpperLetter(random));
    temp.add(this.getLowerLetter(random));
    temp.add(this.getSpecial(random));

    //2.生成剩下的随机字符串
    IntStream.range(0, length - 4).forEach(i -> {
      switch (random.nextInt(4)) {
        case 0:
          temp.add(this.getNumber(random));
          break;
        case 1:
          temp.add(this.getUpperLetter(random));
          break;
        case 2:
          temp.add(this.getLowerLetter(random));
          break;
        case 3:
          temp.add(this.getSpecial(random));
          break;
      }
    });
    temp.forEach(result::append);
    return result.toString();
  }

  /**
   * 获取指定长度的随机字符串
   *
   * @param minLength 生成字符串的最小长度长度
   * @param maxLength 生成字符串的最大长度长度
   * @return
   */
  public String getRandomSequence(int minLength, int maxLength) {
    Random random = new Random(System.nanoTime());
    if (minLength >= maxLength) {
      throw new IllegalArgumentException("最小长度需要大于最大长度");
    }
    int length = minLength + random.nextInt(maxLength - minLength);
    return this.getRandomSequence(length);
  }


  private char getUpperLetter(Random random) {
    return (char) (65 + random.nextInt(26));
  }

  private char getLowerLetter(Random random) {
    return (char) (97 + random.nextInt(26));
  }

  private char getNumber(Random random) {
    return (char) (48 + random.nextInt(10));
  }

  private char getSpecial(Random random) {
    return (char) (33 + random.nextInt(13));
  }
}
