package cn.quantgroup.big.stms.common.service.impl;

import cn.quantgroup.big.stms.common.context.AppContextHolder;
import cn.quantgroup.big.stms.common.model.BaseVO;
import cn.quantgroup.big.stms.common.service.BaseService;

import java.io.Serializable;
import java.util.Date;

public abstract class BaseServiceImpl <T extends BaseVO<ID>, ID extends Serializable> extends BaseEntityServiceImpl<T, ID> implements BaseService<T,ID>{
	
	@Override
	protected void beforeSave(T entity) {
	    super.beforeSave(entity);
	    
	    if(isNew(entity)){
	        setAddNew(entity);
	    }else{
	        setUpdate(entity);
	    }
    }
	
	private boolean isNew(T entity){
	    if(null == entity || null == entity.getId()){
	        return true;
	    }
	    
	    return !existsById(entity.getId());
	}

	/**
	 * 新增时设置默认的属性
	 * @param entity
	 */
	protected void setAddNew(T entity) {
        Date now = new Date();
		entity.setCreateTime(now);
		entity.setCreator(AppContextHolder.getOnlineUser() ==  null ? null : AppContextHolder.getOnlineUser().getAccount());
		setDefaultValue(entity);
	}
	
	/**
	 * 设置默认值
	 */
	protected void setDefaultValue(T entity){
		
	}
	/**
	 * 更新时时设置默认的属性
	 * @param entity
	 */
	protected void setUpdate(T entity) {
        Date now = new Date();
		entity.setUpdateTime(now);
		entity.setUpdateUser(AppContextHolder.getOnlineUser() ==  null ? null : AppContextHolder.getOnlineUser().getAccount());
	}
}
