package cn.quantgroup.big.stms.common.controller;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Sort;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

public class BaseController {
    /**
     * 分页排序：创建时间-倒序，排序号-倒序
     *
     * @return
     */
    public Sort getSort() {
        List<Sort.Order> orders = new ArrayList<>();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "sortNo");
        Sort.Order order2 = new Sort.Order(Sort.Direction.DESC, "createTime");
        orders.add(order1);
        orders.add(order2);
        return new Sort(orders);
    }
    /**
     * 分页排序：创建时间-升序，排序号-倒序
     *
     * @return
     */
    public Sort getSortByCreateTimeAES() {
        List<Sort.Order> orders = new ArrayList<>();
        Sort.Order order1 = new Sort.Order(Sort.Direction.DESC, "sortNo");
        Sort.Order order2 = new Sort.Order(Sort.Direction.ASC, "createTime");
        orders.add(order1);
        orders.add(order2);
        return new Sort(orders);
    }

    /**
     * 创建匹配器，组装查询条件
     * 字符串模糊查询 & 忽略大小写
     *
     * @return
     */
    public ExampleMatcher getExampleMatcher() {
        // 创建匹配器，组装查询条件
        ExampleMatcher matcher = ExampleMatcher.matching() // 构建对象
                .withStringMatcher(ExampleMatcher.StringMatcher.CONTAINING) // 改变默认字符串匹配方式：模糊查询
                .withIgnoreCase(true) // 改变默认大小写忽略方式：忽略大小写
                .withIgnoreNullValues();
        return matcher;
    }

    /**
     * 获取对象的属性值为空的属性
     *
     * @param source
     * @return
     */
    public String[] getNullPropertyNames(Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<String>();
        for (java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) {
                emptyNames.add(pd.getName());
            }
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    /**
     * String转Date
     *
     * @return 返回时间类型 yyyy-MM-dd HH:mm:ss
     */
    public static Date getDate(String date) {
        if (StringUtils.isBlank(date)) {
            return new Date();
        }
        return getDate(date, null);
    }

    /**
     * String转Date
     *
     * @return 返回时间类型 yyyy-MM-dd HH:mm:ss
     */
    public static Date getDate(String date, String pattern) {
        if (StringUtils.isBlank(date)) {
            return new Date();
        }
        if (StringUtils.isBlank(pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        try {
            return formatter.parse(date);
        } catch (ParseException e) {
            return new Date();
        }
    }
}
