package cn.quantgroup.big.stms.sys.service;

import cn.quantgroup.big.stms.common.service.TreeService;
import cn.quantgroup.big.stms.sys.model.Organization;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface OrganizationService extends TreeService<Organization, String> {

    String validateSupplierName(String accessToken,String name);

    List<Organization> findBySupplierCode(String supplierCode);

    /**
     * 校验是否是供应链商户,
     * @param orgId
     * @return true:是商户  false:不是商户
     */
    Boolean validateIsSupplyMerchant(String orgId);


    @Transactional
    Organization saveAndSubmit(Organization organization);

    List<Organization> findAllByParentId(String parentId);
}
